/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.TimeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.plugin.SimplePlugin;

public final class FileUtil {
    public static String getFileName(File file) {
        return FileUtil.getFileName(file.getName());
    }

    public static String getFileName(String path) {
        Valid.checkBoolean(path != null && !path.isEmpty(), "The given path must not be empty!", new Object[0]);
        int pos = path.lastIndexOf("/");
        if (pos > 0) {
            path = path.substring(pos + 1, path.length());
        }
        if ((pos = path.lastIndexOf(".")) > 0) {
            path = path.substring(0, pos);
        }
        return path;
    }

    public static File getOrMakeFile(String path) {
        File file = FileUtil.getFile(path);
        return file.exists() ? file : FileUtil.createFile(path);
    }

    private static File createFile(String path) {
        File datafolder = SimplePlugin.getInstance().getDataFolder();
        int lastIndex = path.lastIndexOf(47);
        File directory = new File(datafolder, path.substring(0, lastIndex >= 0 ? lastIndex : 0));
        directory.mkdirs();
        File destination = new File(datafolder, path);
        try {
            destination.createNewFile();
        }
        catch (IOException ex) {
            System.out.println("Failed to create a new file " + path);
            ex.printStackTrace();
        }
        return destination;
    }

    public static File getFile(String path) {
        return new File(SimplePlugin.getInstance().getDataFolder(), path);
    }

    public static File[] getFiles(@NonNull String directory, @NonNull String extension) {
        File dataFolder;
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (!(dataFolder = new File(SimplePlugin.getData(), directory)).exists()) {
            dataFolder.mkdirs();
        }
        String finalExtension = extension;
        return dataFolder.listFiles(file -> !file.isDirectory() && file.getName().endsWith("." + finalExtension));
    }

    public static File createIfNotExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable t) {
                Common.throwError(t, "Could not create new " + file + " due to " + t);
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(File file) {
        Valid.checkNotNull(file, "File cannot be null");
        Valid.checkBoolean(file.exists(), "File: " + file + " does not exists!", new Object[0]);
        try {
            return Files.readAllLines(Paths.get(file.toURI()), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (IOException ee) {
                throw new FoException(ee, "Could not read lines from " + file.getName());
            }
        }
    }

    public static YamlConfiguration loadConfigurationStrict(File file) throws RuntimeException {
        Valid.checkNotNull(file, "File is null!");
        Valid.checkBoolean(file.exists(), "File " + file.getName() + " does not exists", new Object[0]);
        YamlConfiguration conf = new YamlConfiguration();
        try {
            FileUtil.checkFileForKnownErrors(file);
            conf.load(file);
        }
        catch (FileNotFoundException ex) {
            throw new FoException(ex, "Configuration file missing: " + file.getName());
        }
        catch (IOException ex) {
            throw new FoException(ex, "IO exception opening " + file.getName());
        }
        catch (InvalidConfigurationException ex) {
            throw new FoException(ex, "Malformed YAML file " + file.getName());
        }
        catch (Throwable t) {
            throw new FoException(t, "Error reading YAML file " + file.getName());
        }
        Valid.checkNotNull(conf, "Could not load: " + file.getName());
        return conf;
    }

    private static void checkFileForKnownErrors(File file) throws IOException {
        for (String line : Files.readAllLines(file.toPath())) {
            if (!line.contains("[*]")) continue;
            throw new FoException("Found [*] in your .yml file " + file + ". Please replace it with ['*'] instead.");
        }
    }

    public static void writeFormatted(String to, String message) {
        FileUtil.writeFormatted(to, null, message);
    }

    public static void writeFormatted(String to, String prefix, String message) {
        if (!(message = Common.stripColors(message).trim()).equalsIgnoreCase("none") && !message.isEmpty()) {
            for (String line : Common.splitNewline(message)) {
                if (line.isEmpty()) continue;
                FileUtil.write(to, "[" + TimeUtil.getFormattedDate() + "] " + (prefix != null ? prefix + ": " : "") + line);
            }
        }
    }

    public static void write(String to, String ... lines) {
        FileUtil.write(to, Arrays.asList(lines));
    }

    public static void write(String to, Collection<String> lines) {
        FileUtil.write(FileUtil.getOrMakeFile(to), lines, StandardOpenOption.APPEND);
    }

    public static void write(File to, Collection<String> lines, StandardOpenOption ... options) {
        try {
            Path path = Paths.get(to.toURI());
            try {
                Files.write(path, lines, StandardCharsets.UTF_8, (OpenOption[])options);
            }
            catch (ClosedByInterruptException ex) {
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(to, true));){
                    for (String line : lines) {
                        bw.append(System.lineSeparator() + line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to write to " + to);
            ex.printStackTrace();
        }
    }

    public static File extract(String path) {
        return FileUtil.extract(path, path);
    }

    public static File extract(String path, Function<String, String> replacer) {
        return FileUtil.extract(path, path, replacer);
    }

    public static File extract(String from, String to) {
        return FileUtil.extract(from, to, null);
    }

    public static File extract(String from, String to, @Nullable Function<String, String> replacer) {
        File file = new File(SimplePlugin.getInstance().getDataFolder(), to);
        InputStream is = FileUtil.getInternalResource("/" + from);
        Valid.checkNotNull(is, "Inbuilt file not found: " + from);
        if (file.exists()) {
            return file;
        }
        file = FileUtil.createFile(to);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = br.readLine()) != null) {
                    line = replacer != null ? replacer.apply(line) : line;
                    lines.add(line);
                }
            }
            Files.write(file.toPath(), lines, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            Common.error(ex, "Failed to extract " + from + " to " + to, "Error: %error");
        }
        return file;
    }

    public static void extractFolderFromJar(String folder, String destination) {
        Valid.checkBoolean(folder.endsWith("/"), "Folder must end with '/'! Given: " + folder, new Object[0]);
        Valid.checkBoolean(!folder.startsWith("/"), "Folder must not start with '/'! Given: " + folder, new Object[0]);
        Valid.checkBoolean(!FileUtil.getFile(folder).exists(), "Folder " + folder + " already exists!", new Object[0]);
        try (JarFile jarFile = new JarFile(SimplePlugin.getSource());){
            Enumeration<JarEntry> it = jarFile.entries();
            while (it.hasMoreElements()) {
                JarEntry jarEntry = it.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(folder) || entryName.equals(folder)) continue;
                FileUtil.extract(entryName);
            }
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to copy folder " + folder + " to " + destination);
        }
    }

    public static InputStream getInternalResource(String path) {
        InputStream is = ((Object)((Object)SimplePlugin.getInstance())).getClass().getResourceAsStream(path);
        if (is == null) {
            is = SimplePlugin.getInstance().getResource(path);
        }
        if (is == null) {
            try (JarFile jarFile = new JarFile(SimplePlugin.getSource());){
                JarEntry jarEntry = jarFile.getJarEntry(path);
                if (jarEntry != null) {
                    is = jarFile.getInputStream(jarEntry);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return is;
    }

    public static void zip(String sourceDirectory, String to) throws IOException {
        File parent = SimplePlugin.getInstance().getDataFolder().getParentFile().getParentFile();
        Path pathTo = Files.createFile(Paths.get(new File(parent, to + ".zip").toURI()), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(pathTo, new OpenOption[0]));){
            Path pathFrom = Paths.get(new File(parent, sourceDirectory).toURI());
            Files.walk(pathFrom, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && !path.toFile().getName().endsWith(".log")).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pathFrom.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    private FileUtil() {
    }
}

