/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.HitTracking;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.remain.Remain;

public final class EntityUtil {
    public static Player getTargetPlayer(Entity entity) {
        LivingEntity target = EntityUtil.getTarget(entity);
        return target instanceof Player && !HookManager.isNPC((Entity)target) ? (Player)target : null;
    }

    public static LivingEntity getTarget(Entity entity) {
        return entity instanceof Creature ? ((Creature)entity).getTarget() : null;
    }

    public static boolean isAggressive(Entity entity) {
        return entity instanceof Ghast || entity instanceof Slime || entity instanceof Wolf && ((Wolf)entity).isAngry() || entity instanceof Creature && !(entity instanceof Animals);
    }

    public static boolean isCreature(Entity entity) {
        return entity instanceof Slime || entity instanceof Wolf || entity instanceof Creature;
    }

    public static boolean canBeCleaned(Entity entity) {
        return entity instanceof FallingBlock || entity instanceof Item || entity instanceof Projectile || entity instanceof ExperienceOrb;
    }

    public static Item dropItem(Location location, ItemStack item, Consumer<Item> modifier) {
        return Remain.spawnItem(location, item, modifier);
    }

    public static void trackFalling(Entity entity, Runnable hitGroundListener) {
        EntityUtil.track(entity, 600, null, hitGroundListener);
    }

    public static void trackFlying(Entity entity, Runnable flyListener) {
        EntityUtil.track(entity, 600, flyListener, null);
    }

    public static void track(final Entity entity, final int timeoutTicks, final Runnable flyListener, final Runnable hitGroundListener) {
        if (flyListener == null && hitGroundListener == null) {
            throw new FoException("Cannot track entity with fly and hit listeners on null!");
        }
        final boolean isProjectile = entity instanceof Projectile;
        if (isProjectile && hitGroundListener != null) {
            HitTracking.addFlyingProjectile((Projectile)entity, event -> hitGroundListener.run());
        }
        Common.runTimer(1, (Runnable)new BukkitRunnable(){
            private int elapsedTicks = 0;

            public void run() {
                if (this.elapsedTicks++ > timeoutTicks) {
                    this.cancel();
                    return;
                }
                if (entity == null || entity.isDead() || !entity.isValid()) {
                    if (entity instanceof FallingBlock && !isProjectile && hitGroundListener != null) {
                        hitGroundListener.run();
                    }
                    this.cancel();
                    return;
                }
                if (entity.isOnGround()) {
                    if (!isProjectile && hitGroundListener != null) {
                        hitGroundListener.run();
                    }
                    this.cancel();
                } else if (flyListener != null) {
                    flyListener.run();
                }
            }
        });
    }

    public static void trackHit(Projectile projectile, HitListener hitTask) {
        HitTracking.addFlyingProjectile(projectile, hitTask);
    }

    private EntityUtil() {
    }

    static {
        Common.registerEvents(new HitTracking());
    }

    public static interface HitListener {
        public void onHit(ProjectileHitEvent var1);
    }
}

