/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.conversations.Conversable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.MathUtil;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.TimeUtil;
import org.mineacademy.fo.TimedCharSequence;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.exception.RegexTimeoutException;
import org.mineacademy.fo.model.DiscordSender;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.model.Replacer;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.SimpleLocalization;
import org.mineacademy.fo.settings.SimpleSettings;

public final class Common {
    private static final Pattern COLOR_REGEX = Pattern.compile("(?i)(&|\u00a7)([0-9A-F])");
    private static final Pattern RGB_HEX_COLOR_REGEX = Pattern.compile(Pattern.quote("{#") + "(.*?)" + Pattern.quote("}"));
    private static final CommandSender CONSOLE_SENDER = Bukkit.getServer() != null ? Bukkit.getServer().getConsoleSender() : null;
    private static final Map<String, Long> TIMED_TELL_CACHE = new HashMap<String, Long>();
    private static final Map<String, Long> TIMED_LOG_CACHE = new HashMap<String, Long>();
    public static boolean ADD_TELL_PREFIX = false;
    public static boolean ADD_LOG_PREFIX = true;
    private static String tellPrefix = "[" + SimplePlugin.getNamed() + "]";
    private static String logPrefix = "[" + SimplePlugin.getNamed() + "]";

    public static void setTellPrefix(String prefix) {
        tellPrefix = Common.colorize(prefix);
    }

    public static void setLogPrefix(String prefix) {
        logPrefix = Common.colorize(prefix);
    }

    public static void broadcast(String message, CommandSender sender) {
        Common.broadcast(message, Common.resolveSenderName(sender));
    }

    public static void broadcast(String message, String playerReplacement) {
        Common.broadcast(message.replace("{player}", playerReplacement));
    }

    public static void broadcast(String ... messages) {
        if (!Valid.isNullOrEmpty(messages)) {
            for (String message : messages) {
                for (Player player : Remain.getOnlinePlayers()) {
                    Common.tellJson((CommandSender)player, message);
                }
                Common.log(message);
            }
        }
    }

    public static void broadcastTo(Iterable<? extends CommandSender> recipients, String ... messages) {
        for (CommandSender commandSender : recipients) {
            Common.tell(commandSender, messages);
        }
    }

    public static void broadcastWithPerm(String showPermission, String message, boolean log) {
        if (message != null && !message.equals("none")) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!PlayerUtil.hasPerm((Permissible)player, showPermission)) continue;
                Common.tellJson((CommandSender)player, message);
            }
            if (log) {
                Common.log(message);
            }
        }
    }

    public static void broadcastWithPerm(String permission, @NonNull TextComponent message, boolean log) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String legacy = message.toLegacyText();
        if (!legacy.equals("none")) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!PlayerUtil.hasPerm((Permissible)player, permission)) continue;
                Remain.sendComponent((CommandSender)player, message);
            }
            if (log) {
                Common.log(legacy);
            }
        }
    }

    public static void tellTimedNoPrefix(int delaySeconds, CommandSender sender, String message) {
        boolean hadPrefix = ADD_TELL_PREFIX;
        ADD_TELL_PREFIX = false;
        Common.tellTimed(delaySeconds, sender, message);
        ADD_TELL_PREFIX = hadPrefix;
    }

    public static void tellTimed(int delaySeconds, CommandSender sender, String message) {
        if (!TIMED_TELL_CACHE.containsKey(message)) {
            Common.tell(sender, message);
            TIMED_TELL_CACHE.put(message, TimeUtil.currentTimeSeconds());
            return;
        }
        if (TimeUtil.currentTimeSeconds() - TIMED_TELL_CACHE.get(message) > (long)delaySeconds) {
            Common.tell(sender, message);
            TIMED_TELL_CACHE.put(message, TimeUtil.currentTimeSeconds());
        }
    }

    public static void tellLaterConversing(int delayTicks, Conversable conversable, String message) {
        Common.runLater(delayTicks, () -> Common.tellConversing(conversable, message));
    }

    public static void tellConversing(Conversable conversable, String message) {
        conversable.sendRawMessage(Common.colorize((ADD_TELL_PREFIX ? tellPrefix : "") + Common.removeFirstSpaces(message)).trim());
    }

    public static void tellLater(int delayTicks, CommandSender sender, String ... messages) {
        Common.runLater(delayTicks, () -> Common.tell(sender, messages));
    }

    public static void tellNoPrefix(CommandSender sender, Replacer replacer) {
        Common.tellNoPrefix(sender, replacer.getReplacedMessage());
    }

    public static void tellNoPrefix(CommandSender sender, String ... messages) {
        boolean was = ADD_TELL_PREFIX;
        ADD_TELL_PREFIX = false;
        Common.tell(sender, messages);
        ADD_TELL_PREFIX = was;
    }

    public static void tell(CommandSender sender, Collection<String> messages) {
        Common.tell(sender, Common.toArray(messages));
    }

    public static void tell(CommandSender sender, String ... messages) {
        for (String message : messages) {
            if (message == null || "none".equals(message)) continue;
            Common.tellJson(sender, message);
        }
    }

    public static void tellReplaced(CommandSender recipient, String message, Object ... replacements) {
        Common.tell(recipient, Replacer.replaceArray(message, replacements));
    }

    private static void tellJson(@NonNull CommandSender sender, String message) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (message.isEmpty() || "none".equals(message)) {
            return;
        }
        boolean hasPrefix = message.contains("{prefix}");
        message = Replacer.replaceArray(message, "player", Common.resolveSenderName(sender), "plugin_name", SimplePlugin.getNamed(), "plugin_version", SimplePlugin.getVersion());
        if ((message = Common.colorize(message)).startsWith("[JSON]")) {
            String stripped = message.substring(6);
            if (stripped.startsWith(" ")) {
                stripped = stripped.substring(1);
            }
            if (!stripped.isEmpty()) {
                Remain.sendJson(sender, stripped);
            }
        } else {
            for (String part : Common.splitNewline(message)) {
                String prefix = Common.removeSurroundingSpaces(tellPrefix);
                String toSend = (ADD_TELL_PREFIX && !hasPrefix && !prefix.isEmpty() ? prefix + " " : "") + part;
                if (sender instanceof Conversable && ((Conversable)sender).isConversing()) {
                    ((Conversable)sender).sendRawMessage(toSend);
                    continue;
                }
                sender.sendMessage(toSend);
            }
        }
    }

    public static String resolveSenderName(CommandSender sender) {
        return sender instanceof Player || sender instanceof DiscordSender ? sender.getName() : SimpleLocalization.CONSOLE_NAME;
    }

    private static String removeFirstSpaces(String message) {
        message = Common.getOrEmpty(message);
        while (message.startsWith(" ")) {
            message = message.substring(1);
        }
        return message;
    }

    public static List<String> colorize(List<String> list) {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(list);
        for (int i = 0; i < copy.size(); ++i) {
            String message = (String)copy.get(i);
            if (message == null) continue;
            copy.set(i, Common.colorize(message));
        }
        return copy;
    }

    public static String colorize(String ... messages) {
        return Common.colorize(StringUtils.join((Object[])messages, (String)"\n"));
    }

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        String result = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("{prefix}", message.startsWith(tellPrefix) ? "" : Common.removeSurroundingSpaces(tellPrefix.trim())).replace("{server}", SimpleLocalization.SERVER_PREFIX).replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase()).replace("{plugin_version}", SimplePlugin.getVersion()));
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
            Matcher match = RGB_HEX_COLOR_REGEX.matcher(result);
            while (match.find()) {
                String colorCode = match.group(1);
                String replacement = "";
                try {
                    replacement = ChatColor.of((String)("#" + colorCode)).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                result = result.replaceAll("\\{#" + colorCode + "\\}", replacement);
            }
        }
        return result;
    }

    private static String removeSurroundingSpaces(String message) {
        message = Common.getOrEmpty(message);
        while (message.endsWith(" ")) {
            message = message.substring(0, message.length() - 1);
        }
        return Common.removeFirstSpaces(message);
    }

    public static String[] revertColorizing(String[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = Common.revertColorizing(messages[i]);
        }
        return messages;
    }

    public static String revertColorizing(String message) {
        return message.replaceAll("(?i)\u00a7([0-9a-fk-or])", "&$1");
    }

    public static String stripColors(String message) {
        return message == null ? "" : message.replace("\u00a7x", "").replaceAll("(\u00a7|&)([0-9a-fk-or])", "");
    }

    public static boolean hasColors(String message) {
        return COLOR_REGEX.matcher(message).find();
    }

    public static String lastColor(String message) {
        String andLetter = Common.lastColorLetter(message);
        String colorChat = Common.lastColorChar(message);
        return !andLetter.isEmpty() ? andLetter : (!colorChat.isEmpty() ? colorChat : "");
    }

    public static String lastColorLetter(String message) {
        return Common.lastColor(message, '&');
    }

    public static String lastColorChar(String message) {
        return Common.lastColor(message, '\u00a7');
    }

    private static String lastColor(String msg, char colorChar) {
        int c = msg.lastIndexOf(colorChar);
        if (c != -1) {
            if (msg.length() > c + 1 && msg.substring(c + 1, c + 2).matches("([0-9a-fk-or])")) {
                return msg.substring(c, c + 2).trim();
            }
            return Common.lastColor(msg.substring(0, c), colorChar);
        }
        return "";
    }

    public static String consoleLine() {
        return "!-----------------------------------------------------!";
    }

    public static String consoleLineSmooth() {
        return "______________________________________________________________";
    }

    public static String chatLine() {
        return "*----------------------------------------------------*";
    }

    public static String chatLineSmooth() {
        return org.bukkit.ChatColor.STRIKETHROUGH + "\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015";
    }

    public static String configLine() {
        return "-------------------------------------------------------------------------------------------";
    }

    public static String scoreboardLine(int length) {
        String fill = "";
        for (int i = 0; i < length; ++i) {
            fill = fill + "-";
        }
        return "&m|" + fill + "|";
    }

    public static String plural(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + ofWhat + (count == 0L || count > 1L && !ofWhat.endsWith("s") ? "s" : "");
    }

    public static String pluralEs(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + ofWhat + (count == 0L || count > 1L && !ofWhat.endsWith("es") ? "es" : "");
    }

    public static String pluralIes(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + (count == 0L || count > 1L && !ofWhat.endsWith("ies") ? ofWhat.substring(0, ofWhat.length() - 1) + "ies" : ofWhat);
    }

    @Deprecated
    private static String getException(long count, String ofWhat) {
        SerializedMap exceptions = SerializedMap.ofArray("life", "lives", "wolf", "wolves", "knife", "knives", "wife", "wives", "calf", "calves", "leaf", "leaves", "potato", "potatoes", "tomato", "tomatoes", "hero", "heroes", "torpedo", "torpedoes", "veto", "vetoes", "foot", "feet", "tooth", "teeth", "goose", "geese", "man", "men", "woman", "women", "mouse", "mice", "die", "dice", "ox", "oxen", "child", "children", "person", "people", "penny", "pence", "sheep", "sheep", "fish", "fish", "deer", "deer", "moose", "moose", "swine", "swine", "buffalo", "buffalo", "shrimp", "shrimp", "trout", "trout", "spacecraft", "spacecraft", "cactus", "cacti", "axis", "axes", "analysis", "analyses", "crisis", "crises", "thesis", "theses", "datum", "data", "index", "indices");
        return exceptions.containsKey(ofWhat) ? count + " " + (count == 0L || count > 1L ? exceptions.getString(ofWhat) : ofWhat) : null;
    }

    @Deprecated
    public static String article(String ofWhat) {
        Valid.checkBoolean(ofWhat.length() > 0, "String cannot be empty", new Object[0]);
        List<String> syllables = Arrays.asList("a", "e", "i", "o", "u", "y");
        return (syllables.contains(ofWhat.toLowerCase().trim().substring(0, 1)) ? "an" : "a") + " " + ofWhat;
    }

    public static String fancyBar(int min, char minChar, int max, char maxChar, org.bukkit.ChatColor delimiterColor) {
        int i;
        String formatted = "";
        for (i = 0; i < min; ++i) {
            formatted = formatted + minChar;
        }
        formatted = formatted + delimiterColor;
        for (i = 0; i < max - min; ++i) {
            formatted = formatted + maxChar;
        }
        return formatted;
    }

    public static String shortLocation(Vector vec) {
        return " [" + MathUtil.formatOneDigit(vec.getX()) + ", " + MathUtil.formatOneDigit(vec.getY()) + ", " + MathUtil.formatOneDigit(vec.getZ()) + "]";
    }

    public static String shortLocation(Location loc) {
        if (loc == null) {
            return "Location(null)";
        }
        if (loc.equals((Object)new Location(null, 0.0, 0.0, 0.0))) {
            return "Location(null, 0, 0, 0)";
        }
        Valid.checkNotNull(loc.getWorld(), "Cannot shorten a location with null world!");
        return loc.getWorld().getName() + " [" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + "]";
    }

    public static String duplicate(String text, int nTimes) {
        Valid.checkBoolean(nTimes > 0, "Cannot duplicate 0 times!", new Object[0]);
        String toDuplicate = new String(text);
        for (int i = 1; i < nTimes; ++i) {
            text = text + toDuplicate;
        }
        return text;
    }

    public static boolean doesPluginExist(String plugin) {
        boolean hooked = Common.doesPluginExistSilently(plugin);
        if (hooked) {
            Common.log("&3Hooked into&8: &f" + plugin);
        }
        return hooked;
    }

    public static boolean doesPluginExistSilently(String pluginName) {
        Plugin found;
        Plugin lookup = null;
        for (Plugin otherPlugin : Bukkit.getPluginManager().getPlugins()) {
            if (!otherPlugin.getName().equals(pluginName)) continue;
            lookup = otherPlugin;
            break;
        }
        if ((found = lookup) == null) {
            return false;
        }
        if (!found.isEnabled()) {
            Common.runLaterAsync(0, () -> Valid.checkBoolean(found.isEnabled(), SimplePlugin.getNamed() + " could not hook into " + pluginName + " as the plugin is disabled! (DO NOT REPORT THIS TO " + SimplePlugin.getNamed() + ", look for errors above and contact support of '" + pluginName + "')", new Object[0]));
        }
        return true;
    }

    public static void dispatchCommand(@Nullable CommandSender playerReplacement, @NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (command.isEmpty() || command.equalsIgnoreCase("none")) {
            return;
        }
        Common.runLater(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)Common.colorize(command.replace("{player}", playerReplacement == null ? "" : Common.resolveSenderName(playerReplacement)))));
    }

    public static void dispatchCommandAsPlayer(@NonNull Player playerSender, @NonNull String command) {
        if (playerSender == null) {
            throw new NullPointerException("playerSender is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (command.isEmpty() || command.equalsIgnoreCase("none")) {
            return;
        }
        Common.runLater(() -> playerSender.performCommand(Common.colorize(command.replace("{player}", Common.resolveSenderName((CommandSender)playerSender)))));
    }

    public static void logTimed(int delaySec, String msg) {
        if (!TIMED_LOG_CACHE.containsKey(msg)) {
            Common.log(msg);
            TIMED_LOG_CACHE.put(msg, TimeUtil.currentTimeSeconds());
            return;
        }
        if (TimeUtil.currentTimeSeconds() - TIMED_LOG_CACHE.get(msg) > (long)delaySec) {
            Common.log(msg);
            TIMED_LOG_CACHE.put(msg, TimeUtil.currentTimeSeconds());
        }
    }

    public static void logF(String format, Object ... args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        String formatted = Common.format(format, args);
        Common.log(false, formatted);
    }

    public static String format(String format, Object ... args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            args[i] = Common.simplify(arg);
        }
        return String.format(format, args);
    }

    public static void log(List<String> messages) {
        Common.log(Common.toArray(messages));
    }

    public static void log(String ... messages) {
        Common.log(true, messages);
    }

    public static void logNoPrefix(String ... messages) {
        Common.log(false, messages);
    }

    private static void log(boolean addLogPrefix, String ... messages) {
        if (messages == null) {
            return;
        }
        for (String message : messages) {
            if (message.equals("none") || message.isEmpty()) continue;
            if (Common.stripColors(message).replace(" ", "").isEmpty()) {
                if (CONSOLE_SENDER == null) {
                    System.out.println(" ");
                    continue;
                }
                CONSOLE_SENDER.sendMessage("  ");
                continue;
            }
            if ((message = Common.colorize(message)).startsWith("[JSON]")) {
                String stripped = message.replaceFirst("\\[JSON\\]", "").trim();
                if (stripped.isEmpty()) continue;
                Common.log(Remain.toLegacyText(stripped, false));
                continue;
            }
            for (String part : Common.splitNewline(message)) {
                String log = ((addLogPrefix && ADD_LOG_PREFIX ? Common.removeSurroundingSpaces(logPrefix) + " " : "") + Common.getOrEmpty(part).replace("\n", Common.colorize("\n&r"))).trim();
                if (CONSOLE_SENDER != null) {
                    CONSOLE_SENDER.sendMessage(log);
                    continue;
                }
                System.out.println("[" + SimplePlugin.getNamed() + "] " + Common.stripColors(log));
            }
        }
    }

    public static void logFramed(String ... messages) {
        Common.logFramed(false, messages);
    }

    public static void logFramed(boolean disablePlugin, String ... messages) {
        if (messages != null && !Valid.isNullOrEmpty(messages)) {
            Common.log("&7" + Common.consoleLine());
            for (String msg : messages) {
                Common.log(" &c" + msg);
            }
            if (disablePlugin) {
                Common.log(" &cPlugin is now disabled.");
            }
            Common.log("&7" + Common.consoleLine());
        }
        if (disablePlugin) {
            Bukkit.getPluginManager().disablePlugin((Plugin)SimplePlugin.getInstance());
        }
    }

    public static void error(Throwable t, String ... messages) {
        if (!(t instanceof FoException)) {
            Debugger.saveError(t, messages);
        }
        Debugger.printStackTrace(t);
        Common.logFramed(Common.replaceErrorVariable(t, messages));
    }

    public static void throwError(Throwable throwable, String ... messages) {
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (messages != null) {
            Common.logFramed(false, Common.replaceErrorVariable(throwable, messages));
        }
        if (!(throwable instanceof FoException)) {
            Debugger.saveError(throwable, messages);
        }
        Remain.sneaky(throwable);
    }

    private static String[] replaceErrorVariable(Throwable throwable, String ... msgs) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String throwableName = throwable == null ? "Unknown error." : throwable.getClass().getSimpleName();
        String throwableMessage = throwable == null || throwable.getMessage() == null || throwable.getMessage().isEmpty() ? "" : ": " + throwable.getMessage();
        for (int i = 0; i < msgs.length; ++i) {
            msgs[i] = msgs[i].replace("%error", throwableName + throwableMessage);
        }
        return msgs;
    }

    public static boolean regExMatch(String regex, String message) {
        return Common.regExMatch(Common.compilePattern(regex), message);
    }

    public static boolean regExMatch(Pattern regex, String message) {
        return Common.regExMatch(Common.compileMatcher(regex, message));
    }

    public static boolean regExMatch(Matcher matcher) {
        try {
            return matcher != null ? matcher.find() : false;
        }
        catch (RegexTimeoutException ex) {
            FileUtil.writeFormatted("error.log", null, "Matching timed out (bad regex?) (plugin ver. " + SimplePlugin.getVersion() + ")! \nString checked: " + ex.getCheckedMessage() + "\nRegex: " + (matcher != null ? matcher.pattern().pattern() : "null") + "");
            Common.logFramed(false, "&cRegex check took too long! (allowed: " + SimpleSettings.REGEX_TIMEOUT + "ms)", "&cRegex:&f " + (matcher != null ? matcher.pattern().pattern() : matcher), "&cMessage:&f " + ex.getCheckedMessage());
            return false;
        }
    }

    public static Matcher compileMatcher(@NonNull Pattern pattern, String message) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        try {
            String strippedMessage = SimplePlugin.getInstance().regexStripColors() ? Common.stripColors(message) : message;
            int timeout = SimpleSettings.REGEX_TIMEOUT;
            return pattern.matcher(new TimedCharSequence(strippedMessage, timeout));
        }
        catch (RegexTimeoutException ex) {
            FileUtil.writeFormatted("error.log", null, "Regex check timed out (bad regex?) (plugin ver. " + SimplePlugin.getVersion() + ")! \nString checked: " + ex.getCheckedMessage() + "\nRegex: " + pattern.pattern() + "");
            Common.throwError(ex, "&cChecking a message took too long! (limit: " + SimpleSettings.REGEX_TIMEOUT + ")", "&cReg-ex:&f " + pattern.pattern(), "&cString:&f " + ex.getCheckedMessage());
            return null;
        }
    }

    public static Matcher compileMatcher(String regex, String message) {
        return Common.compileMatcher(Common.compilePattern(regex), message);
    }

    public static Pattern compilePattern(String regex) {
        SimplePlugin instance = SimplePlugin.getInstance();
        Pattern pattern = null;
        regex = SimplePlugin.getInstance().regexStripColors() ? Common.stripColors(regex) : regex;
        try {
            pattern = instance.regexCaseInsensitive() ? Pattern.compile(regex, instance.regexUnicode() ? 66 : 2) : (instance.regexUnicode() ? Pattern.compile(regex, 64) : Pattern.compile(regex));
        }
        catch (PatternSyntaxException ex) {
            Common.throwError(ex, "Malformed regex: '" + regex + "'", "Use online services (like &fregex101.com&f) for fixing errors");
            return null;
        }
        return pattern;
    }

    @SafeVarargs
    public static <T> List<T> joinArrays(Iterable<T> ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        for (Iterable<T> array : arrays) {
            for (T element : array) {
                all.add(element);
            }
        }
        return all;
    }

    public static <T extends CommandSender> String joinPlayersExcept(Iterable<T> array, String nameToIgnore) {
        Iterator<T> it = array.iterator();
        String message = "";
        while (it.hasNext()) {
            CommandSender next = (CommandSender)it.next();
            if (next.getName().equals(nameToIgnore)) continue;
            message = message + next.getName() + (it.hasNext() ? ", " : "");
        }
        return message.endsWith(", ") ? message.substring(0, message.length() - 2) : message;
    }

    public static String joinRange(int startIndex, String[] array) {
        return Common.joinRange(startIndex, array.length, array);
    }

    public static String joinRange(int startIndex, int stopIndex, String[] array) {
        return Common.joinRange(startIndex, stopIndex, array, " ");
    }

    public static String joinRange(int start, int stop, String[] array, String delimiter) {
        String joined = "";
        for (int i = start; i < MathUtil.range(stop, 0, array.length); ++i) {
            joined = joined + (joined.isEmpty() ? "" : delimiter) + array[i];
        }
        return joined;
    }

    public static <T> String join(T[] array) {
        return array == null ? "null" : Common.join(Arrays.asList(array));
    }

    public static <T> String join(Iterable<T> array) {
        return array == null ? "null" : Common.join(array, ", ");
    }

    public static <T> String join(Iterable<T> array, String delimiter) {
        return Common.join(array, delimiter, (T object) -> object == null ? "" : Common.simplify(object));
    }

    public static <T> String join(T[] array, String delimiter, Stringer<T> stringer) {
        Valid.checkNotNull(array, "Cannot join null array!");
        return Common.join(Arrays.asList(array), delimiter, stringer);
    }

    public static <T> String join(Iterable<T> array, String delimiter, Stringer<T> stringer) {
        Iterator<T> it = array.iterator();
        String message = "";
        while (it.hasNext()) {
            T next = it.next();
            if (next == null) continue;
            message = message + stringer.toString(next) + (it.hasNext() ? delimiter : "");
        }
        return message;
    }

    public static String simplify(Object arg) {
        if (arg instanceof Entity) {
            return Remain.getName((Entity)arg);
        }
        if (arg instanceof CommandSender) {
            return ((CommandSender)arg).getName();
        }
        if (arg instanceof World) {
            return ((World)arg).getName();
        }
        if (arg instanceof Location) {
            return Common.shortLocation((Location)arg);
        }
        if (arg.getClass() == Double.TYPE || arg.getClass() == Float.TYPE) {
            return MathUtil.formatTwoDigits((Double)arg);
        }
        if (arg instanceof Collection) {
            return Common.join((Collection)arg, ", ", Common::simplify);
        }
        if (arg instanceof Enum) {
            return ((Enum)arg).name();
        }
        return arg.toString();
    }

    public static List<String> getWorldNames() {
        return Common.convert(Bukkit.getWorlds(), World::getName);
    }

    public static List<String> getPlayerNames() {
        return Common.getPlayerNames(true, null);
    }

    public static List<String> getPlayerNames(boolean includeVanished) {
        return Common.getPlayerNames(includeVanished, null);
    }

    public static List<String> getPlayerNames(boolean includeVanished, @Nullable Player otherPlayer) {
        ArrayList<String> found = new ArrayList<String>();
        for (Player player : Remain.getOnlinePlayers()) {
            if (PlayerUtil.isVanished(player, otherPlayer) && !includeVanished) continue;
            found.add(player.getName());
        }
        return found;
    }

    public static List<String> getPlayerNicknames(boolean includeVanished) {
        return Common.getPlayerNicknames(includeVanished, null);
    }

    public static List<String> getPlayerNicknames(boolean includeVanished, @Nullable Player otherPlayer) {
        ArrayList<String> found = new ArrayList<String>();
        for (Player player : Remain.getOnlinePlayers()) {
            if (PlayerUtil.isVanished(player, otherPlayer) && !includeVanished) continue;
            found.add(HookManager.getNick((CommandSender)player));
        }
        return found;
    }

    public static <OLD, NEW> List<NEW> convert(Iterable<OLD> list, TypeConverter<OLD, NEW> converter) {
        ArrayList<NEW> copy = new ArrayList<NEW>();
        for (OLD old : list) {
            NEW result = converter.convert(old);
            if (result == null) continue;
            copy.add(converter.convert(old));
        }
        return copy;
    }

    public static <OLD, NEW> StrictList<NEW> convertStrict(Iterable<OLD> list, TypeConverter<OLD, NEW> converter) {
        StrictList<NEW> copy = new StrictList<NEW>();
        for (OLD old : list) {
            copy.add(converter.convert(old));
        }
        return copy;
    }

    public static <OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> Map<NEW_KEY, NEW_VALUE> convert(Map<OLD_KEY, OLD_VALUE> oldMap, MapToMapConverter<OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> converter) {
        HashMap newMap = new HashMap();
        oldMap.entrySet().forEach(e -> newMap.put(converter.convertKey(e.getKey()), converter.convertValue(e.getValue())));
        return newMap;
    }

    public static <OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> StrictMap<NEW_KEY, NEW_VALUE> convertStrict(Map<OLD_KEY, OLD_VALUE> oldMap, MapToMapConverter<OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> converter) {
        StrictMap newMap = new StrictMap();
        oldMap.entrySet().forEach(e -> newMap.put(converter.convertKey(e.getKey()), converter.convertValue(e.getValue())));
        return newMap;
    }

    public static <LIST_KEY, OLD_KEY, OLD_VALUE> StrictList<LIST_KEY> convertToList(Map<OLD_KEY, OLD_VALUE> map, MapToListConverter<LIST_KEY, OLD_KEY, OLD_VALUE> converter) {
        StrictList<LIST_KEY> list = new StrictList<LIST_KEY>();
        for (Map.Entry<OLD_KEY, OLD_VALUE> e : map.entrySet()) {
            list.add(converter.convert(e.getKey(), e.getValue()));
        }
        return list;
    }

    public static <OLD_TYPE, NEW_TYPE> List<NEW_TYPE> convert(OLD_TYPE[] oldArray, TypeConverter<OLD_TYPE, NEW_TYPE> converter) {
        ArrayList<NEW_TYPE> newList = new ArrayList<NEW_TYPE>();
        for (OLD_TYPE old : oldArray) {
            newList.add(converter.convert(old));
        }
        return newList;
    }

    @Deprecated
    public static String[] splitNewline(String message) {
        if (!SimplePlugin.getInstance().enforeNewLine()) {
            return message.split("\n");
        }
        String delimiter = "KANGARKOJESUUPER";
        char[] chars = message.toCharArray();
        String parts = "";
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ('\\' == c && i + 1 < chars.length && 'n' == chars[i + 1]) {
                ++i;
                parts = parts + "KANGARKOJESUUPER";
                continue;
            }
            parts = parts + c;
        }
        return parts.split("KANGARKOJESUUPER");
    }

    public static <T> List<T> removeNullAndEmpty(T[] array) {
        return array != null ? Common.removeNullAndEmpty(Arrays.asList(array)) : new ArrayList();
    }

    public static <T> List<T> removeNullAndEmpty(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>();
        for (T key : list) {
            if (key == null) continue;
            if (key instanceof String) {
                if (((String)key).isEmpty()) continue;
                copy.add(key);
                continue;
            }
            copy.add(key);
        }
        return copy;
    }

    public static String[] replaceNullWithEmpty(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != null) continue;
            list[i] = "";
        }
        return list;
    }

    public static <T> T getOrDefault(T[] array, int index, T def) {
        return index < array.length ? array[index] : def;
    }

    public static String getOrEmpty(String input) {
        return input == null || "none".equalsIgnoreCase(input) ? "" : input;
    }

    public static String getOrNull(String input) {
        return input == null || "none".equalsIgnoreCase(input) || input.isEmpty() ? null : input;
    }

    public static <T> T getOrDefault(T value, T def) {
        Valid.checkNotNull(def, "The default value must not be null!");
        if (value instanceof String && ("none".equalsIgnoreCase((String)value) || "".equals(value))) {
            return def;
        }
        return value != null ? value : def;
    }

    public static <T> T getNext(T given, List<T> list, boolean forward) {
        if (given == null && list.isEmpty()) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance((given != null ? given : list.get(0)).getClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return (T)Common.getNext(given, array, forward);
    }

    public static <T> T getNext(T given, T[] array, boolean forward) {
        if (array.length == 0) {
            return null;
        }
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            T element = array[i];
            if (!element.equals(given)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            int nextIndex = index + (forward ? 1 : -1);
            return nextIndex >= array.length ? array[0] : (nextIndex < 0 ? array[array.length - 1] : array[nextIndex]);
        }
        return null;
    }

    public static String[] toArray(Collection<String> array) {
        return array.toArray(new String[array.size()]);
    }

    public static <T> ArrayList<T> toList(T ... array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    public static <T> List<T> toList(Iterable<T> it) {
        ArrayList list = new ArrayList();
        it.forEach(el -> list.add(el));
        return list;
    }

    public static <T> T[] reverse(T[] array) {
        if (array == null) {
            return null;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <A, B> Map<A, B> newHashMap(A firstKey, B firstValue) {
        HashMap<A, B> map = new HashMap<A, B>();
        map.put(firstKey, firstValue);
        return map;
    }

    public static void runLaterIf(boolean condition, Runnable task) {
        if (condition) {
            Common.runLater(1, task);
        } else {
            task.run();
        }
    }

    public static <T extends Runnable> BukkitTask runLater(T task) {
        return Common.runLater(1, task);
    }

    public static BukkitTask runLater(int delayTicks, Runnable task) {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        SimplePlugin instance = SimplePlugin.getInstance();
        return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTask((Plugin)instance) : scheduler.runTask((Plugin)instance, task)) : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskLater((Plugin)instance, (long)delayTicks) : scheduler.runTaskLater((Plugin)instance, task, (long)delayTicks)));
    }

    public static BukkitTask runAsync(Runnable task) {
        return Common.runLaterAsync(0, task);
    }

    public static BukkitTask runLaterAsync(Runnable task) {
        return Common.runLaterAsync(0, task);
    }

    public static BukkitTask runLaterAsync(int delayTicks, Runnable task) {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        SimplePlugin instance = SimplePlugin.getInstance();
        return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskAsynchronously((Plugin)instance) : scheduler.runTaskAsynchronously((Plugin)instance, task)) : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskLaterAsynchronously((Plugin)instance, (long)delayTicks) : scheduler.runTaskLaterAsynchronously((Plugin)instance, task, (long)delayTicks)));
    }

    public static BukkitTask runTimer(int repeatTicks, Runnable task) {
        return Common.runTimer(0, repeatTicks, task);
    }

    public static BukkitTask runTimer(int delayTicks, int repeatTicks, Runnable task) {
        return Common.runIfDisabled(task) ? null : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskTimer((Plugin)SimplePlugin.getInstance(), (long)delayTicks, (long)repeatTicks) : Bukkit.getScheduler().runTaskTimer((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
    }

    public static BukkitTask runTimerAsync(int repeatTicks, Runnable task) {
        return Common.runTimerAsync(0, repeatTicks, task);
    }

    public static BukkitTask runTimerAsync(int delayTicks, int repeatTicks, Runnable task) {
        return Common.runIfDisabled(task) ? null : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskTimerAsynchronously((Plugin)SimplePlugin.getInstance(), (long)delayTicks, (long)repeatTicks) : Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
    }

    private static boolean runIfDisabled(Runnable run) {
        if (!SimplePlugin.getInstance().isEnabled()) {
            run.run();
            return true;
        }
        return false;
    }

    public static boolean callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
        return event instanceof Cancellable ? !((Cancellable)event).isCancelled() : true;
    }

    public static void registerEvents(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)SimplePlugin.getInstance());
    }

    public static Map<String, Object> getMapFromSection(@NonNull Object mapOrSection) {
        if (mapOrSection == null) {
            throw new NullPointerException("mapOrSection is marked non-null but is null");
        }
        Map map = mapOrSection instanceof Map ? (Map)mapOrSection : (mapOrSection instanceof MemorySection ? (Map)ReflectionUtil.getFieldContent(mapOrSection, "map") : null);
        Valid.checkNotNull(map, "Unexpected " + mapOrSection.getClass().getSimpleName() + " '" + mapOrSection + "'. Must be Map or MemorySection! (Do not just send config name here, but the actual section with get('section'))");
        return map;
    }

    public static boolean isDomainReachable(String url, int timeout) {
        url = url.replaceFirst("^https", "http");
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            c.setConnectTimeout(timeout);
            c.setReadTimeout(timeout);
            c.setRequestMethod("HEAD");
            int responseCode = c.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Common() {
    }

    public static String getTellPrefix() {
        return tellPrefix;
    }

    public static String getLogPrefix() {
        return logPrefix;
    }

    public static interface MapToMapConverter<A, B, C, D> {
        public C convertKey(A var1);

        public D convertValue(B var1);
    }

    public static interface MapToListConverter<O, K, V> {
        public O convert(K var1, V var2);
    }

    public static interface TypeConverter<Old, New> {
        public New convert(Old var1);
    }

    public static interface Stringer<T> {
        public String toString(T var1);
    }
}

