/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.DefaultFontInfo;
import org.mineacademy.fo.MathUtil;
import org.mineacademy.fo.RandomUtil;

public final class ChatUtil {
    public static final int CENTER_PX = 154;
    public static final int VISIBLE_CHAT_LINES = 20;

    public static String center(String message) {
        return ChatUtil.center(message, ' ', ChatColor.WHITE);
    }

    public static String center(String message, int centerPx) {
        return ChatUtil.center(message, ' ', ChatColor.WHITE, centerPx);
    }

    public static String center(String message, char space, ChatColor spaceColor) {
        return ChatUtil.center(message, space, spaceColor, 154);
    }

    public static String center(String message, char space, ChatColor spaceColor, int centerPx) {
        if (message == null || message.equals("")) {
            return "";
        }
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '&') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo defaultFont = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? defaultFont.getBoldLength() : defaultFont.getLength();
            ++messagePxSize;
        }
        StringBuilder builder = new StringBuilder();
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = centerPx - halvedMessageSize;
        int spaceLength = DefaultFontInfo.getDefaultFontInfo(space).getLength() + 1;
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            builder.append(spaceColor.toString() + space);
        }
        return builder.toString() + " " + message + " " + builder.toString();
    }

    public static String[] verticalCenter(String ... messages) {
        return ChatUtil.verticalCenter(Arrays.asList(messages));
    }

    public static String[] verticalCenter(Collection<String> messages) {
        ArrayList<String> lines = new ArrayList<String>();
        long padding = MathUtil.ceiling((20 - messages.size()) / 2);
        int i = 0;
        while ((long)i < padding) {
            lines.add(RandomUtil.nextColorOrDecoration());
            ++i;
        }
        for (String message : messages) {
            lines.add(message);
        }
        i = 0;
        while ((long)i < padding) {
            lines.add(RandomUtil.nextColorOrDecoration());
            ++i;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String insertDot(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String lastChar = message.substring(message.length() - 1);
        String[] words = message.split("\\s");
        String lastWord = words[words.length - 1];
        if (!ChatUtil.isDomain(lastWord) && lastChar.matches("(?i)[a-z\u0400-\u04ff]")) {
            message = message + ".";
        }
        return message;
    }

    public static String capitalize(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String[] sentences = message.split("(?<=[!?\\.])\\s");
        String tempMessage = "";
        for (String sentence : sentences) {
            String word = message.split("\\s")[0];
            if (!ChatUtil.isDomain(word)) {
                sentence = sentence.substring(0, 1).toUpperCase() + sentence.substring(1);
            }
            tempMessage = tempMessage + sentence + " ";
        }
        return tempMessage.trim();
    }

    public static String lowercaseSecondChar(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String[] sentences = message.split("(?<=[!?\\.])\\s");
        String tempMessage = "";
        for (String sentence : sentences) {
            try {
                if (sentence.length() > 2 && !ChatUtil.isDomain(message.split("\\s")[0]) && sentence.length() > 2 && Character.isUpperCase(sentence.charAt(0)) && Character.isLowerCase(sentence.charAt(2))) {
                    sentence = sentence.substring(0, 1) + sentence.substring(1, 2).toLowerCase() + sentence.substring(2);
                }
                tempMessage = tempMessage + sentence + " ";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return tempMessage.trim();
    }

    public static double getCapsPercentage(String message) {
        if (message.isEmpty()) {
            return 0.0;
        }
        String[] sentences = Common.stripColors(message).split(" ");
        String messageToCheck = "";
        double upperCount = 0.0;
        for (String sentence : sentences) {
            if (ChatUtil.isDomain(sentence)) continue;
            messageToCheck = messageToCheck + sentence + " ";
        }
        for (char ch : messageToCheck.toCharArray()) {
            if (!Character.isUpperCase(ch)) continue;
            upperCount += 1.0;
        }
        return upperCount / (double)messageToCheck.length();
    }

    public static int getCapsInRow(String message, List<String> ignored) {
        if (message.isEmpty()) {
            return 0;
        }
        int[] caps = ChatUtil.splitCaps(Common.stripColors(message), ignored);
        int sum = 0;
        int sumTemp = 0;
        for (int i : caps) {
            if (i == 1) {
                sum = Math.max(sum, ++sumTemp);
                continue;
            }
            sumTemp = 0;
        }
        return sum;
    }

    public static double getSimilarityPercentage(String first, String second) {
        int longerLength;
        if (first.isEmpty() && second.isEmpty()) {
            return 1.0;
        }
        first = ChatUtil.removeSimilarity(first);
        second = ChatUtil.removeSimilarity(second);
        String longer = first;
        String shorter = second;
        if (first.length() < second.length()) {
            longer = second;
            shorter = first;
        }
        if ((longerLength = longer.length()) == 0) {
            return 0.0;
        }
        return (double)(longerLength - ChatUtil.editDistance(longer, shorter)) / (double)longerLength;
    }

    private static String removeSimilarity(String message) {
        message = ChatUtil.replaceDiacritic(message);
        message = Common.stripColors(message);
        message = message.toLowerCase();
        return message;
    }

    public static boolean isDomain(String message) {
        return Common.regExMatch("(https?:\\/\\/(?:www\\.|(?!www))[^\\s\\.]+\\.[^\\s]{2,}|www\\.[^\\s]+\\.[^\\s]{2,})", message);
    }

    public static String replaceDiacritic(String message) {
        return Normalizer.normalize(message, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    private static int editDistance(String first, String second) {
        first = first.toLowerCase();
        second = second.toLowerCase();
        int[] costs = new int[second.length() + 1];
        for (int i = 0; i <= first.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= second.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (first.charAt(i - 1) != second.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[second.length()] = lastValue;
        }
        return costs[second.length()];
    }

    private static int[] splitCaps(String message, List<String> ignored) {
        int i;
        int[] editedMsg = new int[message.length()];
        Object[] parts = message.split(" ");
        for (i = 0; i < parts.length; ++i) {
            for (String whitelisted : ignored) {
                if (!whitelisted.equalsIgnoreCase((String)parts[i])) continue;
                parts[i] = ((String)parts[i]).toLowerCase();
            }
        }
        for (i = 0; i < parts.length; ++i) {
            if (!ChatUtil.isDomain(parts[i])) continue;
            parts[i] = ((String)parts[i]).toLowerCase();
        }
        String msg = StringUtils.join((Object[])parts, (String)" ");
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            editedMsg[i2] = Character.isUpperCase(msg.charAt(i2)) && Character.isLetter(msg.charAt(i2)) ? 1 : 0;
        }
        return editedMsg;
    }

    private ChatUtil() {
    }
}

