/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.bungee.BungeeAction;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.SimpleSettings;

public final class BungeeUtil {
    private static int actionHead = 0;

    @SafeVarargs
    public static <T> void tellBungee(BungeeAction action, T ... datas) {
        BungeeUtil.tellBungee(SimplePlugin.getInstance().getBungeeCord().getChannel(), action, datas);
    }

    @SafeVarargs
    public static <T> void tellBungee(String channel, BungeeAction action, T ... datas) {
        Valid.checkBoolean(datas.length == action.getContent().length, "Data count != valid values count in " + action + "! Given data: " + datas.length + " vs needed: " + action.getContent().length, new Object[0]);
        Debugger.put("bungee", "Server '" + SimpleSettings.BUNGEE_SERVER_NAME + "' sent bungee message [" + channel + ", " + action + "]: ");
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(SimpleSettings.BUNGEE_SERVER_NAME);
        out.writeUTF(action.toString());
        actionHead = 0;
        for (T data : datas) {
            Valid.checkNotNull(data, "Bungee object in array is null! Array: " + Common.join(datas, ", ", t -> t == null ? "null" : t.toString() + "(" + t.getClass().getSimpleName() + ")"));
            if (data instanceof Integer) {
                Debugger.put("bungee", data.toString() + ", ");
                BungeeUtil.moveHead(action, Integer.class);
                out.writeInt(((Integer)data).intValue());
                continue;
            }
            if (data instanceof Double) {
                Debugger.put("bungee", data.toString() + ", ");
                BungeeUtil.moveHead(action, Double.class);
                out.writeDouble(((Double)data).doubleValue());
                continue;
            }
            if (data instanceof Long) {
                Debugger.put("bungee", data.toString() + ", ");
                BungeeUtil.moveHead(action, Long.class);
                out.writeLong(((Long)data).longValue());
                continue;
            }
            if (data instanceof Boolean) {
                Debugger.put("bungee", data.toString() + ", ");
                BungeeUtil.moveHead(action, Boolean.class);
                out.writeBoolean(((Boolean)data).booleanValue());
                continue;
            }
            if (data instanceof String) {
                Debugger.put("bungee", data.toString() + ", ");
                BungeeUtil.moveHead(action, String.class);
                out.writeUTF((String)data);
                continue;
            }
            throw new FoException("Unknown type of data: " + data + " (" + data.getClass().getSimpleName() + ")");
        }
        Debugger.push("bungee");
        BungeeUtil.getThroughWhomSendMessage().sendPluginMessage((Plugin)SimplePlugin.getInstance(), channel, out.toByteArray());
        actionHead = 0;
    }

    public static void tellNative(Player sender, Object ... datas) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (Object data : datas) {
            Valid.checkNotNull(data, "Bungee object in array is null! Array: " + Common.join(datas, ", ", t -> t == null ? "null" : t.toString() + "(" + t.getClass().getSimpleName() + ")"));
            if (data instanceof Integer) {
                out.writeInt(((Integer)data).intValue());
                continue;
            }
            if (data instanceof Double) {
                out.writeDouble(((Double)data).doubleValue());
                continue;
            }
            if (data instanceof Boolean) {
                out.writeBoolean(((Boolean)data).booleanValue());
                continue;
            }
            if (data instanceof String) {
                out.writeUTF((String)data);
                continue;
            }
            throw new FoException("Unknown type of data: " + data + " (" + data.getClass().getSimpleName() + ")");
        }
        sender.sendPluginMessage((Plugin)SimplePlugin.getInstance(), "BungeeCord", out.toByteArray());
    }

    public static void connect(@NonNull Player player, @NonNull String serverName) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteArray);
        try {
            out.writeUTF("Connect");
            out.writeUTF(serverName);
        }
        catch (Throwable t) {
            Common.error(t, "Unable to connect " + player.getName() + " to server " + serverName, "Error: %error");
        }
        player.sendPluginMessage((Plugin)SimplePlugin.getInstance(), "BungeeCord", byteArray.toByteArray());
    }

    private static PluginMessageRecipient getThroughWhomSendMessage() {
        return Remain.getOnlinePlayers().isEmpty() ? Bukkit.getServer() : (PluginMessageRecipient)Remain.getOnlinePlayers().iterator().next();
    }

    private static void moveHead(BungeeAction action, Class<?> typeOf) {
        Valid.checkNotNull(action, "Action not set!");
        Class<?>[] content = action.getContent();
        Valid.checkBoolean(actionHead < content.length, "Head out of bounds! Max data size for " + action.name() + " is " + content.length + "! (Set Debug to [bungee] in settings.yml and report this issue along with the new console messages", new Object[0]);
        ++actionHead;
    }

    private BungeeUtil() {
    }
}

