/*
 * Decompiled with CFR 0.152.
 */
package me.wilkins.mob;

import java.util.ArrayList;
import java.util.List;
import me.wilkins.mob.CustomMob;
import me.wilkins.mob.MobArmour;
import me.wilkins.mob.MobSkull;
import org.bukkit.entity.EntityType;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.settings.SimpleSettings;

public class MobSettings
extends SimpleSettings {
    private static final List<CustomMob> customMobList = new ArrayList<CustomMob>();

    public static CustomMob findCustomMob(EntityType type) {
        for (CustomMob mob : customMobList) {
            if (mob.getType() != type) continue;
            return mob;
        }
        return null;
    }

    public static List<CustomMob> getCustomMobList() {
        return customMobList;
    }

    private static void init() {
        for (String entityName : MobSettings.getMap("CustomMobs").keySet()) {
            EntityType type;
            try {
                type = EntityType.valueOf((String)entityName.toUpperCase());
            }
            catch (Exception ex) {
                Common.logFramed("[" + entityName + "] was not loaded because this Entity Type does not exist...");
                continue;
            }
            CustomMob customMob = new CustomMob(type);
            MobSettings.pathPrefix("CustomMobs." + entityName);
            MobArmour mobArmour = new MobArmour();
            if (MobSettings.isSet("Armour.Chestplate")) {
                String chestplateString = MobSettings.getString("Armour.Chestplate");
                CompMaterial chestplate = MobSettings.findMaterial(chestplateString, "chestplate");
                if (chestplate != null) {
                    mobArmour.setChestplate(ItemCreator.of(chestplate).build().makeSurvival());
                } else {
                    Common.logFramed("Could not load chestplate for [" + entityName + "] because (" + chestplateString + ") is not a type of chestplate!");
                }
            }
            if (MobSettings.isSet("Armour.Leggings")) {
                String leggingsString = MobSettings.getString("Armour.Leggings");
                CompMaterial leggings = MobSettings.findMaterial(leggingsString, "leggings");
                if (leggings != null) {
                    mobArmour.setLeggings(ItemCreator.of(leggings).build().makeSurvival());
                } else {
                    Common.logFramed("Could not load leggings for [" + entityName + "] because (" + leggingsString + ") is not a type of leggings!");
                }
            }
            if (MobSettings.isSet("Armour.Boots")) {
                String bootsString = MobSettings.getString("Armour.Boots");
                CompMaterial boots = MobSettings.findMaterial(bootsString, "boots");
                if (boots != null) {
                    mobArmour.setBoots(ItemCreator.of(boots).build().makeSurvival());
                } else {
                    Common.logFramed("Could not load boots for [" + entityName + "] because (" + bootsString + ") is not a type of boots!");
                }
            }
            customMob.setMobArmour(mobArmour);
            MobSkull mobSkull = null;
            if (MobSettings.isSet("Skull")) {
                String playerName = MobSettings.getString("Skull");
                mobSkull = new MobSkull(playerName);
            }
            if (mobSkull != null) {
                customMob.setMobSkull(mobSkull);
            }
            double health = 0.0;
            if (MobSettings.isSet("Health")) {
                try {
                    health = MobSettings.getDouble("Health");
                    if (health <= 0.0) {
                        Common.logFramed("Could not load health for [" + entityName + "] because health cannot be below 0");
                    }
                }
                catch (Exception ex) {
                    Common.logFramed("Could not load health for [" + entityName + "] because it is not a valid number. Setting health to default value of the entity type");
                }
            }
            customMob.setHealth(health);
            if (MobSettings.isSet("Drop_Chances")) {
                if (MobSettings.isSet("Drop_Default_Items")) {
                    if (MobSettings.getBoolean("Drop_Default_Items")) {
                        customMob.setDropType(CustomMob.DropType.PRESET_DEFAULT);
                    } else {
                        customMob.setDropType(CustomMob.DropType.PRESET);
                    }
                } else {
                    customMob.setDropType(CustomMob.DropType.PRESET_DEFAULT);
                }
                MobSettings.pathPrefix("CustomMobs." + entityName + ".Drop_Chances");
                if (MobSettings.isSet("Skull")) {
                    customMob.setSkullDropChance(MobSettings.getDouble("Skull"));
                }
                if (MobSettings.isSet("Chestplate")) {
                    customMob.setChestplateDropChance(MobSettings.getDouble("Chestplate"));
                }
                if (MobSettings.isSet("Leggings")) {
                    customMob.setLeggingsDropChance(MobSettings.getDouble("Leggings"));
                }
                if (MobSettings.isSet("Boots")) {
                    customMob.setBootsDropChance(MobSettings.getDouble("Boots"));
                }
            } else if (MobSettings.isSet("Drop_Default_Items")) {
                if (MobSettings.getBoolean("Drop_Default_Items")) {
                    customMob.setDropType(CustomMob.DropType.DEFAULT);
                } else {
                    customMob.setDropType(CustomMob.DropType.NONE);
                }
            } else {
                customMob.setDropType(CustomMob.DropType.DEFAULT);
            }
            customMobList.add(customMob);
        }
    }

    private static CompMaterial findMaterial(String material, String suffix) {
        try {
            CompMaterial material1 = CompMaterial.valueOf(material.toUpperCase() + "_" + suffix.toUpperCase());
            return material1;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected int getConfigVersion() {
        return 1;
    }
}

