/*
 * Decompiled with CFR 0.152.
 */
package me.wilkins.mob;

import java.util.Random;
import me.wilkins.mob.CustomMob;
import me.wilkins.mob.MobArmour;
import me.wilkins.mob.MobSettings;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.mineacademy.fo.remain.CompAttribute;

public class MobListener
implements Listener {
    @EventHandler
    public static void onMobSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL) {
            return;
        }
        LivingEntity entity = event.getEntity();
        CustomMob customMob = MobSettings.findCustomMob(entity.getType());
        if (customMob == null) {
            return;
        }
        if (customMob.getHealth() > 0.0 && customMob.getHealth() <= CompAttribute.GENERIC_MAX_HEALTH.get(entity)) {
            CompAttribute.GENERIC_MAX_HEALTH.set(entity, customMob.getHealth());
            entity.setHealth(customMob.getHealth());
        }
        EntityEquipment equipment = entity.getEquipment();
        MobArmour mobArmour = customMob.getMobArmour();
        if (equipment != null) {
            if (customMob.getMobSkull() != null) {
                equipment.setHelmet(customMob.getMobSkull().getItemStack());
            }
            if (mobArmour != null) {
                if (mobArmour.getChestplate() != null) {
                    equipment.setChestplate(mobArmour.getChestplate());
                }
                if (mobArmour.getLeggings() != null) {
                    equipment.setLeggings(mobArmour.getLeggings());
                }
                if (mobArmour.getBoots() != null) {
                    equipment.setBoots(mobArmour.getBoots());
                }
            }
        }
    }

    @EventHandler
    public static void onMobDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        CustomMob customMob = MobSettings.findCustomMob(entity.getType());
        if (customMob == null) {
            return;
        }
        MobArmour mobArmour = customMob.getMobArmour();
        if (customMob.getDropType() == CustomMob.DropType.DEFAULT) {
            return;
        }
        if (customMob.getDropType() == CustomMob.DropType.PRESET_DEFAULT && mobArmour != null) {
            if (customMob.getMobSkull().getItemStack() != null) {
                event.getDrops().remove(customMob.getMobSkull().getItemStack());
            }
            if (mobArmour.getChestplate() != null) {
                event.getDrops().remove(mobArmour.getChestplate());
            }
            if (mobArmour.getLeggings() != null) {
                event.getDrops().remove(mobArmour.getLeggings());
            }
            if (mobArmour.getBoots() != null) {
                event.getDrops().remove(mobArmour.getBoots());
            }
        } else {
            event.getDrops().clear();
        }
        if (customMob.getSkullDropChance() >= 0.0 && customMob.getMobSkull() != null && MobListener.chance(customMob.getSkullDropChance())) {
            event.getDrops().add(customMob.getMobSkull().getItemStack());
        }
        if (mobArmour != null) {
            if (mobArmour.getChestplate() != null && customMob.getChestplateDropChance() >= 0.0 && MobListener.chance(customMob.getChestplateDropChance())) {
                event.getDrops().add(mobArmour.getChestplate());
            }
            if (mobArmour.getLeggings() != null && customMob.getLeggingsDropChance() >= 0.0 && MobListener.chance(customMob.getLeggingsDropChance())) {
                event.getDrops().add(mobArmour.getLeggings());
            }
            if (mobArmour.getBoots() != null && customMob.getBootsDropChance() >= 0.0 && MobListener.chance(customMob.getBootsDropChance())) {
                event.getDrops().add(mobArmour.getBoots());
            }
        }
    }

    private static boolean chance(double percentage) {
        return (double)(new Random().nextInt(99) + 1) <= percentage;
    }
}

