/*
 * Decompiled with CFR 0.152.
 */
package me.Lazinq.CustomEnderchest.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.Lazinq.CustomEnderchest.Main;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutBlockAction;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class Enderchest
implements Listener,
CommandExecutor {
    public Main plugin;
    public HashMap<UUID, Location> openEnderChests = new HashMap();
    public HashMap<UUID, Inventory> extrainv = new HashMap();

    public Enderchest(Main plugin) {
        this.plugin = plugin;
        plugin.getCommand("enderchest").setExecutor((CommandExecutor)this);
    }

    @EventHandler
    public void onOpenEnderChest(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player;
            if (event.getClickedBlock().getType() == Material.ENDER_CHEST) {
                event.setCancelled(true);
                Location location = event.getClickedBlock().getLocation();
                Enderchest.changeChestState(location, true);
                this.openEnderChests.put(event.getPlayer().getUniqueId(), location);
            }
            if (this.extrainv.containsKey((player = event.getPlayer()).getUniqueId())) {
                player.playSound(player.getLocation(), Sound.CHEST_OPEN, 1.0f, 0.8f);
                player.openInventory(this.extrainv.get(player.getUniqueId()));
                return;
            }
            Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(player.getName()) + "'s EnderChest"));
            player.openInventory(inventory);
            player.playSound(player.getLocation(), Sound.CHEST_OPEN, 1.0f, 0.8f);
        }
    }

    @EventHandler
    public void onCloseEnderChest(InventoryCloseEvent event) {
        Enderchest.changeChestState(this.openEnderChests.get(event.getPlayer().getUniqueId()), false);
        this.openEnderChests.remove(event.getPlayer().getUniqueId());
        if (event.getView().getTitle().contains(String.valueOf(event.getPlayer().getName()) + "'s EnderChest")) {
            this.extrainv.put(event.getPlayer().getUniqueId(), event.getInventory());
        }
    }

    public void loadInventories() {
        for (String str : this.plugin.getConfig().getConfigurationSection("").getKeys(false)) {
            UUID uuid = UUID.fromString(str);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(player.getName()) + "'s EnderChest"));
            for (String itemslot : this.plugin.getConfig().getConfigurationSection(String.valueOf(uuid.toString()) + ".enderchest").getKeys(false)) {
                ItemStack i = ItemStack.deserialize((Map)this.plugin.getConfig().getConfigurationSection(String.valueOf(uuid.toString()) + ".enderchest." + itemslot).getValues(false));
                inventory.setItem(Integer.parseInt(itemslot), i);
            }
            this.extrainv.put(uuid, inventory);
        }
    }

    public void saveInventories() {
        for (UUID uuid : this.extrainv.keySet()) {
            this.plugin.getConfig().set(uuid.toString(), null);
            Inventory current = this.extrainv.get(uuid);
            int i = 0;
            while (i < current.getSize()) {
                ItemStack currentItem = current.getItem(i);
                if (currentItem != null) {
                    this.plugin.getConfig().set(uuid + ".enderchest." + i, (Object)currentItem.serialize());
                }
                ++i;
            }
        }
        this.plugin.saveConfig();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players may execute this command!");
            return true;
        }
        Player player = (Player)sender;
        if (player.hasPermission("enderchest.use")) {
            if (this.extrainv.containsKey(player.getUniqueId())) {
                player.openInventory(this.extrainv.get(player.getUniqueId()));
            } else {
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(player.getName()) + "'s EnderChest"));
                player.openInventory(inventory);
            }
        }
        return false;
    }

    public static void changeChestState(Location loc, boolean open) {
        byte dataByte = open ? (byte)1 : 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playNote(loc, (byte)1, dataByte);
            BlockPosition position = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            PacketPlayOutBlockAction blockActionPacket = new PacketPlayOutBlockAction(position, Block.getById((int)loc.getBlock().getTypeId()), 1, (int)dataByte);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)blockActionPacket);
        }
    }
}

