/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_6_R1;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_6_R1.Item;
import net.minecraft.server.v1_6_R1.ItemStack;
import net.minecraft.server.v1_6_R1.NBTBase;
import net.minecraft.server.v1_6_R1.NBTTagByte;
import net.minecraft.server.v1_6_R1.NBTTagByteArray;
import net.minecraft.server.v1_6_R1.NBTTagCompound;
import net.minecraft.server.v1_6_R1.NBTTagDouble;
import net.minecraft.server.v1_6_R1.NBTTagFloat;
import net.minecraft.server.v1_6_R1.NBTTagInt;
import net.minecraft.server.v1_6_R1.NBTTagIntArray;
import net.minecraft.server.v1_6_R1.NBTTagList;
import net.minecraft.server.v1_6_R1.NBTTagLong;
import net.minecraft.server.v1_6_R1.NBTTagShort;
import net.minecraft.server.v1_6_R1.NBTTagString;
import net.minecraft.server.v1_6_R1.TileEntity;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_6_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_6_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public static final Field COMPOUND_MAP_FIELD;
    public static final Field LIST_TYPE_FIELD;

    public NBTTagCompound toNativeCompound(String root, CompoundTag tag) {
        NBTTagCompound result = new NBTTagCompound(root);
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            switch (t.getType()) {
                case BYTE: {
                    result.setByte(name, ((ByteTag)t).getRawValue());
                    break;
                }
                case BYTE_ARRAY: {
                    result.setByteArray(name, ((ByteArrayTag)t).getValue());
                    break;
                }
                case COMPOUND: {
                    result.setCompound(name, this.toNativeCompound(name, (CompoundTag)t));
                    break;
                }
                case DOUBLE: {
                    result.setDouble(name, ((DoubleTag)t).getRawValue());
                    break;
                }
                case FLOAT: {
                    result.setFloat(name, ((FloatTag)t).getRawValue());
                    break;
                }
                case INT: {
                    result.setInt(name, ((IntTag)t).getRawValue());
                    break;
                }
                case INT_ARRAY: {
                    result.setIntArray(name, ((IntArrayTag)t).getValue());
                    break;
                }
                case LIST: {
                    result.set(name, (NBTBase)this.toNativeList(name, (ListTag)t));
                    break;
                }
                case LONG: {
                    result.setLong(name, ((LongTag)t).getValue().longValue());
                    break;
                }
                case SHORT: {
                    result.setShort(name, ((ShortTag)t).getValue().shortValue());
                    break;
                }
                case STRING: {
                    result.setString(name, ((StringTag)t).getValue());
                }
            }
        }
        return result;
    }

    public NBTTagList toNativeList(String root, ListTag tag) {
        NBTTagList result = new NBTTagList(root);
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagByte(null, byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagByteArray(null, byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((NBTBase)this.toNativeCompound(null, compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagDouble(null, doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagFloat(null, floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagInt(null, intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagIntArray(null, intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (Tag tag2 : (ListTag[])tag.getValue()) {
                    result.add((NBTBase)this.toNativeList(null, (ListTag)tag2));
                }
            }
            case LONG: {
                for (Tag tag3 : (LongTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagLong(null, ((LongTag)tag3).getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagShort(null, shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagString(null, stringTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(NBTTagCompound tag) {
        if (COMPOUND_MAP_FIELD != null) {
            try {
                HashMap<String, Tag> result = new HashMap<String, Tag>();
                Map map = (Map)COMPOUND_MAP_FIELD.get(tag);
                for (NBTBase b : map.values()) {
                    switch (TagType.values()[b.getTypeId()]) {
                        case BYTE: {
                            result.put(b.getName(), new ByteTag(((NBTTagByte)b).data));
                            break;
                        }
                        case BYTE_ARRAY: {
                            result.put(b.getName(), new ByteArrayTag(((NBTTagByteArray)b).data));
                            break;
                        }
                        case COMPOUND: {
                            result.put(b.getName(), this.fromNativeCompound((NBTTagCompound)b));
                            break;
                        }
                        case DOUBLE: {
                            result.put(b.getName(), new DoubleTag(((NBTTagDouble)b).data));
                            break;
                        }
                        case FLOAT: {
                            result.put(b.getName(), new FloatTag(((NBTTagFloat)b).data));
                            break;
                        }
                        case INT: {
                            result.put(b.getName(), new IntTag(((NBTTagInt)b).data));
                            break;
                        }
                        case INT_ARRAY: {
                            result.put(b.getName(), new IntArrayTag(((NBTTagIntArray)b).data));
                            break;
                        }
                        case LIST: {
                            result.put(b.getName(), this.fromNativeList((NBTTagList)b));
                            break;
                        }
                        case LONG: {
                            result.put(b.getName(), new LongTag(((NBTTagLong)b).data));
                            break;
                        }
                        case SHORT: {
                            result.put(b.getName(), new ShortTag(((NBTTagShort)b).data));
                            break;
                        }
                        case STRING: {
                            result.put(b.getName(), new StringTag(((NBTTagString)b).data));
                        }
                    }
                }
                return new CompoundTag(result);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public ListTag fromNativeList(NBTTagList tag) {
        try {
            TagType type = TagType.values()[(Byte)LIST_TYPE_FIELD.get(tag)];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((NBTTagByte)tag.get((int)i)).data);
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((NBTTagByteArray)tag.get((int)i)).data);
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tag.get(i) == null ? new CompoundTag() : this.fromNativeCompound((NBTTagCompound)tag.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((NBTTagDouble)tag.get((int)i)).data);
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((NBTTagFloat)tag.get((int)i)).data);
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((NBTTagInt)tag.get((int)i)).data);
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((NBTTagIntArray)tag.get((int)i)).data);
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((NBTTagList)tag.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((NBTTagLong)tag.get((int)i)).data);
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((NBTTagShort)tag.get((int)i)).data);
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((NBTTagString)tag.get((int)i)).data);
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        TileEntity tileEntity = craftWorld.getTileEntityAt(block.getX(), block.getY(), block.getZ());
        if (tileEntity == null) {
            return;
        }
        tileEntity.a(this.toNativeCompound(null, tag));
        tileEntity.update();
        craftWorld.getHandle().notify(block.getX(), block.getY(), block.getZ());
    }

    @Override
    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        TileEntity tileEntity = craftWorld.getTileEntityAt(block.getX(), block.getY(), block.getZ());
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.b(tag);
        return this.fromNativeCompound(tag);
    }

    @Override
    public CompoundTag readItemStack(org.bukkit.inventory.ItemStack stack) {
        try {
            Field f = CraftItemStack.class.getDeclaredField("handle");
            f.setAccessible(true);
            ItemStack nativeStack = (ItemStack)f.get(stack);
            NBTTagCompound compound = new NBTTagCompound();
            nativeStack.save(compound);
            return this.fromNativeCompound(compound);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public org.bukkit.inventory.ItemStack createItemStack(CompoundTag tag) {
        ItemStack nativeStack = new ItemStack((Item)null);
        nativeStack.c(this.toNativeCompound(null, tag));
        return CraftItemStack.asCraftMirror((ItemStack)nativeStack);
    }

    @Override
    public CompoundTag readEntity(Entity e) {
        net.minecraft.server.v1_6_R1.Entity handle = ((CraftEntity)e).getHandle();
        NBTTagCompound compound = new NBTTagCompound();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    @Override
    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().f(this.toNativeCompound(null, tag));
    }

    @Override
    public Entity getEntityById(World world, int id) {
        CraftWorld craftWorld = (CraftWorld)world;
        net.minecraft.server.v1_6_R1.Entity entity = craftWorld.getHandle().getEntity(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    @Override
    public boolean isEntityByIdSupported() {
        return true;
    }

    @Override
    public boolean isEntityByUuidSupported() {
        return false;
    }

    @Override
    public Entity getEntityByUUID(World world, UUID id) {
        throw new UnsupportedOperationException("Not supported.");
    }

    static {
        Field f = null;
        try {
            f = NBTTagCompound.class.getDeclaredField("map");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        COMPOUND_MAP_FIELD = f;
        f = null;
        try {
            f = NBTTagList.class.getDeclaredField("type");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        LIST_TYPE_FIELD = f;
    }
}

