/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_5_R3;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import net.minecraft.server.v1_5_R3.Chunk;
import net.minecraft.server.v1_5_R3.ChunkRegionLoader;
import net.minecraft.server.v1_5_R3.EntityTracker;
import net.minecraft.server.v1_5_R3.IAsyncChunkSaver;
import net.minecraft.server.v1_5_R3.IChunkLoader;
import net.minecraft.server.v1_5_R3.IDataManager;
import net.minecraft.server.v1_5_R3.IWorldAccess;
import net.minecraft.server.v1_5_R3.MethodProfiler;
import net.minecraft.server.v1_5_R3.MinecraftServer;
import net.minecraft.server.v1_5_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_5_R3.NBTTagCompound;
import net.minecraft.server.v1_5_R3.ServerNBTManager;
import net.minecraft.server.v1_5_R3.World;
import net.minecraft.server.v1_5_R3.WorldData;
import net.minecraft.server.v1_5_R3.WorldManager;
import net.minecraft.server.v1_5_R3.WorldProvider;
import net.minecraft.server.v1_5_R3.WorldProviderHell;
import net.minecraft.server.v1_5_R3.WorldProviderTheEnd;
import net.minecraft.server.v1_5_R3.WorldServer;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_5_R3.CraftServer;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.cyberiantiger.minecraft.Coord;
import org.cyberiantiger.minecraft.generator.VoidGenerator;
import org.cyberiantiger.minecraft.unsafe.AbstractInstanceTools;

public final class InstanceTools
extends AbstractInstanceTools {
    @Override
    public void unloadWorld(Plugin plugin, org.bukkit.World world) {
        plugin.getServer().unloadWorld(world, false);
    }

    @Override
    public org.bukkit.World createInstance(Plugin plugin, String instanceName, World.Environment env, Difficulty difficulty, File source, File destination) {
        this.checkDirectories(source, destination);
        MinecraftServer console = ((CraftServer)plugin.getServer()).getServer();
        if (console == null) {
            throw new IllegalStateException("Minecraft console was null");
        }
        InstanceDataManager dataManager = new InstanceDataManager(plugin, instanceName, source, destination);
        int dimension = 10 + console.worlds.size();
        boolean used = false;
        block0: do {
            for (WorldServer server : console.worlds) {
                used = server.dimension == dimension;
                if (!used) continue;
                ++dimension;
                continue block0;
            }
        } while (used);
        MethodProfiler profiler = console.methodProfiler;
        WorldData wd = dataManager.getWorldData();
        VoidGenerator generator = new VoidGenerator(Biome.PLAINS, new Coord(wd.c(), wd.d(), wd.e()));
        WorldServer instanceWorld = new WorldServer(console, (IDataManager)dataManager, instanceName, dimension, null, console.methodProfiler, console.getLogger(), env, (ChunkGenerator)generator);
        instanceWorld.worldMaps = ((WorldServer)console.worlds.get((int)0)).worldMaps;
        instanceWorld.tracker = new EntityTracker(instanceWorld);
        instanceWorld.addIWorldAccess((IWorldAccess)new WorldManager(console, instanceWorld));
        instanceWorld.difficulty = difficulty.getValue();
        instanceWorld.keepSpawnInMemory = false;
        console.worlds.add(instanceWorld);
        instanceWorld.getWorld().getPopulators().addAll(generator.getDefaultPopulators((org.bukkit.World)instanceWorld.getWorld()));
        plugin.getServer().getPluginManager().callEvent((Event)new WorldInitEvent((org.bukkit.World)instanceWorld.getWorld()));
        plugin.getServer().getPluginManager().callEvent((Event)new WorldLoadEvent((org.bukkit.World)instanceWorld.getWorld()));
        return instanceWorld.getWorld();
    }

    public static final class InstanceChunkLoader
    implements IChunkLoader,
    IAsyncChunkSaver {
        private final ChunkRegionLoader loadLoader;
        private final ChunkRegionLoader saveLoader;

        public InstanceChunkLoader(ChunkRegionLoader loadLoader, ChunkRegionLoader saveLoader) {
            this.loadLoader = loadLoader;
            this.saveLoader = saveLoader;
        }

        public Chunk a(World world, int i, int j) {
            if (this.saveLoader.chunkExists(world, i, j)) {
                return this.saveLoader.a(world, i, j);
            }
            return this.loadLoader.a(world, i, j);
        }

        public void a(World world, Chunk chunk) {
            this.saveLoader.a(world, chunk);
        }

        public void b(World world, Chunk chunk) {
            this.saveLoader.b(world, chunk);
        }

        public void a() {
        }

        public void b() {
        }

        public boolean c() {
            return this.saveLoader.c();
        }
    }

    private static class InstanceDataManager
    extends ServerNBTManager {
        private static final String WORLD_DATA = "level.dat";
        private static final String WORLD_DATA_OLD = "level.dat_old";
        private final Plugin instances;
        private final File loadDataFolder;
        private final String world;

        public InstanceDataManager(Plugin instances, String instanceName, File loadDataFolder, File saveDataFolder) {
            super(saveDataFolder.getParentFile(), saveDataFolder.getName(), false);
            this.instances = instances;
            this.loadDataFolder = loadDataFolder;
            this.world = instanceName;
        }

        public WorldData getWorldData() {
            File levelData = new File(this.getDirectory(), WORLD_DATA);
            if (levelData.isFile()) {
                return super.getWorldData();
            }
            levelData = new File(this.getDirectory(), WORLD_DATA_OLD);
            if (levelData.isFile()) {
                return super.getWorldData();
            }
            File file1 = new File(this.loadDataFolder, WORLD_DATA);
            if (file1.exists()) {
                try {
                    NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(file1));
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Data");
                    return new WorldData(nbttagcompound1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((file1 = new File(this.loadDataFolder, WORLD_DATA_OLD)).exists()) {
                try {
                    NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(file1));
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Data");
                    return new WorldData(nbttagcompound1);
                }
                catch (Exception exception1) {
                    exception1.printStackTrace();
                }
            }
            return null;
        }

        public IChunkLoader createChunkLoader(WorldProvider wp) {
            File saveChunkDir;
            File loadChunkDir;
            if (wp instanceof WorldProviderHell) {
                loadChunkDir = new File(this.loadDataFolder, "DIM-1");
                saveChunkDir = new File(this.getDirectory(), "DIM-1");
            } else if (wp instanceof WorldProviderTheEnd) {
                loadChunkDir = new File(this.loadDataFolder, "DIM1");
                saveChunkDir = new File(this.getDirectory(), "DIM1");
            } else {
                loadChunkDir = this.loadDataFolder;
                saveChunkDir = this.getDirectory();
            }
            ChunkRegionLoader loadLoader = new ChunkRegionLoader(loadChunkDir);
            ChunkRegionLoader saveLoader = new ChunkRegionLoader(saveChunkDir);
            return new InstanceChunkLoader(loadLoader, saveLoader);
        }

        public File getDataFile(String string) {
            File result = new File(this.loadDataFolder, string + ".dat");
            if (result.isFile()) {
                return result;
            }
            File source = new File(this.getDirectory(), string + ".dat");
            if (!source.isFile()) {
                return result;
            }
            try {
                Files.copy((File)source, (File)result);
            }
            catch (IOException ex) {
                this.instances.getLogger().log(Level.SEVERE, "Error copying " + source.getPath() + " to " + result.getPath() + " for Instance world: " + this.world, ex);
            }
            return result;
        }
    }
}

