/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.items;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.MojangsonParser;
import org.cyberiantiger.minecraft.nbt.TagTuple;

public class ItemType {
    private static final Set<Short> DEFAULT_DAMAGE = Collections.singleton((short)0);
    private Set<Short> damage = DEFAULT_DAMAGE;
    private List<String> tags = Collections.emptyList();
    private transient Set<CompoundTag> parsedTags = null;

    public Set<Short> getDamage() {
        return this.damage;
    }

    public Set<CompoundTag> getParsedTags() {
        if (this.parsedTags == null) {
            if (this.tags.isEmpty()) {
                this.parsedTags = Collections.emptySet();
            } else {
                this.parsedTags = new HashSet<CompoundTag>(this.tags.size());
                for (String tag : this.tags) {
                    try {
                        MojangsonParser parser = new MojangsonParser(new StringReader(tag));
                        TagTuple result = parser.parse();
                        this.parsedTags.add((CompoundTag)result.getValue());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.parsedTags;
    }
}

