/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.generator;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.cyberiantiger.minecraft.Coord;

public class VoidGenerator
extends ChunkGenerator {
    private Biome biome = Biome.PLAINS;
    private final Coord spawn;

    public VoidGenerator(Biome biome, Coord spawn) {
        this.biome = biome;
        this.spawn = spawn;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public void setBiome(Biome biome) {
        this.biome = biome;
    }

    public byte[][] generateBlockSections(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biomes) {
        int maxHeight = world.getMaxHeight();
        byte[][] chunk = new byte[maxHeight >> 4][];
        int xPos = x * 16;
        int zPos = z * 16;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                biomes.setBiome(i, j, this.biome);
            }
        }
        return chunk;
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, (double)this.spawn.getX(), (double)this.spawn.getY(), (double)this.spawn.getZ());
    }

    public boolean canSpawn(World world, int x, int z) {
        return super.canSpawn(world, x, z);
    }
}

