/*
 * Decompiled with CFR 0.152.
 */
package net.fruchtlabor.composterplus.listeners;

import java.util.List;
import java.util.Objects;
import net.fruchtlabor.composterplus.ComposterPlus;
import net.fruchtlabor.composterplus.Loot;
import net.fruchtlabor.composterplus.SpecialCompost;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FermentingListener
implements Listener {
    private Plugin plugin;

    public FermentingListener(Plugin plugin) {
        this.plugin = plugin;
    }

    private void giveExtraBountyHopper(Location location) {
        Loot loot = this.chooseOnWeight(ComposterPlus.lootList);
        try {
            Material material = Material.matchMaterial((String)loot.getMat());
            assert (material != null);
            ItemStack itemStack = new ItemStack(material, loot.getAmount());
            Block block = location.getBlock();
            if (!block.getType().equals((Object)Material.HOPPER)) {
                return;
            }
            if (block.getState() instanceof Hopper) {
                Hopper hopper = (Hopper)block.getState();
                hopper.getInventory().addItem(new ItemStack[]{itemStack});
                block.getState().update();
            }
            if (loot.getXp() > 0) {
                int orbs = loot.getXp();
                ((ExperienceOrb)Objects.requireNonNull(location.getWorld(), "World is null!").spawn(location, ExperienceOrb.class)).setExperience(orbs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "Seems like you failed to write the correct Material-name in the config! " + ChatColor.RED + loot.getMat());
        }
    }

    private void giveExtraBounty(Location location) {
        Loot loot = this.chooseOnWeight(ComposterPlus.lootList);
        try {
            Material material = Material.matchMaterial((String)loot.getMat());
            Objects.requireNonNull(material, "Material is null!");
            ItemStack itemStack = new ItemStack(material, loot.getAmount());
            Objects.requireNonNull(location.getWorld(), "World is null!").dropItemNaturally(location, itemStack);
            if (loot.getXp() > 0) {
                int orbs = loot.getXp();
                ((ExperienceOrb)location.getWorld().spawn(location, ExperienceOrb.class)).setExperience(orbs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "Seems like you failed to write the correct Material name in the config!" + ChatColor.RED + loot.getMat());
        }
    }

    public Loot chooseOnWeight(List<Loot> items) {
        double completeWeight = 0.0;
        for (Loot item : items) {
            completeWeight += item.getChance();
        }
        double r = Math.random() * completeWeight;
        double countWeight = 0.0;
        for (Loot item : items) {
            if (!((countWeight += item.getChance()) >= r)) continue;
            return item;
        }
        throw new RuntimeException("Should never be shown.");
    }

    @EventHandler
    public void Fermenting(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getClickedBlock().getType().equals((Object)Material.COMPOSTER)) {
            Block block = event.getClickedBlock();
            BlockState state = block.getState();
            BlockData data = block.getBlockData();
            Levelled lev = (Levelled)data;
            if (lev.getMaximumLevel() > lev.getLevel()) {
                for (SpecialCompost compost : ComposterPlus.sclist) {
                    if (compost.getMaterial().equalsIgnoreCase(event.getMaterial().name())) {
                        lev.setLevel(Math.min(lev.getLevel() + compost.getLevel(), lev.getMaximumLevel()));
                        event.getPlayer().getInventory().getItemInMainHand().setAmount(event.getPlayer().getInventory().getItemInMainHand().getAmount() - 1);
                    }
                    state.setBlockData(data);
                    state.update();
                }
            } else {
                this.giveExtraBounty(block.getLocation());
            }
        }
    }

    @EventHandler
    public void FermentingHopper(InventoryMoveItemEvent event) {
        if (event.getSource().getType().name().equalsIgnoreCase("HOPPER") && this.plugin.getConfig().getBoolean("Hopperinteraction")) {
            Location loc = event.getSource().getLocation();
            assert (loc != null);
            loc.setY(loc.getY() - 1.0);
            if (loc.getBlock().getType().equals((Object)Material.COMPOSTER)) {
                Block block = loc.getBlock();
                BlockState state = block.getState();
                BlockData data = block.getBlockData();
                Levelled lev = (Levelled)data;
                for (SpecialCompost compost : ComposterPlus.sclist) {
                    if (!compost.getMaterial().equalsIgnoreCase(event.getItem().getType().name())) continue;
                    lev.setLevel(Math.min(lev.getLevel() + compost.getLevel(), lev.getMaximumLevel()));
                    event.setItem(new ItemStack(Material.AIR));
                }
                state.setBlockData(data);
                state.update();
                if (lev.getLevel() == lev.getMaximumLevel()) {
                    loc.setY(loc.getY() - 1.0);
                    this.giveExtraBountyHopper(loc);
                }
            }
        }
    }

    @EventHandler
    public void onTopPlace(BlockPlaceEvent event) {
        Location location = event.getBlock().getLocation();
        location.setY(location.getY() - 1.0);
        Block block = location.getBlock();
        if (block.getType() == Material.COMPOSTER) {
            for (int i = 0; i < ComposterPlus.sclist.size(); ++i) {
                if (!ComposterPlus.sclist.get(i).getMaterial().equalsIgnoreCase(event.getBlock().getType().name()) || event.getBlock().getType() == Material.HOPPER) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

