/*
 * Decompiled with CFR 0.152.
 */
package net.fruchtlabor.composterplus;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import net.fruchtlabor.composterplus.Loot;
import net.fruchtlabor.composterplus.SpecialCompost;
import net.fruchtlabor.composterplus.commands.DefaultCommand;
import net.fruchtlabor.composterplus.listeners.FermentingListener;
import net.fruchtlabor.composterplus.listeners.GUIManagement;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ComposterPlus
extends JavaPlugin {
    public static ArrayList<Loot> lootList;
    public static ArrayList<SpecialCompost> sclist;
    public static Plugin plugin;

    public void onEnable() {
        plugin = this;
        ComposterPlus.setupConfig();
        ComposterPlus.setupLootlist();
        ComposterPlus.setupSclist();
        FermentingListener fermentingListener = new FermentingListener((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)fermentingListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIManagement((Plugin)this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("cp"), "Command cp has not been initialized!").setExecutor((CommandExecutor)new DefaultCommand());
    }

    public static void setupConfig() {
        File file = new File(plugin.getDataFolder() + File.separator + "config.yml");
        if (!file.exists()) {
            plugin.saveDefaultConfig();
        } else {
            plugin.reloadConfig();
        }
    }

    public static void setupLootlist() {
        File data = new File(plugin.getDataFolder() + File.separator + "loot.yml");
        YamlConfiguration dataconfig = YamlConfiguration.loadConfiguration((File)data);
        if (!data.exists()) {
            plugin.saveResource("loot.yml", false);
        } else {
            try {
                dataconfig.save(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        lootList = new ArrayList();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)data);
        ConfigurationSection section = yamlConfiguration.getConfigurationSection("loot");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                lootList.add(new Loot(Objects.requireNonNull(section.getConfigurationSection(key))));
            }
        }
    }

    public static void setupSclist() {
        File data = new File(plugin.getDataFolder() + File.separator + "specialcompost.yml");
        YamlConfiguration dataconfig = YamlConfiguration.loadConfiguration((File)data);
        if (!data.exists()) {
            plugin.saveResource("specialcompost.yml", false);
        } else {
            try {
                dataconfig.save(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sclist = new ArrayList();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)data);
        ConfigurationSection section = yamlConfiguration.getConfigurationSection("SpecialCompost");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                sclist.add(new SpecialCompost(Objects.requireNonNull(section.getConfigurationSection(key))));
            }
        }
    }

    public static boolean addSc(SpecialCompost specialCompost, int index) {
        File data = new File(plugin.getDataFolder() + File.separator + "specialcompost.yml");
        YamlConfiguration dataconfig = YamlConfiguration.loadConfiguration((File)data);
        if (!data.exists()) {
            plugin.saveResource("specialcompost.yml", false);
        } else {
            try {
                dataconfig.save(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dataconfig.set("SpecialCompost." + index + ".material", (Object)specialCompost.getMaterial());
        dataconfig.set("SpecialCompost." + index + ".level", (Object)specialCompost.getLevel());
        try {
            dataconfig.save(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean addLoot(Loot loot, int index) {
        File data = new File(plugin.getDataFolder() + File.separator + "loot.yml");
        YamlConfiguration dataconfig = YamlConfiguration.loadConfiguration((File)data);
        if (!data.exists()) {
            plugin.saveResource("loot.yml", false);
        } else {
            try {
                dataconfig.save(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dataconfig.set("loot." + index + ".material", (Object)loot.getMat());
        dataconfig.set("loot." + index + ".amount", (Object)loot.getAmount());
        dataconfig.set("loot." + index + ".chance", (Object)loot.getChance());
        dataconfig.set("loot." + index + ".xp", (Object)loot.getXp());
        try {
            dataconfig.save(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean removeLoot() {
        return false;
    }

    public static boolean removeSC() {
        return false;
    }
}

