/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates.manager;

import java.util.HashMap;
import java.util.UUID;
import leon_lp9.compactcrates.CompactCrates;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;

public class SpawnCratesManager {
    public static final HashMap<Location, Material> beforCrates = new HashMap();
    public static final HashMap<String, String> getArmorStand = new HashMap();
    public static final HashMap<String, String> getArmorStandClick = new HashMap();

    public static void spawnCrates() {
        SpawnCratesManager.removeCrates();
        if (CompactCrates.getInstance().getChestConfig().contains("chestsPositions")) {
            for (String key : CompactCrates.getInstance().getChestConfig().getConfigurationSection("chestsPositions").getKeys(false)) {
                String world = CompactCrates.getInstance().getChestConfig().getString("chestsPositions." + key + ".world");
                int x = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".x");
                int y = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".y");
                int z = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".z");
                String type = CompactCrates.getInstance().getChestConfig().getString("chestsPositions." + key + ".type");
                String name = CompactCrates.getInstance().getChestConfig().getString("chestsPositions." + key + ".name").replace("&", "\u00a7");
                if (world == null || type == null || name == null) continue;
                Location location = new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z);
                if (!beforCrates.containsKey(location)) {
                    beforCrates.put(location, location.getBlock().getType());
                }
                try {
                    location.getBlock().setType(Material.valueOf((String)type));
                }
                catch (Exception e) {
                    CompactCrates.getInstance().getLogger().warning(CompactCrates.getPrefix() + "The type of the chest " + name + " is not valid!");
                }
                ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location.clone().add(0.5, 1.2, 0.5), ArmorStand.class);
                armorStand.setCustomName(name);
                armorStand.setCustomNameVisible(true);
                armorStand.setGravity(false);
                armorStand.setInvulnerable(true);
                armorStand.setMarker(true);
                armorStand.setInvisible(true);
                armorStand.setSilent(true);
                armorStand.setPersistent(true);
                armorStand.setCollidable(false);
                getArmorStand.put(key, armorStand.getUniqueId().toString());
                ArmorStand armorStandKlick = (ArmorStand)location.getWorld().spawn(location.clone().add(0.5, 0.9, 0.5), ArmorStand.class);
                armorStandKlick.setCustomName(CompactCrates.getInstance().getLanguageConfig().getString("click").replace("&", "\u00a7"));
                armorStandKlick.setCustomNameVisible(true);
                armorStandKlick.setGravity(false);
                armorStandKlick.setInvulnerable(true);
                armorStandKlick.setMarker(true);
                armorStandKlick.setInvisible(true);
                armorStandKlick.setSilent(true);
                armorStandKlick.setPersistent(true);
                armorStandKlick.setCollidable(false);
                getArmorStandClick.put(key, armorStandKlick.getUniqueId().toString());
            }
        }
    }

    public static void removeCrates() {
        for (Location location : beforCrates.keySet()) {
            location.getBlock().setType(beforCrates.get(location));
        }
        beforCrates.clear();
        getArmorStand.forEach((id, name) -> {
            ArmorStand armorStand = (ArmorStand)Bukkit.getEntity((UUID)UUID.fromString(name));
            if (armorStand != null) {
                armorStand.remove();
            }
        });
        getArmorStand.clear();
        getArmorStandClick.forEach((id, name) -> {
            ArmorStand armorStand = (ArmorStand)Bukkit.getEntity((UUID)UUID.fromString(name));
            if (armorStand != null) {
                armorStand.remove();
            }
        });
        getArmorStandClick.clear();
    }

    public static Boolean isCrate(Location location) {
        return beforCrates.containsKey(location);
    }

    public static void removeCrate(Location location) {
        for (String key : CompactCrates.getInstance().getChestConfig().getConfigurationSection("chestsPositions").getKeys(false)) {
            String world = CompactCrates.getInstance().getChestConfig().getString("chestsPositions." + key + ".world");
            int x = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".x");
            int y = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".y");
            int z = CompactCrates.getInstance().getChestConfig().getInt("chestsPositions." + key + ".z");
            if (!location.getWorld().getName().equals(world) || location.getBlockX() != x || location.getBlockY() != y || location.getBlockZ() != z) continue;
            CompactCrates.getInstance().getChestConfig().set("chestsPositions." + key, null);
            CompactCrates.getInstance().saveChestsConfig();
            location.getBlock().setType(beforCrates.get(location));
            beforCrates.remove(location);
            SpawnCratesManager.spawnCrates();
            break;
        }
    }

    public static Location getNearbyCrate(Location location) {
        for (Location loc : beforCrates.keySet()) {
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distance(location) <= 8.5)) continue;
            return loc;
        }
        return null;
    }
}

