/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import leon_lp9.compactcrates.CompactCrates;
import leon_lp9.compactcrates.builder.ItemBuilder;
import leon_lp9.compactcrates.builder.ItemChecker;
import leon_lp9.compactcrates.manager.ParticleManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class OpenCrate {
    static Double defaultProbability = 100.0;
    public static HashMap<Player, Inventory> getInventory = new HashMap();
    public static HashMap<Player, BukkitTask> getRunnable = new HashMap();
    public static HashMap<Player, String> getCrateID = new HashMap();

    public static void openCrate(Player player, String crateID, String crateName) {
        defaultProbability = CompactCrates.getInstance().getConfig().getDouble("defaultProbability");
        SpinType st = SpinType.getSpinTypeOfCrateID(crateID);
        Inventory inv = Bukkit.createInventory(null, (int)(st == SpinType.WHEEL_OF_FORTUNE ? 54 : (st == SpinType.FALLING ? 45 : 27)), (String)("\u00a77Open.. \u00a76\u00a7l" + crateName));
        if (st == SpinType.CSGO || st == SpinType.WHEEL_OF_FORTUNE) {
            inv.setItem(4, new ItemBuilder(Material.END_ROD).setDisplayName("\u00a76\u00a7l\u2193").build());
            inv.setItem(22, new ItemBuilder(Material.END_ROD).setDisplayName("\u00a76\u00a7l\u2191").build());
        }
        if (st == SpinType.FALLING) {
            inv.setItem(21, new ItemBuilder(Material.CONDUIT).setDisplayName("\u00a76\u00a7l\u2192").build());
            inv.setItem(23, new ItemBuilder(Material.CONDUIT).setDisplayName("\u00a76\u00a7l\u2190").build());
        }
        player.openInventory(inv);
        getInventory.put(player, inv);
        getCrateID.put(player, crateID);
        OpenCrate.startRunnableForSinglePlayer(player, crateID);
    }

    public static ItemStack getRandomCrateItem(String crateID) {
        ArrayList items = new ArrayList();
        if (!CompactCrates.getInstance().getChestConfig().contains("chestContents." + crateID)) {
            return new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7c\u00a7lERROR").build();
        }
        CompactCrates.getInstance().getChestConfig().getConfigurationSection("chestContents." + crateID).getKeys(false).forEach(key -> {
            ItemStack item = CompactCrates.getInstance().getChestConfig().getItemStack("chestContents." + crateID + "." + key);
            if (item != null && item.getType() != Material.AIR) {
                items.add(item);
            }
        });
        if (items.size() == 0) {
            return new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7c\u00a7lERROR").build();
        }
        double cumulativeProbability = 0.0;
        for (ItemStack item : items) {
            ItemChecker itemChecker = new ItemChecker(item);
            if (itemChecker.hasCustomTag("probability", ItemTagType.DOUBLE)) {
                cumulativeProbability += Double.parseDouble(String.valueOf(itemChecker.getCustomTag("probability", ItemTagType.DOUBLE)));
                continue;
            }
            cumulativeProbability += defaultProbability.doubleValue();
        }
        double randomProbability = new Random().nextDouble() * cumulativeProbability;
        double TempCumulativeProbability = 0.0;
        ItemStack randomItem = new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7c\u00a7lERROR").build();
        for (ItemStack item : items) {
            ItemChecker itemChecker = new ItemChecker(item);
            TempCumulativeProbability = itemChecker.hasCustomTag("probability", ItemTagType.DOUBLE) ? (TempCumulativeProbability += Double.parseDouble(String.valueOf(itemChecker.getCustomTag("probability", ItemTagType.DOUBLE)))) : (TempCumulativeProbability += defaultProbability.doubleValue());
            if (!(randomProbability <= TempCumulativeProbability)) continue;
            randomItem = item;
            break;
        }
        if (new ItemChecker(randomItem).hasCustomTag("commands", ItemTagType.STRING)) {
            ItemBuilder itemBuilder = new ItemBuilder(randomItem);
            if (CompactCrates.getInstance().getConfig().contains("CommandRewardPreview") && CompactCrates.getInstance().getConfig().getBoolean("CommandRewardPreview")) {
                ArrayList commands = (ArrayList)CompactCrates.getInstance().getConfig().getStringList("CommandRewardLores");
                for (String command : commands) {
                    itemBuilder.addLineLore(command.replace("&", "\u00a7"));
                }
            }
            return itemBuilder.build();
        }
        return randomItem;
    }

    public static void startRunnableForSinglePlayer(Player player, String crateID) {
        Integer[] time = new Integer[]{0};
        Double[] nextTime = new Double[]{-10.0};
        Integer[] delay = new Integer[]{0};
        BukkitTask myTask = Bukkit.getScheduler().runTaskTimer((Plugin)CompactCrates.getInstance(), () -> {
            Integer n = time[0];
            time[0] = time[0] + 1;
            n = delay[0];
            delay[0] = delay[0] + 1;
            if ((double)delay[0].intValue() >= nextTime[0]) {
                nextTime[0] = nextTime[0] + Double.parseDouble(CompactCrates.getInstance().getConfig().getString("DecelerateSpeed"));
                delay[0] = 0;
                OpenCrate.nextSpinStep(player, crateID, SpinType.getSpinTypeOfCrateID(crateID));
                player.playSound(player.getLocation(), "block.note_block.pling", 1.0f, 1.0f);
            }
            if (time[0] == Integer.parseInt(CompactCrates.getInstance().getConfig().getString("SpinTime"))) {
                OpenCrate.nextSpinStep(player, crateID, SpinType.getSpinTypeOfCrateID(crateID));
                OpenCrate.giveItem(player, getInventory.get(player).getItem(OpenCrate.getPickSlot(SpinType.getSpinTypeOfCrateID(crateID)).intValue()));
            }
        }, 0L, 1L);
        getRunnable.put(player, myTask);
    }

    public static void nextSpinStep(Player player, String crateID, SpinType spinType) {
        if (spinType == SpinType.CSGO) {
            OpenCrate.setBGItemInInv(player, crateID, 0);
            OpenCrate.setBGItemInInv(player, crateID, 1);
            OpenCrate.setBGItemInInv(player, crateID, 2);
            OpenCrate.setBGItemInInv(player, crateID, 3);
            OpenCrate.setBGItemInInv(player, crateID, 5);
            OpenCrate.setBGItemInInv(player, crateID, 6);
            OpenCrate.setBGItemInInv(player, crateID, 7);
            OpenCrate.setBGItemInInv(player, crateID, 8);
            getInventory.get(player).setItem(9, getInventory.get(player).getItem(10));
            getInventory.get(player).setItem(10, getInventory.get(player).getItem(11));
            getInventory.get(player).setItem(11, getInventory.get(player).getItem(12));
            getInventory.get(player).setItem(12, getInventory.get(player).getItem(13));
            getInventory.get(player).setItem(13, getInventory.get(player).getItem(14));
            getInventory.get(player).setItem(14, getInventory.get(player).getItem(15));
            getInventory.get(player).setItem(15, getInventory.get(player).getItem(16));
            getInventory.get(player).setItem(16, getInventory.get(player).getItem(17));
            getInventory.get(player).setItem(17, OpenCrate.getRandomCrateItem(crateID));
            OpenCrate.setBGItemInInv(player, crateID, 18);
            OpenCrate.setBGItemInInv(player, crateID, 19);
            OpenCrate.setBGItemInInv(player, crateID, 20);
            OpenCrate.setBGItemInInv(player, crateID, 21);
            OpenCrate.setBGItemInInv(player, crateID, 23);
            OpenCrate.setBGItemInInv(player, crateID, 24);
            OpenCrate.setBGItemInInv(player, crateID, 25);
            OpenCrate.setBGItemInInv(player, crateID, 26);
        } else if (spinType == SpinType.SINGLE) {
            for (int i = 0; i < 27; ++i) {
                OpenCrate.setBGItemInInv(player, crateID, i);
            }
            getInventory.get(player).setItem(13, OpenCrate.getRandomCrateItem(crateID));
        } else if (spinType == SpinType.WHEEL_OF_FORTUNE) {
            OpenCrate.setBGItemInInv(player, crateID, 0);
            OpenCrate.setBGItemInInv(player, crateID, 1);
            OpenCrate.setBGItemInInv(player, crateID, 2);
            OpenCrate.setBGItemInInv(player, crateID, 3);
            OpenCrate.setBGItemInInv(player, crateID, 5);
            OpenCrate.setBGItemInInv(player, crateID, 6);
            OpenCrate.setBGItemInInv(player, crateID, 7);
            OpenCrate.setBGItemInInv(player, crateID, 8);
            OpenCrate.setBGItemInInv(player, crateID, 9);
            OpenCrate.setBGItemInInv(player, crateID, 10);
            OpenCrate.setBGItemInInv(player, crateID, 11);
            OpenCrate.setBGItemInInv(player, crateID, 15);
            OpenCrate.setBGItemInInv(player, crateID, 16);
            OpenCrate.setBGItemInInv(player, crateID, 17);
            OpenCrate.setBGItemInInv(player, crateID, 18);
            OpenCrate.setBGItemInInv(player, crateID, 19);
            OpenCrate.setBGItemInInv(player, crateID, 21);
            OpenCrate.setBGItemInInv(player, crateID, 23);
            OpenCrate.setBGItemInInv(player, crateID, 25);
            OpenCrate.setBGItemInInv(player, crateID, 26);
            OpenCrate.setBGItemInInv(player, crateID, 27);
            OpenCrate.setBGItemInInv(player, crateID, 28);
            OpenCrate.setBGItemInInv(player, crateID, 30);
            OpenCrate.setBGItemInInv(player, crateID, 31);
            OpenCrate.setBGItemInInv(player, crateID, 32);
            OpenCrate.setBGItemInInv(player, crateID, 34);
            OpenCrate.setBGItemInInv(player, crateID, 35);
            OpenCrate.setBGItemInInv(player, crateID, 36);
            OpenCrate.setBGItemInInv(player, crateID, 37);
            OpenCrate.setBGItemInInv(player, crateID, 39);
            OpenCrate.setBGItemInInv(player, crateID, 40);
            OpenCrate.setBGItemInInv(player, crateID, 41);
            OpenCrate.setBGItemInInv(player, crateID, 43);
            OpenCrate.setBGItemInInv(player, crateID, 44);
            OpenCrate.setBGItemInInv(player, crateID, 45);
            OpenCrate.setBGItemInInv(player, crateID, 46);
            OpenCrate.setBGItemInInv(player, crateID, 47);
            OpenCrate.setBGItemInInv(player, crateID, 51);
            OpenCrate.setBGItemInInv(player, crateID, 52);
            OpenCrate.setBGItemInInv(player, crateID, 53);
            ItemStack item = getInventory.get(player).getItem(12);
            getInventory.get(player).setItem(12, getInventory.get(player).getItem(20));
            getInventory.get(player).setItem(20, getInventory.get(player).getItem(29));
            getInventory.get(player).setItem(29, getInventory.get(player).getItem(38));
            getInventory.get(player).setItem(38, getInventory.get(player).getItem(48));
            getInventory.get(player).setItem(48, getInventory.get(player).getItem(49));
            getInventory.get(player).setItem(49, getInventory.get(player).getItem(50));
            getInventory.get(player).setItem(50, getInventory.get(player).getItem(42));
            getInventory.get(player).setItem(42, getInventory.get(player).getItem(33));
            getInventory.get(player).setItem(33, getInventory.get(player).getItem(24));
            getInventory.get(player).setItem(24, getInventory.get(player).getItem(14));
            getInventory.get(player).setItem(14, getInventory.get(player).getItem(13));
            if (item == null) {
                getInventory.get(player).setItem(13, OpenCrate.getRandomCrateItem(crateID));
            } else {
                getInventory.get(player).setItem(13, item);
            }
        } else if (spinType == SpinType.FALLING) {
            OpenCrate.setBGItemInInv(player, crateID, 0);
            OpenCrate.setBGItemInInv(player, crateID, 1);
            OpenCrate.setBGItemInInv(player, crateID, 2);
            OpenCrate.setBGItemInInv(player, crateID, 3);
            OpenCrate.setBGItemInInv(player, crateID, 5);
            OpenCrate.setBGItemInInv(player, crateID, 6);
            OpenCrate.setBGItemInInv(player, crateID, 7);
            OpenCrate.setBGItemInInv(player, crateID, 8);
            OpenCrate.setBGItemInInv(player, crateID, 9);
            OpenCrate.setBGItemInInv(player, crateID, 10);
            OpenCrate.setBGItemInInv(player, crateID, 11);
            OpenCrate.setBGItemInInv(player, crateID, 12);
            OpenCrate.setBGItemInInv(player, crateID, 14);
            OpenCrate.setBGItemInInv(player, crateID, 15);
            OpenCrate.setBGItemInInv(player, crateID, 16);
            OpenCrate.setBGItemInInv(player, crateID, 17);
            OpenCrate.setBGItemInInv(player, crateID, 18);
            OpenCrate.setBGItemInInv(player, crateID, 19);
            OpenCrate.setBGItemInInv(player, crateID, 20);
            OpenCrate.setBGItemInInv(player, crateID, 24);
            OpenCrate.setBGItemInInv(player, crateID, 25);
            OpenCrate.setBGItemInInv(player, crateID, 26);
            OpenCrate.setBGItemInInv(player, crateID, 27);
            OpenCrate.setBGItemInInv(player, crateID, 28);
            OpenCrate.setBGItemInInv(player, crateID, 29);
            OpenCrate.setBGItemInInv(player, crateID, 30);
            OpenCrate.setBGItemInInv(player, crateID, 32);
            OpenCrate.setBGItemInInv(player, crateID, 33);
            OpenCrate.setBGItemInInv(player, crateID, 34);
            OpenCrate.setBGItemInInv(player, crateID, 35);
            OpenCrate.setBGItemInInv(player, crateID, 36);
            OpenCrate.setBGItemInInv(player, crateID, 37);
            OpenCrate.setBGItemInInv(player, crateID, 38);
            OpenCrate.setBGItemInInv(player, crateID, 39);
            OpenCrate.setBGItemInInv(player, crateID, 41);
            OpenCrate.setBGItemInInv(player, crateID, 42);
            OpenCrate.setBGItemInInv(player, crateID, 43);
            OpenCrate.setBGItemInInv(player, crateID, 44);
            getInventory.get(player).setItem(40, getInventory.get(player).getItem(31));
            getInventory.get(player).setItem(31, getInventory.get(player).getItem(22));
            getInventory.get(player).setItem(22, getInventory.get(player).getItem(13));
            getInventory.get(player).setItem(13, getInventory.get(player).getItem(4));
            getInventory.get(player).setItem(4, OpenCrate.getRandomCrateItem(crateID));
        }
    }

    public static void setBGItemInInv(Player player, String crateID, Integer slot) {
        List bgItem = CompactCrates.getInstance().getChestConfig().getStringList("cratesTypes." + crateID + ".FillWith");
        if (bgItem.size() == 0) {
            return;
        }
        Random r = new Random();
        Material mat = Material.valueOf((String)((String)bgItem.get(r.nextInt(bgItem.size()))));
        if (mat == Material.AIR) {
            return;
        }
        getInventory.get(player).setItem(slot.intValue(), new ItemBuilder(mat).setDisplayName("\u00a77").build());
    }

    public static Integer getPickSlot(SpinType spinType) {
        if (spinType == SpinType.CSGO) {
            return 13;
        }
        if (spinType == SpinType.SINGLE) {
            return 13;
        }
        if (spinType == SpinType.WHEEL_OF_FORTUNE) {
            return 13;
        }
        if (spinType == SpinType.FALLING) {
            return 22;
        }
        return 0;
    }

    public static void giveItem(Player player, ItemStack itemStack) {
        if (new ItemChecker(itemStack).hasCustomTag("winparticle", ItemTagType.STRING)) {
            if (new ItemChecker(itemStack).getCustomTag("winparticle", ItemTagType.STRING).equals("fallingBlocks".toUpperCase())) {
                ParticleManager.spawnFallingBlocksAboveNearbyChest(player.getLocation());
            } else if (new ItemChecker(itemStack).getCustomTag("winparticle", ItemTagType.STRING).equals("fireworks".toUpperCase())) {
                ParticleManager.spawnFireworkAboveNearbyChest(player.getLocation());
            }
        }
        player.playSound(player.getLocation(), "entity.player.levelup", 1.0f, 1.0f);
        if (new ItemChecker(itemStack).hasCustomTag("commands", ItemTagType.STRING)) {
            ItemBuilder itemBuilder = new ItemBuilder(itemStack);
            String[] commands = new ItemChecker(itemStack).getCustomTag("commands", ItemTagType.STRING).toString().split("/");
            for (int i = 0; i < commands.length; ++i) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commands[i].replace("%player%", player.getName()).replace("&", "\u00a7"));
            }
        } else {
            player.getInventory().addItem(new ItemStack[]{itemStack});
        }
        getRunnable.get(player).cancel();
        getRunnable.remove(player);
        getInventory.remove(player);
        getCrateID.remove(player);
    }

    public static enum SpinType {
        CSGO,
        SINGLE,
        WHEEL_OF_FORTUNE,
        FALLING;


        public static SpinType getSpinType(String type) {
            for (SpinType spinType : SpinType.values()) {
                if (!spinType.name().equalsIgnoreCase(type)) continue;
                return spinType;
            }
            return null;
        }

        public static SpinType getSpinTypeOfCrateID(String crateID) {
            AtomicReference<SpinType> spinType = new AtomicReference<SpinType>(CSGO);
            CompactCrates.getInstance().getChestConfig().getConfigurationSection("cratesTypes").getKeys(false).forEach(key -> {
                if (CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + key + ".ID").equalsIgnoreCase(crateID) && CompactCrates.getInstance().getChestConfig().contains("cratesTypes." + key + ".SpinType")) {
                    spinType.set(SpinType.getSpinType(CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + key + ".SpinType")));
                }
            });
            return spinType.get();
        }
    }
}

