/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates.builder;

import leon_lp9.compactcrates.CompactCrates;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.plugin.Plugin;

public class ItemChecker {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;

    public ItemChecker(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
    }

    public boolean isDisplayName(String displayName) {
        return this.itemMeta.getDisplayName().equals(displayName);
    }

    public boolean isLocalizedName(String localizedName) {
        return this.itemMeta.getLocalizedName().equals(localizedName);
    }

    public boolean isLore(String ... lore) {
        return this.itemMeta.getLore().equals(lore);
    }

    public boolean isUnbreakable(boolean unbreakable) {
        return this.itemMeta.isUnbreakable() == unbreakable;
    }

    public boolean isDurability(short durability) {
        return this.itemStack.getDurability() == durability;
    }

    public boolean hasEnchantment(Enchantment enchantment, int level) {
        return this.itemMeta.hasEnchant(enchantment) && this.itemMeta.getEnchantLevel(enchantment) == level;
    }

    public boolean hasEnchantment(Enchantment enchantment) {
        return this.itemMeta.hasEnchant(enchantment);
    }

    public boolean isDisplayNameContains(String displayName) {
        return this.itemMeta.getDisplayName().contains(displayName);
    }

    public boolean isLocalizedNameContains(String localizedName) {
        return this.itemMeta.getLocalizedName().contains(localizedName);
    }

    public boolean hasCustomTag(String key, ItemTagType type) {
        if (this.itemMeta == null) {
            return false;
        }
        return this.itemMeta.getCustomTagContainer().hasCustomTag(new NamespacedKey((Plugin)CompactCrates.getInstance(), key), type);
    }

    public Object getCustomTag(String key, ItemTagType type) {
        if (this.itemMeta == null) {
            return null;
        }
        return this.itemMeta.getCustomTagContainer().getCustomTag(new NamespacedKey((Plugin)CompactCrates.getInstance(), key), type);
    }

    public boolean isLoreContains(String ... lore) {
        return this.itemMeta.getLore().contains(lore);
    }
}

