/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.tags.ItemTagType;

public class ItemBuilder {
    private ItemStack itemStack;
    private ItemMeta itemMeta;

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(ItemStack itemStack) {
        this.itemStack = new ItemStack(itemStack);
        this.itemMeta = itemStack.getItemMeta();
    }

    public ItemBuilder setDisplayName(String displayName) {
        this.itemMeta.setDisplayName(displayName);
        return this;
    }

    public ItemBuilder setLocalizedName(String localizedName) {
        this.itemMeta.setLocalizedName(localizedName);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        this.itemMeta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder addLineLore(String lore) {
        if (this.itemMeta.getLore() == null) {
            this.itemMeta.setLore(List.of(lore));
        } else {
            ArrayList<String> loreList = new ArrayList<String>(this.itemMeta.getLore());
            loreList.add(lore);
            this.itemMeta.setLore(loreList);
        }
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.itemMeta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemBuilder setDurability(short durability) {
        this.itemStack.setItemMeta(this.itemMeta);
        this.itemStack.setDurability(durability);
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder setLeatherArmorColorRGB(int r, int g, int b) {
        if (this.itemStack.getType().name().contains("LEATHER_")) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.itemMeta;
            leatherArmorMeta.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            this.itemMeta = leatherArmorMeta;
        }
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        if (this.itemStack.getType().name().contains("LEATHER_")) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.itemMeta;
            leatherArmorMeta.setColor(color);
            this.itemMeta = leatherArmorMeta;
        }
        return this;
    }

    public ItemBuilder addBannerPattern(PatternType patternType, DyeColor color) {
        if (this.itemStack.getType().name().contains("BANNER")) {
            BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
            bannerMeta.addPattern(new Pattern(color, patternType));
            this.itemMeta = bannerMeta;
        }
        return this;
    }

    public ItemBuilder addBookPage(String ... page) {
        if (this.itemStack.getType().name().contains("BOOK")) {
            ItemMeta bookMeta = this.itemMeta;
            bookMeta.setLore(Arrays.asList(page));
            this.itemMeta = bookMeta;
        }
        return this;
    }

    public ItemBuilder addSkullOwner(String owner) {
        if (this.itemStack.getType().name().contains("SKULL")) {
            ItemMeta skullMeta = this.itemMeta;
            skullMeta.setDisplayName(owner);
            this.itemMeta = skullMeta;
        }
        return this;
    }

    public ItemBuilder addCustomTag(String NSkey, ItemTagType type, Object value) {
        NamespacedKey key = new NamespacedKey("compactcrates", NSkey);
        this.itemMeta.getCustomTagContainer().setCustomTag(key, type, value);
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

