/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import leon_lp9.compactcrates.CompactCrates;
import leon_lp9.compactcrates.builder.ItemBuilder;
import leon_lp9.compactcrates.builder.ItemChecker;
import leon_lp9.compactcrates.manager.OpenCrate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.ItemTagType;

public class InventoryManager
implements Listener {
    public static void openFirstInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)CompactCrates.getInstance().getConfig().getInt("inventorySize"), (String)CompactCrates.getInstance().getLanguageConfig().getString("firstInventoryName"));
        CompactCrates.getInstance().getChestConfig().getConfigurationSection("cratesTypes").getKeys(false).forEach(s -> {
            ItemStack itemStack = new ItemBuilder(Material.getMaterial((String)CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Type"))).setLocalizedName("crate").setDisplayName(CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Name").replace("&", "\u00a7")).setLocalizedName(CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID")).build();
            ItemMeta itemMeta = itemStack.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            if (!CompactCrates.getInstance().getUserConfig().contains(player.getUniqueId().toString() + "." + CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID") + ".Keys")) {
                CompactCrates.getInstance().getUserConfig().set(player.getUniqueId().toString() + "." + CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID") + ".Keys", (Object)0);
                CompactCrates.getInstance().saveUserConfig();
            }
            CompactCrates.getInstance().getLanguageConfig().getStringList("firstInventoryLore").forEach(s1 -> lore.add(s1.replace("%key%", CompactCrates.getInstance().getUserConfig().getString(player.getUniqueId().toString() + "." + CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID") + ".Keys")).replace("&", "\u00a7")));
            lore.add("\u00a77");
            lore.add("\u00a7e\u00a7oLeft click\u00a7e to open the crate");
            lore.add("\u00a7e\u00a7oRight click\u00a7e to see the rewards");
            if (player.hasPermission("compactcrates.admin") && player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                lore.add("\u00a7e\u00a7oMiddle click\u00a7e to edit the crate (Admin)");
            }
            lore.add("\u00a77");
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(Integer.parseInt(CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Slot")), itemStack);
        });
        player.openInventory(inventory);
    }

    public void openSecondInventory(Player player, String crateID, String crateName) {
        int i;
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", crateName).replace("&", "\u00a7"));
        for (i = 0; i < 45; ++i) {
            if (CompactCrates.getInstance().getChestConfig().contains("chestContents." + crateID + "." + i)) {
                ItemBuilder itemBuilder;
                ItemStack is = CompactCrates.getInstance().getChestConfig().getItemStack("chestContents." + crateID + "." + i);
                ItemStack stackwithlore = null;
                inventory.setItem(i, is);
                if (new ItemChecker(is).hasCustomTag("previewlore", ItemTagType.STRING)) {
                    itemBuilder = new ItemBuilder(is);
                    String[] lore = new ItemChecker(is).getCustomTag("previewlore", ItemTagType.STRING).toString().split("/n");
                    for (String s : lore) {
                        itemBuilder.addLineLore(s.replace("&", "\u00a7"));
                    }
                    inventory.setItem(i, itemBuilder.build());
                    stackwithlore = itemBuilder.build();
                }
                if (!new ItemChecker(stackwithlore == null ? is : stackwithlore).hasCustomTag("commands", ItemTagType.STRING)) continue;
                itemBuilder = new ItemBuilder(stackwithlore == null ? is : stackwithlore);
                if (CompactCrates.getInstance().getConfig().contains("CommandRewardPreview") && CompactCrates.getInstance().getConfig().getBoolean("CommandRewardPreview")) {
                    ArrayList commands = (ArrayList)CompactCrates.getInstance().getConfig().getStringList("CommandRewardLores");
                    for (String command : commands) {
                        itemBuilder.addLineLore(command.replace("&", "\u00a7"));
                    }
                }
                inventory.setItem(i, itemBuilder.build());
                continue;
            }
            CompactCrates.getInstance().getChestConfig().set("chestContents." + crateID + "." + i, (Object)new ItemStack(Material.AIR));
            CompactCrates.getInstance().saveChestsConfig();
        }
        for (i = 0; i < 9; ++i) {
            inventory.setItem(i + 45, new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setDisplayName("\u00a77").build());
        }
        inventory.setItem(49, new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7c\u00a7lBack").setLocalizedName("back").build());
        player.openInventory(inventory);
    }

    public void openSecondAdminInventory(Player player, String crateID, String crateName) {
        int i;
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", crateName).replace("&", "\u00a7") + " \u00a74(Admin)"));
        for (i = 0; i < 45; ++i) {
            if (CompactCrates.getInstance().getChestConfig().contains("chestContents." + crateID + "." + i)) {
                ItemStack is = CompactCrates.getInstance().getChestConfig().getItemStack("chestContents." + crateID + "." + i);
                inventory.setItem(i, is);
                continue;
            }
            CompactCrates.getInstance().getChestConfig().set("chestContents." + crateID + "." + i, (Object)new ItemStack(Material.AIR));
            CompactCrates.getInstance().saveChestsConfig();
        }
        for (i = 0; i < 9; ++i) {
            inventory.setItem(i + 45, new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setDisplayName("\u00a77").build());
        }
        inventory.setItem(49, new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7c\u00a7lBack").setLocalizedName("back").build());
        inventory.setItem(47, new ItemBuilder(Material.NAME_TAG).setDisplayName("\u00a7a\u00a7lRename Crate").setLocalizedName("Rename").build());
        inventory.setItem(45, new ItemBuilder(Material.CONDUIT).setDisplayName("\u00a7a\u00a7lChangeMaterial").setLocalizedName("ChangeType").build());
        inventory.setItem(46, new ItemBuilder(Material.CLOCK).setDisplayName("\u00a7a\u00a7lSetAnimation").setLocalizedName("SetAnimation").build());
        inventory.setItem(51, new ItemBuilder(Material.CHEST).setDisplayName("\u00a7a\u00a7lSet Slot").setLocalizedName("SetSlot").build());
        inventory.setItem(52, new ItemBuilder(Material.YELLOW_STAINED_GLASS_PANE).setDisplayName("\u00a7a\u00a7lSet Background Items").setLocalizedName("SetBackgroundItems").build());
        inventory.setItem(53, new ItemBuilder(Material.DIAMOND_SWORD).setDisplayName("\u00a7c\u00a7lDelete Crate").setLocalizedName("DeleteCrate").build());
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(CompactCrates.getInstance().getLanguageConfig().getString("firstInventoryName")) || event.getView().getTitle().equals("\u00a76CompactCrates Admin GUI")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                return;
            }
            if (event.getClick().isRightClick()) {
                this.openSecondInventory(player, event.getCurrentItem().getItemMeta().getLocalizedName(), event.getCurrentItem().getItemMeta().getDisplayName());
            } else if (event.getClick().isLeftClick()) {
                if (OpenCrate.getRunnable.containsKey(player)) {
                    player.sendMessage(CompactCrates.getPrefix() + "\u00a7cYou are already opening a crate!");
                    player.closeInventory();
                    return;
                }
                int keys = CompactCrates.getInstance().getUserConfig().getInt(player.getUniqueId().toString() + "." + event.getCurrentItem().getItemMeta().getLocalizedName() + ".Keys");
                if (keys > 0) {
                    CompactCrates.getInstance().getUserConfig().set(player.getUniqueId().toString() + "." + event.getCurrentItem().getItemMeta().getLocalizedName() + ".Keys", (Object)(keys - 1));
                    CompactCrates.getInstance().saveUserConfig();
                    player.closeInventory();
                    player.sendMessage(CompactCrates.getPrefix() + CompactCrates.getInstance().getLanguageConfig().getString("crateOpened").replace("%crate%", event.getCurrentItem().getItemMeta().getDisplayName()).replace("&", "\u00a7"));
                    OpenCrate.openCrate(player, event.getCurrentItem().getItemMeta().getLocalizedName(), event.getCurrentItem().getItemMeta().getDisplayName());
                } else {
                    player.closeInventory();
                    player.sendMessage(CompactCrates.getPrefix() + CompactCrates.getInstance().getLanguageConfig().getString("noKeys").replace("&", "\u00a7"));
                }
            } else if (event.getClick().isCreativeAction() && player.hasPermission("compactcrates.admin")) {
                this.openSecondAdminInventory(player, event.getCurrentItem().getItemMeta().getLocalizedName(), event.getCurrentItem().getItemMeta().getDisplayName());
            }
        } else if (event.getView().getTitle().startsWith(CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", "").replace("&", "\u00a7"))) {
            if (event.getView().getTitle().endsWith("\u00a74(Admin)")) {
                if (player.hasPermission("compactcrates.admin")) {
                    Inventory inventory;
                    if (event.getCurrentItem() == null) {
                        return;
                    }
                    if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                        return;
                    }
                    if (event.getSlot() >= 45 && event.getSlot() <= 53) {
                        event.setCancelled(true);
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("back")) {
                        event.setCancelled(true);
                        InventoryManager.openFirstInventory(player);
                    }
                    String crateName = event.getView().getTitle().replace(CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", "").replace("&", "\u00a7"), "").replace(" \u00a74(Admin)", "");
                    String[] crateID = new String[]{"null"};
                    CompactCrates.getInstance().getChestConfig().getConfigurationSection("cratesTypes").getKeys(false).forEach(s -> {
                        if (CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Name").equals(crateName.replace("\u00a7", "&"))) {
                            crateID[0] = CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID");
                        }
                    });
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("Rename")) {
                        event.setCancelled(true);
                        player.closeInventory();
                        player.sendMessage(CompactCrates.getPrefix() + "\u00a77Command: \u00a7a/compactcrates admin renamecrate " + crateID[0] + " <newName>");
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("ChangeType")) {
                        event.setCancelled(true);
                        player.sendMessage(CompactCrates.getPrefix() + "\u00a77Command: \u00a7a/compactcrates admin changetype " + crateID[0] + " <newType>");
                        this.openTypesInventory(player, crateID[0], 0);
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("SetSlot")) {
                        inventory = Bukkit.createInventory(null, (int)45, (String)("\u00a7a\u00a7lSet Slot \u00a77(\u00a7c" + crateName + "\u00a77)"));
                        for (int i = 0; i < 45; ++i) {
                            inventory.setItem(i, new ItemBuilder(Material.CONDUIT).setDisplayName("\u00a7eSet here \u00a77(Slot " + i + ")").setLocalizedName(crateID[0] + " " + i).build());
                        }
                        player.openInventory(inventory);
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("DeleteCrate")) {
                        inventory = Bukkit.createInventory(null, (int)27, (String)("\u00a7c\u00a7lDelete Crate \u00a77(\u00a7c" + crateName + "\u00a77)"));
                        inventory.setItem(11, new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setDisplayName("\u00a7a\u00a7lYes").setLocalizedName(crateID[0]).build());
                        inventory.setItem(15, new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setDisplayName("\u00a7c\u00a7lBack").setLocalizedName("back").build());
                        player.openInventory(inventory);
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("SetAnimation")) {
                        event.setCancelled(true);
                        inventory = Bukkit.createInventory(null, (int)9, (String)("\u00a78Set Animation \u00a77(\u00a7c" + crateName + "\u00a77)"));
                        inventory.setItem(0, new ItemBuilder(Material.SNOWBALL).setDisplayName("\u00a7aSingle").setLocalizedName(crateID[0] + " single").build());
                        inventory.setItem(1, new ItemBuilder(Material.FIREWORK_STAR).setDisplayName("\u00a7aCsgo").setLocalizedName(crateID[0] + " csgo").build());
                        inventory.setItem(2, new ItemBuilder(Material.GOLD_NUGGET).setDisplayName("\u00a7aWheel of Fortune").setLocalizedName(crateID[0] + " wheel_of_fortune").build());
                        inventory.setItem(3, new ItemBuilder(Material.SAND).setDisplayName("\u00a7aFalling").setLocalizedName(crateID[0] + " falling").build());
                        player.openInventory(inventory);
                    }
                    if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("SetBackgroundItems")) {
                        event.setCancelled(true);
                        inventory = Bukkit.createInventory(null, (int)9, (String)("\u00a78Set Background Items \u00a77(\u00a7c" + crateName + "\u00a77)"));
                        List mats = CompactCrates.getInstance().getChestConfig().getStringList("cratesTypes." + crateID[0] + ".FillWith");
                        mats.forEach(s -> inventory.addItem(new ItemStack[]{new ItemBuilder(Material.valueOf((String)s)).build()}));
                        player.openInventory(inventory);
                    }
                } else {
                    event.setCancelled(true);
                }
            } else {
                event.setCancelled(true);
                if (event.getCurrentItem() == null) {
                    return;
                }
                if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                    return;
                }
                if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("back")) {
                    InventoryManager.openFirstInventory(player);
                }
            }
        } else if (event.getView().getTitle().startsWith("\u00a77Open.. ")) {
            event.setCancelled(true);
        } else if (event.getView().getTitle().startsWith("\u00a78Set Animation \u00a77(\u00a7c")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().hasLocalizedName()) {
                String crateID = event.getCurrentItem().getItemMeta().getLocalizedName().split(" ")[0];
                String animation = event.getCurrentItem().getItemMeta().getLocalizedName().split(" ")[1];
                CompactCrates.getInstance().getChestConfig().set("cratesTypes." + crateID + ".SpinType", (Object)animation);
                CompactCrates.getInstance().saveChestsConfig();
                player.closeInventory();
                player.sendMessage(CompactCrates.getPrefix() + "\u00a77You have set the animation of the crate to \u00a7a" + animation);
            }
        } else if (event.getView().getTitle().startsWith("\u00a7a\u00a7lSet Slot \u00a77(\u00a7c")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().hasLocalizedName()) {
                String crateID = event.getCurrentItem().getItemMeta().getLocalizedName().split(" ")[0];
                int slot = Integer.parseInt(event.getCurrentItem().getItemMeta().getLocalizedName().split(" ")[1]);
                CompactCrates.getInstance().getChestConfig().set("cratesTypes." + crateID + ".Slot", (Object)slot);
                CompactCrates.getInstance().saveChestsConfig();
                InventoryManager.openFirstInventory(player);
                player.sendMessage(CompactCrates.getPrefix() + "\u00a77You have set the slot of the crate to \u00a7a" + slot);
            }
        } else if (event.getView().getTitle().startsWith("\u00a7c\u00a7lDelete Crate \u00a77(\u00a7c")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().hasLocalizedName()) {
                if (event.getCurrentItem().getItemMeta().getLocalizedName().equals("back")) {
                    InventoryManager.openFirstInventory(player);
                } else {
                    String crateID = event.getCurrentItem().getItemMeta().getLocalizedName();
                    CompactCrates.getInstance().getChestConfig().set("cratesTypes." + crateID, null);
                    CompactCrates.getInstance().saveChestsConfig();
                    InventoryManager.openFirstInventory(player);
                    player.sendMessage(CompactCrates.getPrefix() + "\u00a77You have deleted the crate \u00a7a" + crateID);
                }
            }
        } else if (event.getView().getTitle().equals("\u00a7a\u00a7lChange Crate Type")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().hasLocalizedName()) {
                String name = event.getCurrentItem().getItemMeta().getLocalizedName();
                if (name.equals("next")) {
                    this.openTypesInventory(player, event.getInventory().getItem(0).getItemMeta().getLocalizedName(), Integer.parseInt(event.getInventory().getItem(49).getItemMeta().getLocalizedName()) + 1);
                    return;
                }
                if (name.equals("previous")) {
                    this.openTypesInventory(player, event.getInventory().getItem(0).getItemMeta().getLocalizedName(), Integer.parseInt(event.getInventory().getItem(49).getItemMeta().getLocalizedName()) - 1);
                    return;
                }
                if (event.getSlot() == 49) {
                    return;
                }
                String crateID = event.getInventory().getItem(0).getItemMeta().getLocalizedName();
                CompactCrates.getInstance().getChestConfig().set("cratesTypes." + crateID + ".Type", (Object)event.getCurrentItem().getType().name());
                InventoryManager.openFirstInventory(player);
            }
        } else if (event.getView().getTitle().equals("\u00a76CompactCrates Admin GUI Preview")) {
            event.setCancelled(true);
        }
    }

    public void openTypesInventory(Player player, String crateID, Integer page) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)"\u00a7a\u00a7lChange Crate Type");
        ArrayList<Material> mats = new ArrayList<Material>(Arrays.asList(Material.values()));
        for (int i = 0; i < 45; ++i) {
            inventory.setItem(i, new ItemBuilder(mats.get(i + 1 + 45 * page)).setDisplayName("\u00a7a\u00a7l" + mats.get(i + 1 + 45 * page).name()).setLocalizedName(crateID).build());
        }
        if (page != 0) {
            inventory.setItem(45, new ItemBuilder(Material.ARROW).setDisplayName("\u00a7a\u00a7lPrevious Page").setLocalizedName("previous").build());
        }
        if (page != 25) {
            inventory.setItem(53, new ItemBuilder(Material.ARROW).setDisplayName("\u00a7a\u00a7lNext Page").setLocalizedName("next").build());
        }
        inventory.setItem(49, new ItemBuilder(Material.PAPER).setDisplayName("\u00a77\u00a7lPage " + (page + 1)).setLocalizedName("" + page).build());
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (event.getView().getTitle().startsWith(CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", "").replace("&", "\u00a7"))) {
            if (event.getView().getTitle().endsWith("\u00a74(Admin)") && player.hasPermission("compactcrates.admin")) {
                String crateName = event.getView().getTitle().replace(CompactCrates.getInstance().getLanguageConfig().getString("secondInventoryName").replace("%crate%", "").replace("&", "\u00a7"), "").replace(" \u00a74(Admin)", "");
                String[] crateID = new String[]{"null"};
                CompactCrates.getInstance().getChestConfig().getConfigurationSection("cratesTypes").getKeys(false).forEach(s -> {
                    if (CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Name").equals(crateName.replace("\u00a7", "&"))) {
                        crateID[0] = CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID");
                    }
                });
                for (int i = 0; i < 45; ++i) {
                    CompactCrates.getInstance().getChestConfig().set("chestContents." + crateID[0] + "." + i, (Object)event.getInventory().getItem(i));
                }
                CompactCrates.getInstance().saveChestsConfig();
                player.sendMessage(CompactCrates.getPrefix() + "\u00a7aSaved crate " + crateName);
            }
        } else if (event.getView().getTitle().startsWith("\u00a77Open.. ")) {
            if (OpenCrate.getRunnable.containsKey(player)) {
                ItemStack item = OpenCrate.getRandomCrateItem(OpenCrate.getCrateID.get(player));
                OpenCrate.giveItem(player, item);
            }
        } else if (event.getView().getTitle().startsWith("\u00a78Set Background Items \u00a77(\u00a7c") && player.hasPermission("compactcrates.admin")) {
            String crateName = event.getView().getTitle().replace("\u00a78Set Background Items \u00a77(\u00a7c", "").replace("\u00a77)", "");
            String[] crateID = new String[]{"null"};
            CompactCrates.getInstance().getChestConfig().getConfigurationSection("cratesTypes").getKeys(false).forEach(s -> {
                if (CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".Name").equals(crateName.replace("\u00a7", "&"))) {
                    crateID[0] = CompactCrates.getInstance().getChestConfig().getString("cratesTypes." + s + ".ID");
                }
            });
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 0; i < 9; ++i) {
                if (event.getInventory().getItem(i) == null || event.getInventory().getItem(i).getType() == Material.AIR) continue;
                items.add(event.getInventory().getItem(i).getType().name());
            }
            CompactCrates.getInstance().getChestConfig().set("cratesTypes." + crateID[0] + ".FillWith", items);
            CompactCrates.getInstance().saveChestsConfig();
            player.sendMessage(CompactCrates.getPrefix() + "\u00a7aSaved background items for crate " + crateName);
        }
    }
}

