/*
 * Decompiled with CFR 0.152.
 */
package leon_lp9.compactcrates;

import java.io.File;
import leon_lp9.compactcrates.InventoryManager;
import leon_lp9.compactcrates.Metrics;
import leon_lp9.compactcrates.UpdateChecker;
import leon_lp9.compactcrates.VoteEvent;
import leon_lp9.compactcrates.commands.MainCommand;
import leon_lp9.compactcrates.events.CratePlaceBreakEvent;
import leon_lp9.compactcrates.events.PlayerJoinEvent;
import leon_lp9.compactcrates.manager.ParticleManager;
import leon_lp9.compactcrates.manager.SpawnCratesManager;
import leon_lp9.compactcrates.placeholders.UserPlaceHolders;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CompactCrates
extends JavaPlugin {
    private static CompactCrates instance;
    File newConfig;
    FileConfiguration newConfigz;
    File languageConfig;
    FileConfiguration languageConfigz;
    File userConfig;
    FileConfiguration userConfigz;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        if (!new File(this.getDataFolder(), "language.yml").exists()) {
            CompactCrates.getInstance().saveResource("language.yml", false);
        }
        if (!new File(this.getDataFolder(), "chests.yml").exists()) {
            CompactCrates.getInstance().saveResource("chests.yml", false);
        }
        this.createNewConfig();
        this.getCommand("compactcrates").setExecutor((CommandExecutor)new MainCommand());
        this.getCommand("compactcrates").setTabCompleter((TabCompleter)new MainCommand());
        CompactCrates.getInstance().getLanguageConfig().options().copyDefaults(true);
        CompactCrates.getInstance().getChestConfig().options().copyDefaults(true);
        this.getServer().getPluginManager().registerEvents((Listener)new CratePlaceBreakEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ParticleManager(), (Plugin)this);
        int pluginId = 17254;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("Metrics enabled");
        if (Bukkit.getPluginManager().isPluginEnabled("Votifier")) {
            this.getServer().getPluginManager().registerEvents((Listener)new VoteEvent(), (Plugin)this);
            this.getLogger().info("Votifier found. VoteEvent registered.");
        } else {
            this.getLogger().info("Votifier is not installed. VoteEvent will not be registered.");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new UserPlaceHolders().register();
            this.getLogger().info("PlaceholderAPI found. Placeholders registered.");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            SpawnCratesManager.spawnCrates();
            ParticleManager.start();
        }, 20L);
        new UpdateChecker(this, 107018).getVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                this.getLogger().info("There is not a new update available.");
            } else {
                this.getLogger().info("There is a new update available.");
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (player.hasPermission("compactcrates.notify.update")) {
                        player.sendMessage(CompactCrates.getPrefix() + "There is a \u00a7enew update\u00a77 available.");
                        player.sendMessage(CompactCrates.getPrefix() + "Your are using version \u00a7e" + this.getDescription().getVersion());
                        player.sendMessage(CompactCrates.getPrefix() + "The latest version is \u00a7e" + version);
                        player.sendMessage(CompactCrates.getPrefix() + "Download it here: https://www.spigotmc.org/resources/compactcrates.107018/");
                    }
                });
            }
        });
    }

    public void onDisable() {
        SpawnCratesManager.removeCrates();
        ParticleManager.stop();
    }

    public void createNewConfig() {
        this.newConfig = new File(this.getDataFolder(), "chests.yml");
        this.newConfigz = YamlConfiguration.loadConfiguration((File)this.newConfig);
        this.languageConfig = new File(this.getDataFolder(), "language.yml");
        this.languageConfigz = YamlConfiguration.loadConfiguration((File)this.languageConfig);
        this.userConfig = new File(this.getDataFolder(), "users.yml");
        this.userConfigz = YamlConfiguration.loadConfiguration((File)this.userConfig);
        this.saveChestsConfig();
        this.saveLanguageConfig();
        this.saveUserConfig();
        this.saveConfig();
    }

    public void saveChestsConfig() {
        try {
            this.newConfigz.save(this.newConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveLanguageConfig() {
        try {
            this.languageConfigz.save(this.languageConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveUserConfig() {
        try {
            this.userConfigz.save(this.userConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getChestConfig() {
        return this.newConfigz;
    }

    public FileConfiguration getLanguageConfig() {
        return this.languageConfigz;
    }

    public FileConfiguration getUserConfig() {
        return this.userConfigz;
    }

    public static CompactCrates getInstance() {
        return instance;
    }

    public static String getPrefix() {
        return CompactCrates.getInstance().getLanguageConfig().getString("prefix").replace("&", "\u00a7");
    }
}

