/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.updater;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import me.rockyhawk.commandpanels.CommandPanels;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Updater
implements Listener {
    public String downloadVersionManually = null;
    public String catchedLatestVersion = "null";
    CommandPanels plugin;

    public Updater(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void joinGame(final PlayerJoinEvent e) {
        if (e.getPlayer().hasPermission("commandpanel.update") && this.plugin.config.getBoolean("updater.update-checks") && this.githubNewUpdate(false)) {
            new BukkitRunnable(){

                public void run() {
                    Updater.this.plugin.tex.sendMessage(e.getPlayer(), ChatColor.YELLOW + "A new update is available for download!");
                    Updater.this.plugin.tex.sendString(e.getPlayer(), ChatColor.YELLOW + "Current version " + ChatColor.RED + Updater.this.plugin.getDescription().getVersion() + ChatColor.YELLOW + " Latest version " + ChatColor.GREEN + Updater.this.catchedLatestVersion);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)this.plugin, 30L, 1L);
        }
    }

    public boolean githubNewUpdate(boolean sendMessages) {
        boolean update;
        this.getLatestVersion(sendMessages);
        if (this.plugin.getDescription().getVersion().contains("-")) {
            if (sendMessages) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.GREEN + " Running a custom version.");
            }
            return false;
        }
        boolean bl = update = !this.catchedLatestVersion.equals(this.plugin.getDescription().getVersion());
        if (update) {
            if (sendMessages) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.GOLD + " ================================================");
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.AQUA + " An update for CommandPanels is available.");
                Bukkit.getConsoleSender().sendMessage("[CommandPanels] Download CommandPanels " + ChatColor.GOLD + this.catchedLatestVersion + ChatColor.WHITE + " using the");
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.WHITE + " following command:" + ChatColor.AQUA + " /cpv latest" + ChatColor.WHITE + " and restart the server");
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.GOLD + " ================================================");
            }
            return true;
        }
        return false;
    }

    public String getLatestVersion(boolean sendMessages) {
        if (this.catchedLatestVersion.equals("null")) {
            this.catchedLatestVersion = this.plugin.getDescription().getVersion();
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL("https://raw.githubusercontent.com/rockyhawk64/CommandPanels/master/resource/plugin.yml").openConnection();
                    connection.connect();
                    Updater.this.catchedLatestVersion = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine().split("\\s")[1];
                    connection.disconnect();
                }
                catch (IOException ignore) {
                    Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " Could not access github.");
                }
            }
        }.runTask((Plugin)this.plugin);
        if (this.catchedLatestVersion.contains("-") && sendMessages) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " Cannot check for update.");
        }
        return this.catchedLatestVersion;
    }

    public void autoUpdatePlugin(String pluginFileName) {
        if (Objects.requireNonNull(this.plugin.config.getString("updater.update-checks")).equalsIgnoreCase("false")) {
            return;
        }
        String latestVersion = this.catchedLatestVersion;
        String thisVersion = this.plugin.getDescription().getVersion();
        if (this.downloadVersionManually != null) {
            if (this.downloadVersionManually.equals("latest")) {
                this.downloadFile(latestVersion, pluginFileName);
            } else {
                this.downloadFile(this.downloadVersionManually, pluginFileName);
            }
            return;
        }
        if (latestVersion.equals(thisVersion) || thisVersion.contains("-")) {
            return;
        }
        if (Objects.requireNonNull(this.plugin.config.getString("updater.auto-update")).equalsIgnoreCase("true")) {
            return;
        }
        if (Objects.equals(this.plugin.config.getString("updater.minor-updates-only"), "true")) {
            if (thisVersion.split("\\.")[1].equals(latestVersion.split("\\.")[1]) && thisVersion.split("\\.")[0].equals(latestVersion.split("\\.")[0])) {
                this.downloadFile(latestVersion, pluginFileName);
            }
        } else {
            this.downloadFile(latestVersion, pluginFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String latestVersion, String pluginFileName) {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            this.plugin.getLogger().info("Downloading new update: v" + latestVersion);
            URL fileUrl = new URL("https://github.com/rockyhawk64/CommandPanels/releases/download/" + latestVersion + "/CommandPanels.jar");
            int fileLength = fileUrl.openConnection().getContentLength();
            in = new BufferedInputStream(fileUrl.openStream());
            fout = new FileOutputStream(new File(new File(".").getAbsolutePath() + "/plugins/", pluginFileName));
            byte[] data = new byte[1024];
            long downloaded = 0L;
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                if (percent % 10 != 0) continue;
                this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
            }
            this.plugin.getLogger().info("Finished updating.");
        }
        catch (Exception var22) {
            this.plugin.getLogger().log(Level.WARNING, "Could not download update.", var22);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException var21) {
                this.plugin.getLogger().log(Level.SEVERE, null, var21);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException var20) {
                this.plugin.getLogger().log(Level.SEVERE, null, var20);
            }
        }
    }
}

