/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openpanelsmanager;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelOpenType;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class OpenGUI {
    CommandPanels plugin;

    public OpenGUI(CommandPanels pl) {
        this.plugin = pl;
    }

    public Inventory openGui(Panel panel, Player p, PanelPosition position, PanelOpenType openType, int animateValue) {
        PlayerInventory i;
        ConfigurationSection pconfig = panel.getConfig();
        if (position == PanelPosition.Top) {
            String title = openType != PanelOpenType.Editor ? this.plugin.tex.placeholders(panel, position, p, pconfig.getString("title")) : "Editing Panel: " + panel.getName();
            i = this.isNumeric(pconfig.getString("rows")) ? Bukkit.createInventory((InventoryHolder)p, (int)(pconfig.getInt("rows") * 9), (String)title) : Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.valueOf((String)pconfig.getString("rows")), (String)title);
        } else {
            i = p.getInventory();
            for (int c = 0; this.getInvSize((Inventory)i, position) > c; ++c) {
                if (pconfig.getConfigurationSection("item").getKeys(false).contains(String.valueOf(c))) continue;
                this.setItem(null, c, (Inventory)i, p, position);
            }
        }
        Set itemList = pconfig.getConfigurationSection("item").getKeys(false);
        HashSet<Integer> takenSlots = new HashSet<Integer>();
        for (String item : itemList) {
            String section = "";
            if (openType != PanelOpenType.Editor) {
                section = this.plugin.has.hasSection(panel, position, pconfig.getConfigurationSection("item." + Integer.parseInt(item)), p);
                if (pconfig.contains("item." + item + section + ".animate" + animateValue) && pconfig.contains("item." + item + section + ".animate" + animateValue)) {
                    section = section + ".animate" + animateValue;
                }
            }
            ItemStack s = this.plugin.itemCreate.makeItemFromConfig(panel, position, Objects.requireNonNull(pconfig.getConfigurationSection("item." + item + section)), p, openType != PanelOpenType.Editor, openType != PanelOpenType.Editor, openType != PanelOpenType.Editor);
            if (pconfig.contains("item." + item + section + ".itemType") && pconfig.getStringList("item." + item + section + ".itemType").contains("placeable") && openType == PanelOpenType.Refresh) {
                this.setItem(p.getOpenInventory().getItem(Integer.parseInt(item)), Integer.parseInt(item), (Inventory)i, p, position);
                takenSlots.add(Integer.parseInt(item));
                continue;
            }
            try {
                this.setItem(s, Integer.parseInt(item), (Inventory)i, p, position);
                takenSlots.add(Integer.parseInt(item));
                if (!pconfig.contains("item." + item + section + ".duplicate") || openType == PanelOpenType.Editor) continue;
                try {
                    String[] duplicateItems;
                    for (String tempDupe : duplicateItems = pconfig.getString("item." + item + section + ".duplicate").split(",")) {
                        if (tempDupe.contains("-")) {
                            int[] bothNumbers = new int[]{Integer.parseInt(tempDupe.split("-")[0]), Integer.parseInt(tempDupe.split("-")[1])};
                            for (int n = bothNumbers[0]; n <= bothNumbers[1]; ++n) {
                                try {
                                    if (pconfig.contains("item." + n)) continue;
                                    this.setItem(s, n, (Inventory)i, p, position);
                                    takenSlots.add(n);
                                    continue;
                                }
                                catch (NullPointerException ignore) {
                                    this.setItem(s, n, (Inventory)i, p, position);
                                    takenSlots.add(n);
                                }
                            }
                            continue;
                        }
                        try {
                            if (pconfig.contains("item." + Integer.parseInt(tempDupe))) continue;
                            this.setItem(s, Integer.parseInt(tempDupe), (Inventory)i, p, position);
                            takenSlots.add(Integer.parseInt(tempDupe));
                        }
                        catch (NullPointerException ignore) {
                            this.setItem(s, Integer.parseInt(tempDupe), (Inventory)i, p, position);
                            takenSlots.add(Integer.parseInt(tempDupe));
                        }
                    }
                }
                catch (NullPointerException nullp) {
                    this.plugin.debug(nullp, p);
                    p.closeInventory();
                    this.plugin.openPanels.closePanelForLoader(p.getName(), position);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        if (pconfig.contains("empty") && !Objects.equals(pconfig.getString("empty"), "AIR")) {
            try {
                ItemStack empty;
                short id = 0;
                if (pconfig.contains("emptyID")) {
                    id = Short.parseShort(pconfig.getString("emptyID"));
                }
                if (pconfig.contains("custom-item." + pconfig.getString("empty"))) {
                    empty = this.plugin.itemCreate.makeItemFromConfig(panel, position, pconfig.getConfigurationSection("custom-item." + pconfig.getString("empty")), p, true, true, true);
                } else {
                    empty = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)pconfig.getString("empty").toUpperCase())), 1, id);
                    empty = this.plugin.nbt.setNBT(empty);
                    ItemMeta renamedMeta = empty.getItemMeta();
                    assert (renamedMeta != null);
                    renamedMeta.setDisplayName(" ");
                    empty.setItemMeta(renamedMeta);
                }
                if (empty.getType() != Material.AIR) {
                    for (int c = 0; this.getInvSize((Inventory)i, position) > c; ++c) {
                        if (takenSlots.contains(c) || openType == PanelOpenType.Editor) continue;
                        this.setItem(empty, c, (Inventory)i, p, position);
                    }
                }
            }
            catch (IllegalArgumentException | NullPointerException var26) {
                this.plugin.debug(var26, p);
            }
        }
        if (openType == PanelOpenType.Normal) {
            if (this.plugin.openPanels.hasPanelOpen(p.getName(), position)) {
                this.plugin.openPanels.getOpenPanel((String)p.getName(), (PanelPosition)position).isOpen = false;
            }
            this.plugin.openPanels.skipPanelClose.add(p.getName());
            this.plugin.openPanels.openPanelForLoader(p.getName(), panel, position);
            if (position == PanelPosition.Top) {
                p.openInventory((Inventory)i);
            }
            this.plugin.openPanels.skipPanelClose.remove(p.getName());
        } else if (openType == PanelOpenType.Editor) {
            p.openInventory((Inventory)i);
        } else if (openType == PanelOpenType.Refresh) {
            if (position == PanelPosition.Top) {
                this.plugin.legacy.setStorageContents(p, this.plugin.legacy.getStorageContents((Inventory)i));
            }
        } else if (openType == PanelOpenType.Return) {
            return i;
        }
        return i;
    }

    private int getInvSize(Inventory inv, PanelPosition position) {
        if (position == PanelPosition.Top) {
            return inv.getSize();
        }
        if (position == PanelPosition.Middle) {
            return 27;
        }
        return 9;
    }

    private void setItem(ItemStack item, int slot, Inventory inv, Player p, PanelPosition position) throws ArrayIndexOutOfBoundsException {
        if (position == PanelPosition.Top) {
            inv.setItem(slot, item);
        } else if (position == PanelPosition.Middle) {
            if (slot + 9 < 36) {
                p.getInventory().setItem(slot + 9, item);
            }
        } else if (slot < 9) {
            p.getInventory().setItem(slot, item);
        }
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

