/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.ioclasses.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NBT_1_13 {
    private final Map<String, Class<?>> classCache;
    private final Map<String, Method> methodCache;
    private final Map<Class<?>, Constructor<?>> constructorCache;
    private final Map<Class<?>, Class<?>> NBTClasses;
    private final Map<Class<?>, Field> NBTTagFieldCache;
    private Field NBTListData;
    private Field NBTCompoundMap;
    private final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    private final MinecraftVersion LOCAL_VERSION = MinecraftVersion.get(this.VERSION);

    public NBT_1_13() {
        this.classCache = new HashMap();
        try {
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                this.classCache.put("NBTBase", Class.forName("net.minecraft.server." + this.VERSION + ".NBTBase"));
                this.classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagCompound"));
                this.classCache.put("NBTTagList", Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagList"));
                this.classCache.put("MojangsonParser", Class.forName("net.minecraft.server." + this.VERSION + ".MojangsonParser"));
                this.classCache.put("ItemStack", Class.forName("net.minecraft.server." + this.VERSION + ".ItemStack"));
                this.classCache.put("Entity", Class.forName("net.minecraft.server." + this.VERSION + ".Entity"));
                this.classCache.put("EntityLiving", Class.forName("net.minecraft.server." + this.VERSION + ".EntityLiving"));
                this.classCache.put("BlockPosition", Class.forName("net.minecraft.server." + this.VERSION + ".BlockPosition"));
                this.classCache.put("TileEntity", Class.forName("net.minecraft.server." + this.VERSION + ".TileEntity"));
                this.classCache.put("World", Class.forName("net.minecraft.server." + this.VERSION + ".World"));
                this.classCache.put("IBlockData", Class.forName("net.minecraft.server." + this.VERSION + ".IBlockData"));
                this.classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + this.VERSION + ".TileEntitySkull"));
            } else {
                this.classCache.put("BlockPosition", Class.forName("net.minecraft.core.BlockPosition"));
                this.classCache.put("NBTBase", Class.forName("net.minecraft.nbt.NBTBase"));
                this.classCache.put("NBTTagCompound", Class.forName("net.minecraft.nbt.NBTTagCompound"));
                this.classCache.put("NBTTagList", Class.forName("net.minecraft.nbt.NBTTagList"));
                this.classCache.put("MojangsonParser", Class.forName("net.minecraft.nbt.MojangsonParser"));
                this.classCache.put("ItemStack", Class.forName("net.minecraft.world.item.ItemStack"));
                this.classCache.put("Entity", Class.forName("net.minecraft.world.entity.Entity"));
                this.classCache.put("EntityLiving", Class.forName("net.minecraft.world.entity.EntityLiving"));
                this.classCache.put("World", Class.forName("net.minecraft.world.level.World"));
                this.classCache.put("IBlockData", Class.forName("net.minecraft.world.level.block.state.IBlockData"));
                this.classCache.put("TileEntity", Class.forName("net.minecraft.world.level.block.entity.TileEntity"));
                this.classCache.put("TileEntitySkull", Class.forName("net.minecraft.world.level.block.entity.TileEntitySkull"));
            }
            this.classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + this.VERSION + ".inventory.CraftItemStack"));
            this.classCache.put("CraftMetaSkull", Class.forName("org.bukkit.craftbukkit." + this.VERSION + ".inventory.CraftMetaSkull"));
            this.classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + this.VERSION + ".entity.CraftEntity"));
            this.classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + this.VERSION + ".CraftWorld"));
            this.classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + this.VERSION + ".block.CraftBlockState"));
            this.classCache.put("GameProfile", Class.forName("com.mojang.authlib.GameProfile"));
            this.classCache.put("Property", Class.forName("com.mojang.authlib.properties.Property"));
            this.classCache.put("PropertyMap", Class.forName("com.mojang.authlib.properties.PropertyMap"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.NBTClasses = new HashMap();
        try {
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                this.NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagByte"));
                this.NBTClasses.put(Boolean.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagByte"));
                this.NBTClasses.put(String.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagString"));
                this.NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagDouble"));
                this.NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagInt"));
                this.NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagLong"));
                this.NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagShort"));
                this.NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagFloat"));
                this.NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagByteArray"));
                this.NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + this.VERSION + ".NBTTagIntArray"));
            } else {
                this.NBTClasses.put(Byte.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                this.NBTClasses.put(Boolean.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                this.NBTClasses.put(String.class, Class.forName("net.minecraft.nbt.NBTTagString"));
                this.NBTClasses.put(Double.class, Class.forName("net.minecraft.nbt.NBTTagDouble"));
                this.NBTClasses.put(Integer.class, Class.forName("net.minecraft.nbt.NBTTagInt"));
                this.NBTClasses.put(Long.class, Class.forName("net.minecraft.nbt.NBTTagLong"));
                this.NBTClasses.put(Short.class, Class.forName("net.minecraft.nbt.NBTTagShort"));
                this.NBTClasses.put(Float.class, Class.forName("net.minecraft.nbt.NBTTagFloat"));
                this.NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.nbt.NBTTagByteArray"));
                this.NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.nbt.NBTTagIntArray"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.methodCache = new HashMap<String, Method>();
        try {
            this.methodCache.put("get", this.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            this.methodCache.put("set", this.getNMSClass("NBTTagCompound").getMethod("set", String.class, this.getNMSClass("NBTBase")));
            this.methodCache.put("hasKey", this.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                this.methodCache.put("setIndex", this.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, this.getNMSClass("NBTBase")));
            } else {
                this.methodCache.put("setIndex", this.getNMSClass("NBTTagList").getMethod("set", Integer.TYPE, this.getNMSClass("NBTBase")));
            }
            if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                this.methodCache.put("getTypeId", this.getNMSClass("NBTBase").getMethod("getTypeId", new Class[0]));
                this.methodCache.put("add", this.getNMSClass("NBTTagList").getMethod("add", Integer.TYPE, this.getNMSClass("NBTBase")));
            } else {
                this.methodCache.put("add", this.getNMSClass("NBTTagList").getMethod("add", this.getNMSClass("NBTBase")));
            }
            this.methodCache.put("size", this.getNMSClass("NBTTagList").getMethod("size", new Class[0]));
            if (this.LOCAL_VERSION == MinecraftVersion.v1_8) {
                this.methodCache.put("listRemove", this.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE));
            } else {
                this.methodCache.put("listRemove", this.getNMSClass("NBTTagList").getMethod("remove", Integer.TYPE));
            }
            this.methodCache.put("remove", this.getNMSClass("NBTTagCompound").getMethod("remove", String.class));
            if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                this.methodCache.put("getKeys", this.getNMSClass("NBTTagCompound").getMethod("getKeys", new Class[0]));
            } else {
                this.methodCache.put("getKeys", this.getNMSClass("NBTTagCompound").getMethod("c", new Class[0]));
            }
            this.methodCache.put("hasTag", this.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            this.methodCache.put("getTag", this.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            this.methodCache.put("setTag", this.getNMSClass("ItemStack").getMethod("setTag", this.getNMSClass("NBTTagCompound")));
            this.methodCache.put("asNMSCopy", this.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            this.methodCache.put("asBukkitCopy", this.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", this.getNMSClass("ItemStack")));
            this.methodCache.put("getEntityHandle", this.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                this.methodCache.put("getEntityTag", this.getNMSClass("Entity").getMethod("save", this.getNMSClass("NBTTagCompound")));
                this.methodCache.put("setEntityTag", this.getNMSClass("Entity").getMethod("load", this.getNMSClass("NBTTagCompound")));
            } else {
                this.methodCache.put("getEntityTag", this.getNMSClass("Entity").getMethod("c", this.getNMSClass("NBTTagCompound")));
                this.methodCache.put("setEntityTag", this.getNMSClass("Entity").getMethod("f", this.getNMSClass("NBTTagCompound")));
            }
            this.methodCache.put("save", this.getNMSClass("ItemStack").getMethod("save", this.getNMSClass("NBTTagCompound")));
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_10)) {
                this.methodCache.put("createStack", this.getNMSClass("ItemStack").getMethod("createStack", this.getNMSClass("NBTTagCompound")));
            } else if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                this.methodCache.put("createStack", this.getNMSClass("ItemStack").getMethod("a", this.getNMSClass("NBTTagCompound")));
            }
            if (this.LOCAL_VERSION == MinecraftVersion.v1_16) {
                this.methodCache.put("setTileTag", this.getNMSClass("TileEntity").getMethod("load", this.getNMSClass("IBlockData"), this.getNMSClass("NBTTagCompound")));
                this.methodCache.put("getType", this.getNMSClass("World").getMethod("getType", this.getNMSClass("BlockPosition")));
            } else if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_12)) {
                this.methodCache.put("setTileTag", this.getNMSClass("TileEntity").getMethod("load", this.getNMSClass("NBTTagCompound")));
            } else {
                this.methodCache.put("setTileTag", this.getNMSClass("TileEntity").getMethod("a", this.getNMSClass("NBTTagCompound")));
            }
            if (this.LOCAL_VERSION == MinecraftVersion.v1_8) {
                this.methodCache.put("getTileTag", this.getNMSClass("TileEntity").getMethod("b", this.getNMSClass("NBTTagCompound")));
            } else {
                this.methodCache.put("getTileTag", this.getNMSClass("TileEntity").getMethod("save", this.getNMSClass("NBTTagCompound")));
            }
            this.methodCache.put("getTileEntity", this.getNMSClass("World").getMethod("getTileEntity", this.getNMSClass("BlockPosition")));
            this.methodCache.put("getWorldHandle", this.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            this.methodCache.put("setGameProfile", this.getNMSClass("TileEntitySkull").getMethod("setGameProfile", this.getNMSClass("GameProfile")));
            this.methodCache.put("getProperties", this.getNMSClass("GameProfile").getMethod("getProperties", new Class[0]));
            this.methodCache.put("getName", this.getNMSClass("Property").getMethod("getName", new Class[0]));
            this.methodCache.put("getValue", this.getNMSClass("Property").getMethod("getValue", new Class[0]));
            this.methodCache.put("values", this.getNMSClass("PropertyMap").getMethod("values", new Class[0]));
            this.methodCache.put("put", this.getNMSClass("PropertyMap").getMethod("put", Object.class, Object.class));
            this.methodCache.put("loadNBTTagCompound", this.getNMSClass("MojangsonParser").getMethod("parse", String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.methodCache.put("setProfile", this.getNMSClass("CraftMetaSkull").getDeclaredMethod("setProfile", this.getNMSClass("GameProfile")));
            this.methodCache.get("setProfile").setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.constructorCache = new HashMap();
        try {
            this.constructorCache.put(this.getNBTTag(Byte.class), this.getNBTTag(Byte.class).getDeclaredConstructor(Byte.TYPE));
            this.constructorCache.put(this.getNBTTag(Boolean.class), this.getNBTTag(Boolean.class).getDeclaredConstructor(Byte.TYPE));
            this.constructorCache.put(this.getNBTTag(String.class), this.getNBTTag(String.class).getDeclaredConstructor(String.class));
            this.constructorCache.put(this.getNBTTag(Double.class), this.getNBTTag(Double.class).getDeclaredConstructor(Double.TYPE));
            this.constructorCache.put(this.getNBTTag(Integer.class), this.getNBTTag(Integer.class).getDeclaredConstructor(Integer.TYPE));
            this.constructorCache.put(this.getNBTTag(Long.class), this.getNBTTag(Long.class).getDeclaredConstructor(Long.TYPE));
            this.constructorCache.put(this.getNBTTag(Float.class), this.getNBTTag(Float.class).getDeclaredConstructor(Float.TYPE));
            this.constructorCache.put(this.getNBTTag(Short.class), this.getNBTTag(Short.class).getDeclaredConstructor(Short.TYPE));
            this.constructorCache.put(this.getNBTTag(Class.forName("[B")), this.getNBTTag(Class.forName("[B")).getDeclaredConstructor(Class.forName("[B")));
            this.constructorCache.put(this.getNBTTag(Class.forName("[I")), this.getNBTTag(Class.forName("[I")).getDeclaredConstructor(Class.forName("[I")));
            for (Constructor constructor : this.constructorCache.values()) {
                constructor.setAccessible(true);
            }
            this.constructorCache.put(this.getNMSClass("BlockPosition"), this.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
            this.constructorCache.put(this.getNMSClass("GameProfile"), this.getNMSClass("GameProfile").getConstructor(UUID.class, String.class));
            this.constructorCache.put(this.getNMSClass("Property"), this.getNMSClass("Property").getConstructor(String.class, String.class));
            if (this.LOCAL_VERSION == MinecraftVersion.v1_11 || this.LOCAL_VERSION == MinecraftVersion.v1_12) {
                this.constructorCache.put(this.getNMSClass("ItemStack"), this.getNMSClass("ItemStack").getConstructor(this.getNMSClass("NBTTagCompound")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.NBTTagFieldCache = new HashMap();
        try {
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                for (Class<?> clazz : this.NBTClasses.values()) {
                    Field data = clazz.getDeclaredField("data");
                    data.setAccessible(true);
                    this.NBTTagFieldCache.put(clazz, data);
                }
            } else {
                this.NBTTagFieldCache.put(this.NBTClasses.get(Byte.class), this.NBTClasses.get(Byte.class).getDeclaredField("x"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Boolean.class), this.NBTClasses.get(Boolean.class).getDeclaredField("x"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(String.class), this.NBTClasses.get(String.class).getDeclaredField("A"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Double.class), this.NBTClasses.get(Double.class).getDeclaredField("w"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Integer.class), this.NBTClasses.get(Integer.class).getDeclaredField("c"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Long.class), this.NBTClasses.get(Long.class).getDeclaredField("c"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Float.class), this.NBTClasses.get(Float.class).getDeclaredField("w"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Short.class), this.NBTClasses.get(Short.class).getDeclaredField("c"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Class.forName("[B")), this.NBTClasses.get(Class.forName("[B")).getDeclaredField("c"));
                this.NBTTagFieldCache.put(this.NBTClasses.get(Class.forName("[I")), this.NBTClasses.get(Class.forName("[I")).getDeclaredField("c"));
                for (Field field : this.NBTTagFieldCache.values()) {
                    field.setAccessible(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                this.NBTListData = this.getNMSClass("NBTTagList").getDeclaredField("list");
                this.NBTCompoundMap = this.getNMSClass("NBTTagCompound").getDeclaredField("map");
            } else {
                this.NBTListData = this.getNMSClass("NBTTagList").getDeclaredField("c");
                this.NBTCompoundMap = this.getNMSClass("NBTTagCompound").getDeclaredField("x");
            }
            this.NBTListData.setAccessible(true);
            this.NBTCompoundMap.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Class<?> getNBTTag(Class<?> primitiveType) {
        if (this.NBTClasses.containsKey(primitiveType)) {
            return this.NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    private Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (this.NBTTagFieldCache.containsKey(clazz)) {
                return this.NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Method getMethod(String name) {
        return this.methodCache.containsKey(name) ? this.methodCache.get(name) : null;
    }

    private Constructor<?> getConstructor(Class<?> clazz) {
        return this.constructorCache.containsKey(clazz) ? this.constructorCache.get(clazz) : null;
    }

    private Class<?> getNMSClass(String name) {
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        try {
            return Class.forName("net.minecraft.server." + this.VERSION + "." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Object createItemStack(Object compound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        if (this.LOCAL_VERSION == MinecraftVersion.v1_11 || this.LOCAL_VERSION == MinecraftVersion.v1_12) {
            return this.getConstructor(this.getNMSClass("ItemStack")).newInstance(compound);
        }
        return this.getMethod("createStack").invoke(null, compound);
    }

    public String getVersion() {
        return this.VERSION;
    }

    public MinecraftVersion getMinecraftVersion() {
        return this.LOCAL_VERSION;
    }

    public ItemStack getHead(String skinURL) {
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack head = new ItemStack(material, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        Object profile = null;
        try {
            profile = this.getConstructor(this.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = this.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = this.getConstructor(this.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes())));
            this.getMethod("put").invoke(propertyMap, "textures", textureProperty);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException propertyMap) {
            // empty catch block
        }
        if (this.methodCache.containsKey("setProfile")) {
            try {
                this.getMethod("setProfile").invoke((Object)headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException propertyMap) {}
        } else {
            Field profileField = null;
            try {
                profileField = headMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
            profileField.setAccessible(true);
            try {
                profileField.set(headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public String getTexture(ItemStack head) {
        ItemMeta meta = head.getItemMeta();
        Field profileField = null;
        try {
            profileField = meta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("Item is not a player skull!");
        }
        profileField.setAccessible(true);
        try {
            Object profile = profileField.get(meta);
            if (profile == null) {
                return null;
            }
            Collection properties = (Collection)this.getMethod("values").invoke(this.getMethod("getProperties").invoke(profile, new Object[0]), new Object[0]);
            for (Object prop : properties) {
                if (!"textures".equals(this.getMethod("getName").invoke(prop, new Object[0]))) continue;
                String texture = new String(Base64.getDecoder().decode((String)this.getMethod("getValue").invoke(prop, new Object[0])));
                return this.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getItemTag(ItemStack item, Object ... keys) {
        try {
            return this.getTag(this.getCompound(item), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getCompound(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = this.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = this.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? this.getMethod("getTag").invoke(stack, new Object[0]) : (Object)this.getNMSClass("NBTTagCompound").newInstance();
            return tag;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private NBTCompound getItemNBTTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = this.getMethod("asNMSCopy").invoke(null, item);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            tag = this.getMethod("save").invoke(stack, tag);
            return this.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = this.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = this.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? this.getMethod("getTag").invoke(stack, new Object[0]) : (Object)this.getNMSClass("NBTTagCompound").newInstance();
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                this.setTag(tag, value, keys);
            }
            this.getMethod("setTag").invoke(stack, tag);
            return (ItemStack)this.getMethod("asBukkitCopy").invoke(null, stack);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ItemStack getItemFromTag(NBTCompound compound) {
        if (compound == null) {
            return null;
        }
        try {
            Object tag = compound.tag;
            Object count = this.getTag(tag, "Count");
            Object id = this.getTag(tag, "id");
            if (count == null || id == null) {
                return null;
            }
            if (count instanceof Byte && id instanceof String) {
                return (ItemStack)this.getMethod("asBukkitCopy").invoke(null, this.createItemStack(tag));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object getEntityTag(Entity entity, Object ... keys) {
        try {
            return this.getTag(this.getCompound(entity), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getCompound(Entity entity) {
        if (entity == null) {
            return entity;
        }
        try {
            Object NMSEntity = this.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private NBTCompound getEntityNBTTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return null;
        }
        try {
            Object NMSEntity = this.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return this.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setEntityTag(Entity entity, Object value, Object ... keys) {
        if (entity == null) {
            return;
        }
        try {
            Object NMSEntity = this.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getEntityTag").invoke(NMSEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                this.setTag(tag, value, keys);
            }
            this.getMethod("setEntityTag").invoke(NMSEntity, tag);
        }
        catch (Exception exception) {
            return;
        }
    }

    private Object getBlockTag(Block block, Object ... keys) {
        try {
            return this.getTag(this.getCompound(block), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getCompound(Block block) {
        try {
            if (block == null || !this.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = this.getConstructor(this.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = this.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = this.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getTileTag").invoke(tileEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private NBTCompound getBlockNBTTag(Block block, Object ... keys) {
        try {
            if (block == null || !this.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = this.getConstructor(this.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = this.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = this.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getTileTag").invoke(tileEntity, tag);
            return this.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            if (block == null || !this.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object blockPosition = this.getConstructor(this.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = this.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = this.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = this.getNMSClass("NBTTagCompound").newInstance();
            this.getMethod("getTileTag").invoke(tileEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                this.setTag(tag, value, keys);
            }
            if (this.LOCAL_VERSION == MinecraftVersion.v1_16) {
                this.getMethod("setTileTag").invoke(tileEntity, this.getMethod("getType").invoke(nmsWorld, blockPosition), tag);
            } else {
                this.getMethod("setTileTag").invoke(tileEntity, tag);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setSkullTexture(Block block, String texture) {
        try {
            Object profile = this.getConstructor(this.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = this.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = this.getConstructor(this.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes())));
            this.getMethod("put").invoke(propertyMap, "textures", textureProperty);
            Location location = block.getLocation();
            Object blockPosition = this.getConstructor(this.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = this.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = this.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            this.getMethod("setGameProfile").invoke(tileEntity, profile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getValue(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return this.getItemTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return this.getEntityTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return this.getBlockTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return this.getTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public NBTCompound getNBTCompound(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return this.getItemNBTTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return this.getEntityNBTTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return this.getBlockNBTTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return this.getNBTTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        if (this.getNMSClass("NBTTagCompound").isInstance(object)) {
            try {
                return this.getNBTTag(object, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public String getString(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof String ? (String)result : null;
    }

    public int getInt(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Integer ? (Integer)result : 0;
    }

    public double getDouble(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Double ? (Double)result : 0.0;
    }

    public long getLong(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Long ? (Long)result : 0L;
    }

    public float getFloat(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Float ? ((Float)result).floatValue() : 0.0f;
    }

    public short getShort(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Short ? (Short)result : (short)0;
    }

    public byte getByte(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof Byte ? (Byte)result : (byte)0;
    }

    public boolean getBoolean(Object object, Object ... keys) {
        return this.getByte(object, keys) == 1;
    }

    public byte[] getByteArray(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof byte[] ? (byte[])result : null;
    }

    public int[] getIntArray(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result instanceof int[] ? (int[])result : null;
    }

    public boolean contains(Object object, Object ... keys) {
        Object result = this.getValue(object, keys);
        return result != null;
    }

    public Collection<String> getKeys(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = this.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = this.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = this.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = this.getNBTTag(compound, keys);
            Object tag = nbtCompound.tag;
            if (this.getNMSClass("NBTTagCompound").isInstance(tag)) {
                return (Collection)this.getMethod("getKeys").invoke(tag, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public int getSize(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = this.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = this.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = this.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = this.getNBTTag(compound, keys);
            if (this.getNMSClass("NBTTagCompound").isInstance(nbtCompound.tag)) {
                return this.getKeys(nbtCompound, new Object[0]).size();
            }
            if (this.getNMSClass("NBTTagList").isInstance(nbtCompound.tag)) {
                return (Integer)this.getMethod("size").invoke(nbtCompound.tag, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return 0;
        }
        throw new IllegalArgumentException("Value is not a compound or list!");
    }

    public <T> T set(T object, Object value, Object ... keys) {
        if (object instanceof ItemStack) {
            return (T)this.setItemTag((ItemStack)object, value, keys);
        }
        if (object instanceof Entity) {
            this.setEntityTag((Entity)object, value, keys);
        } else if (object instanceof Block) {
            this.setBlockTag((Block)object, value, keys);
        } else if (object instanceof NBTCompound) {
            try {
                this.setTag(((NBTCompound)object).tag, value, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {}
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        return object;
    }

    public NBTCompound getNBTCompound(String json) {
        return NBTCompound.fromJson(json);
    }

    public NBTCompound getEmptyNBTCompound() {
        try {
            return new NBTCompound(this.getNMSClass("NBTTagCompound").newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private void setTag(Object tag, Object value, Object ... keys) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object notCompound;
        if (value != null) {
            if (value instanceof NBTCompound) {
                notCompound = ((NBTCompound)value).tag;
            } else if (this.getNMSClass("NBTTagList").isInstance(value) || this.getNMSClass("NBTTagCompound").isInstance(value)) {
                notCompound = value;
            } else {
                if (value instanceof Boolean) {
                    value = (byte)((Boolean)value == true ? 1 : 0);
                }
                notCompound = this.getConstructor(this.getNBTTag(value.getClass())).newInstance(value);
            }
        } else {
            notCompound = null;
        }
        Object compound = tag;
        for (int index = 0; index < keys.length - 1; ++index) {
            Object object = keys[index];
            Object oldCompound = compound;
            if (object instanceof Integer) {
                compound = ((List)this.NBTListData.get(compound)).get((Integer)object);
            } else if (object != null) {
                compound = this.getMethod("get").invoke(compound, (String)object);
            }
            if (compound != null && object != null) continue;
            compound = keys[index + 1] == null || keys[index + 1] instanceof Integer ? this.getNMSClass("NBTTagList").newInstance() : this.getNMSClass("NBTTagCompound").newInstance();
            if (oldCompound.getClass().getSimpleName().equals("NBTTagList")) {
                if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    this.getMethod("add").invoke(oldCompound, this.getMethod("size").invoke(oldCompound, new Object[0]), compound);
                    continue;
                }
                this.getMethod("add").invoke(oldCompound, compound);
                continue;
            }
            this.getMethod("set").invoke(oldCompound, (String)object, compound);
        }
        if (keys.length > 0) {
            Object lastKey = keys[keys.length - 1];
            if (lastKey == null) {
                if (this.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    this.getMethod("add").invoke(compound, this.getMethod("size").invoke(compound, new Object[0]), notCompound);
                } else {
                    this.getMethod("add").invoke(compound, notCompound);
                }
            } else if (lastKey instanceof Integer) {
                if (notCompound == null) {
                    this.getMethod("listRemove").invoke(compound, (int)((Integer)lastKey));
                } else {
                    this.getMethod("setIndex").invoke(compound, (int)((Integer)lastKey), notCompound);
                }
            } else if (notCompound == null) {
                this.getMethod("remove").invoke(compound, (String)lastKey);
            } else {
                this.getMethod("set").invoke(compound, (String)lastKey, notCompound);
            }
        } else if (notCompound != null && this.getNMSClass("NBTTagCompound").isInstance(notCompound) && this.getNMSClass("NBTTagCompound").isInstance(compound)) {
            for (String string : this.getKeys(notCompound, new Object[0])) {
                this.getMethod("set").invoke(compound, string, this.getMethod("get").invoke(notCompound, string));
            }
        }
    }

    private NBTCompound getNBTTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object compound = tag;
        for (Object key : keys) {
            if (compound == null) {
                return null;
            }
            if (this.getNMSClass("NBTTagCompound").isInstance(compound)) {
                compound = this.getMethod("get").invoke(compound, (String)key);
                continue;
            }
            if (!this.getNMSClass("NBTTagList").isInstance(compound)) continue;
            compound = ((List)this.NBTListData.get(compound)).get((Integer)key);
        }
        return new NBTCompound(compound);
    }

    private Object getTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (keys.length == 0) {
            return this.getTags(tag);
        }
        Object notCompound = tag;
        for (Object key : keys) {
            if (notCompound == null) {
                return null;
            }
            if (this.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
                notCompound = this.getMethod("get").invoke(notCompound, (String)key);
                continue;
            }
            if (this.getNMSClass("NBTTagList").isInstance(notCompound)) {
                notCompound = ((List)this.NBTListData.get(notCompound)).get((Integer)key);
                continue;
            }
            return this.getNBTVar(notCompound);
        }
        if (notCompound == null) {
            return null;
        }
        if (this.getNMSClass("NBTTagList").isInstance(notCompound)) {
            return this.getTags(notCompound);
        }
        if (this.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
            return this.getTags(notCompound);
        }
        return this.getNBTVar(notCompound);
    }

    private Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (this.getNMSClass("NBTTagCompound").isInstance(tag)) {
                Map tagCompound = (Map)this.NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (this.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(key, this.getTag(value, new Object[0]));
                }
            } else if (this.getNMSClass("NBTTagList").isInstance(tag)) {
                List tagList = (List)this.NBTListData.get(tag);
                for (int index = 0; index < tagList.size(); ++index) {
                    Object value = tagList.get(index);
                    if (this.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(index, this.getTag(value, new Object[0]));
                }
            } else {
                return this.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            return tags;
        }
    }

    public static enum MinecraftVersion {
        v1_8("1_8", 0),
        v1_9("1_9", 1),
        v1_10("1_10", 2),
        v1_11("1_11", 3),
        v1_12("1_12", 4),
        v1_13("1_13", 5),
        v1_14("1_14", 6),
        v1_15("1_15", 7),
        v1_16("1_16", 8),
        v1_17("1_17", 9),
        v1_18("1_18", 10),
        v1_19("1_19", 11);

        private int order;
        private String key;

        private MinecraftVersion(String key, int v) {
            this.key = key;
            this.order = v;
        }

        public boolean greaterThanOrEqualTo(MinecraftVersion other) {
            return this.order >= other.order;
        }

        public boolean lessThanOrEqualTo(MinecraftVersion other) {
            return this.order <= other.order;
        }

        public static MinecraftVersion get(String v) {
            for (MinecraftVersion k : MinecraftVersion.values()) {
                if (!v.contains(k.key)) continue;
                return k;
            }
            return null;
        }
    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(Object tag) {
            this.tag = tag;
        }

        public void set(Object value, Object ... keys) {
            try {
                new NBT_1_13().setTag(this.tag, value, keys);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toJson() {
            return this.tag.toString();
        }

        public static NBTCompound fromJson(String json) {
            try {
                return new NBTCompound(new NBT_1_13().getMethod("loadNBTTagCompound").invoke(null, json));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }

        public String toString() {
            return this.tag.toString();
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NBTCompound other = (NBTCompound)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

