/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.ioclasses.nbt;

import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import me.rockyhawk.commandpanels.ioclasses.nbt.NBT_1_13;
import me.rockyhawk.commandpanels.ioclasses.nbt.NBT_1_14;
import org.bukkit.inventory.ItemStack;

public class NBTManager {
    CommandPanels plugin;

    public NBTManager(CommandPanels pl) {
        this.plugin = pl;
    }

    public boolean hasNBT(ItemStack item) {
        if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_13)) {
            return new NBT_1_13().contains(item, "CommandPanelsItem");
        }
        return new NBT_1_14(this.plugin).hasNBT(item, "CommandPanelsItem");
    }

    public ItemStack setNBT(ItemStack item) {
        if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_13)) {
            return new NBT_1_13().set(item, 1, "CommandPanelsItem");
        }
        return new NBT_1_14(this.plugin).addNBT(item, "CommandPanelsItem", "1");
    }

    public String getNBT(ItemStack item, String key) {
        String output = "";
        if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_13)) {
            try {
                output = new NBT_1_13().getString(item, key);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            output = new NBT_1_14(this.plugin).getNBT(item, key);
        }
        return output;
    }

    public ItemStack setNBT(ItemStack item, String key, String value) {
        if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_13)) {
            return new NBT_1_13().set(item, value, key);
        }
        return new NBT_1_14(this.plugin).addNBT(item, key, value);
    }
}

