/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelCommandEvent;
import me.rockyhawk.commandpanels.editor.EditorSettings;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CPEventHandler
implements Listener {
    CommandPanels plugin;

    public CPEventHandler(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onCommandEventOpen(PanelCommandEvent e) {
        if (!e.getMessage().startsWith("CommandPanels_")) {
            return;
        }
        if (e.getMessage().equals("CommandPanels_OpenPanelSettings")) {
            this.plugin.editorMain.openGuiPage("PanelEditMenu", e.getPlayer(), PanelPosition.Middle);
            this.plugin.editorMain.settings.get(e.getPlayer().getUniqueId()).setMenuOpen("PanelEditMenu");
            return;
        }
        if (e.getMessage().equals("CommandPanels_OpenItemSettings")) {
            this.plugin.editorMain.openGuiPage("ItemEditMenu", e.getPlayer(), PanelPosition.Middle);
            this.plugin.editorMain.settings.get(e.getPlayer().getUniqueId()).setMenuOpen("ItemEditMenu");
            return;
        }
        if (e.getMessage().equals("CommandPanels_EditorOpened")) {
            this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).hasEditorOpen = true;
            return;
        }
        if (e.getMessage().equals("CommandPanels_EditorClosed")) {
            this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).hasEditorOpen = false;
        }
    }

    void savePanelFile(Panel p) {
        try {
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)p.getFile());
            newConfig.set("panels." + p.getName(), (Object)p.getConfig());
            newConfig.save(p.getFile());
        }
        catch (Exception io) {
            this.plugin.debug(io, null);
        }
    }

    @EventHandler
    public void onCommandEventView(PanelCommandEvent e) {
        String input;
        if (!e.getMessage().startsWith("CPEditorItem_") && !e.getMessage().startsWith("CPEditorPanel_")) {
            return;
        }
        EditorSettings editor = this.plugin.editorMain.settings.get(e.getPlayer().getUniqueId());
        Panel panel = null;
        for (Panel pnl : this.plugin.panelList) {
            if (!pnl.getName().equals(this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).panelName)) continue;
            panel = pnl.copy();
            break;
        }
        assert (panel != null);
        if (e.getMessage().startsWith("CPEditorItem_")) {
            input = e.getMessage().replace("CPEditorItem_", "");
            this.viewContents(e.getPlayer(), panel, "item." + editor.slotSelected + "." + input);
        }
        if (e.getMessage().startsWith("CPEditorPanel_")) {
            input = e.getMessage().replace("CPEditorPanel_", "");
            this.viewContents(e.getPlayer(), panel, input);
        }
    }

    @EventHandler
    public void onCommandEventSettings(PanelCommandEvent e) {
        if (!e.getMessage().startsWith("CPEditor_")) {
            return;
        }
        String editType = e.getMessage().split("\\s")[0].replace("CPEditor_", "");
        String playerInput = e.getMessage().replace("CPEditor_" + editType + " ", "");
        EditorSettings editor = this.plugin.editorMain.settings.get(e.getPlayer().getUniqueId());
        Panel panel = null;
        for (Panel pnl : this.plugin.panelList) {
            if (!pnl.getName().equals(this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).panelName)) continue;
            panel = pnl.copy();
            break;
        }
        assert (panel != null);
        if (editType.startsWith("item")) {
            switch (editType) {
                case "itemslot": {
                    this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).slotSelected = playerInput;
                    break;
                }
                case "itemmaterial": {
                    panel.getConfig().set("item." + editor.slotSelected + ".material", (Object)playerInput);
                    break;
                }
                case "itemname": {
                    panel.getConfig().set("item." + editor.slotSelected + ".name", (Object)playerInput);
                    break;
                }
                case "itemstack": {
                    panel.getConfig().set("item." + editor.slotSelected + ".stack", (Object)playerInput);
                    break;
                }
                case "itemdelete": {
                    if (!playerInput.toLowerCase().startsWith("c")) break;
                    panel.getConfig().set("item." + editor.slotSelected, null);
                    break;
                }
                case "itemmove": {
                    ConfigurationSection oldLocation = panel.getConfig().getConfigurationSection("item." + editor.slotSelected);
                    if (panel.getConfig().isSet("item." + playerInput)) {
                        ConfigurationSection newLocation = panel.getConfig().getConfigurationSection("item." + playerInput);
                        panel.getConfig().set("item." + editor.slotSelected, (Object)newLocation);
                    }
                    panel.getConfig().set("item." + playerInput, (Object)oldLocation);
                    break;
                }
                case "itemmodeldata": {
                    panel.getConfig().set("item." + editor.slotSelected + ".customdata", (Object)playerInput);
                    break;
                }
                case "itemdurability": {
                    panel.getConfig().set("item." + editor.slotSelected + ".damage", (Object)playerInput);
                    break;
                }
                case "itemarmour": {
                    panel.getConfig().set("item." + editor.slotSelected + ".leatherarmor", (Object)playerInput);
                    break;
                }
                case "itemduplicate": {
                    panel.getConfig().set("item." + editor.slotSelected + ".duplicate", (Object)playerInput);
                    break;
                }
                case "itempotion": {
                    panel.getConfig().set("item." + editor.slotSelected + ".potion", (Object)playerInput);
                    break;
                }
                case "itemid": {
                    panel.getConfig().set("item." + editor.slotSelected + ".ID", (Object)playerInput);
                    break;
                }
                case "itemlore": {
                    this.listChanger(playerInput, panel, "item." + editor.slotSelected + ".lore");
                    if (panel.getConfig().isSet("item." + editor.slotSelected + ".name")) break;
                    e.getPlayer().sendMessage(ChatColor.RED + "Your item needs to have a name for your lore to be visible!");
                    break;
                }
                case "itemcommands": {
                    this.listChanger(playerInput, panel, "item." + editor.slotSelected + ".commands");
                    break;
                }
                case "iteminput": {
                    this.listChanger(playerInput, panel, "item." + editor.slotSelected + ".player-input");
                    break;
                }
                case "itemtypes": {
                    this.listChanger(playerInput, panel, "item." + editor.slotSelected + ".itemType");
                    break;
                }
                case "itemenchantment": {
                    this.listChanger(playerInput, panel, "item." + editor.slotSelected + ".enchanted");
                    break;
                }
                case "itemnbt": {
                    if (playerInput.startsWith("add")) {
                        String[] str = playerInput.split("\\s", 3);
                        panel.getConfig().set("item." + editor.slotSelected + ".nbt." + str[1], (Object)str[2]);
                        break;
                    }
                    if (!playerInput.startsWith("remove")) break;
                    String element = playerInput.split("\\s")[1];
                    panel.getConfig().set("item." + editor.slotSelected + ".nbt." + element, null);
                }
            }
        } else {
            switch (editType) {
                case "panelpermission": {
                    panel.getConfig().set("perm", (Object)playerInput);
                    break;
                }
                case "panelenabledworlds": {
                    this.listChanger(playerInput, panel, "enabled-worlds");
                    break;
                }
                case "paneldisabledworlds": {
                    this.listChanger(playerInput, panel, "disabled-worlds");
                    break;
                }
                case "panelopensound": {
                    panel.getConfig().set("sound-on-open", (Object)playerInput);
                    break;
                }
                case "panelemptyid": {
                    panel.getConfig().set("emptyID", (Object)playerInput);
                    break;
                }
                case "panelempty": {
                    panel.getConfig().set("empty", (Object)playerInput);
                    break;
                }
                case "paneltitle": {
                    panel.getConfig().set("title", (Object)playerInput);
                    break;
                }
                case "panelrows": {
                    if (this.isNumeric(playerInput)) {
                        panel.getConfig().set("rows", (Object)Integer.parseInt(playerInput));
                        break;
                    }
                    panel.getConfig().set("rows", (Object)playerInput);
                    break;
                }
                case "panelrefreshdelay": {
                    panel.getConfig().set("refresh-delay", (Object)playerInput);
                    break;
                }
                case "paneltype": {
                    this.listChanger(playerInput, panel, "panelType");
                    break;
                }
                case "panelcommands": {
                    this.listChanger(playerInput, panel, "commands");
                    break;
                }
                case "panelprecommands": {
                    this.listChanger(playerInput, panel, "pre-load-commands");
                    break;
                }
                case "panelopencommands": {
                    this.listChanger(playerInput, panel, "commands-on-open");
                    break;
                }
                case "panelclosecommands": {
                    this.listChanger(playerInput, panel, "commands-on-close");
                    break;
                }
                case "paneloutsidecommands": {
                    this.listChanger(playerInput, panel, "outside-commands");
                    break;
                }
                case "panelplayerinputmessage": {
                    this.listChanger(playerInput, panel, "custom-messages.player-input");
                    break;
                }
                case "panelmaxinputmessage": {
                    panel.getConfig().set("custom-messages.input", (Object)playerInput);
                    break;
                }
                case "panelpermissionmessage": {
                    panel.getConfig().set("custom-messages.perm", (Object)playerInput);
                    break;
                }
                case "paneldelete": {
                    if (!playerInput.toLowerCase().startsWith("c")) break;
                    try {
                        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)panel.getFile());
                        newConfig.set("panels." + panel.getName(), null);
                        e.getPlayer().sendMessage(ChatColor.GREEN + "Panel deleted!");
                        if (newConfig.getKeys(true).size() == 1 && panel.getFile().delete()) {
                            this.plugin.reloadPanelFiles();
                            return;
                        }
                        newConfig.save(panel.getFile());
                    }
                    catch (Exception io) {
                        this.plugin.debug(io, e.getPlayer());
                    }
                    this.plugin.reloadPanelFiles();
                    return;
                }
                case "panelname": {
                    YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)panel.getFile());
                    newConfig.set("panels." + playerInput.split("\\s")[0], (Object)panel.getConfig());
                    newConfig.set("panels." + panel.getName(), null);
                    try {
                        newConfig.save(panel.getFile());
                    }
                    catch (Exception io) {
                        this.plugin.debug(io, e.getPlayer());
                    }
                    this.plugin.reloadPanelFiles();
                    e.getPlayer().sendMessage(ChatColor.GREEN + "Panel name changed!");
                    return;
                }
            }
        }
        this.savePanelFile(panel);
        panel.open(e.getPlayer(), PanelPosition.Top);
        this.plugin.editorMain.openGuiPage(this.plugin.editorMain.settings.get((Object)e.getPlayer().getUniqueId()).menuOpen, e.getPlayer(), PanelPosition.Middle);
        this.plugin.editorMain.openGuiPage("BottomSettings", e.getPlayer(), PanelPosition.Bottom);
    }

    public void listChanger(String playerInput, Panel panel, String location) {
        List contents = panel.getConfig().getStringList(location);
        if (playerInput.startsWith("add")) {
            String str = playerInput.split("\\s", 2)[1];
            contents.add(str);
        } else if (playerInput.startsWith("edit")) {
            ArrayList<String> str = new ArrayList<String>(Arrays.asList(playerInput.split("\\s")));
            str.subList(0, 2).clear();
            int element = Integer.parseInt(playerInput.split("\\s")[1]) - 1;
            contents.set(element, String.join((CharSequence)" ", str));
        } else if (playerInput.startsWith("insert")) {
            ArrayList<String> str = new ArrayList<String>(Arrays.asList(playerInput.split("\\s")));
            str.subList(0, 2).clear();
            int element = Integer.parseInt(playerInput.split("\\s")[1]) - 1;
            contents.add(element, String.join((CharSequence)" ", str));
        } else if (playerInput.startsWith("remove")) {
            int element = Integer.parseInt(playerInput.split("\\s")[1]) - 1;
            contents.remove(element);
        }
        if (contents.isEmpty()) {
            panel.getConfig().set(location, null);
        } else {
            panel.getConfig().set(location, (Object)contents);
        }
    }

    public void viewContents(Player player, Panel panel, String location) {
        if (panel.getConfig().isList(location)) {
            player.sendMessage("Current Value: ");
            int n = 1;
            for (String value : panel.getConfig().getStringList(location)) {
                player.sendMessage("(" + n + ") " + value);
                ++n;
            }
        } else {
            player.sendMessage("Current Value: " + panel.getConfig().getString(location));
        }
    }

    public boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

