/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commandtags;

import de.NeonnBukkit.CoinsAPI.API.CoinsAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.realized.tokenmanager.api.TokenManager;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.commandtags.CommandTagEvent;
import me.rockyhawk.commandpanels.commandtags.PaywallOutput;
import me.rockyhawk.commandpanels.commandtags.tags.economy.BuyCommandTags;
import me.rockyhawk.commandpanels.commandtags.tags.economy.BuyItemTags;
import me.rockyhawk.commandpanels.commandtags.tags.economy.SellItemTags;
import me.rockyhawk.commandpanels.commandtags.tags.other.DataTags;
import me.rockyhawk.commandpanels.commandtags.tags.other.PlaceholderTags;
import me.rockyhawk.commandpanels.commandtags.tags.other.SpecialTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.BasicTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.BungeeTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.ItemTags;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommandTags {
    CommandPanels plugin;

    public CommandTags(CommandPanels pl) {
        this.plugin = pl;
    }

    public void runCommands(Panel panel, PanelPosition position, Player p, List<String> commands, ClickType click) {
        for (String command : commands) {
            if ((command = this.plugin.commandTags.hasCorrectClick(command, click)).equals("")) continue;
            PaywallOutput val = this.plugin.commandTags.commandPayWall(panel, p, command);
            if (val == PaywallOutput.Blocked) break;
            if (val != PaywallOutput.NotApplicable) continue;
            this.plugin.commandTags.runCommand(panel, position, p, command);
        }
    }

    public void runCommands(Panel panel, PanelPosition position, Player p, List<String> commands) {
        String command;
        PaywallOutput val;
        Iterator<String> iterator = commands.iterator();
        while (iterator.hasNext() && (val = this.plugin.commandTags.commandPayWall(panel, p, command = iterator.next())) != PaywallOutput.Blocked) {
            if (val != PaywallOutput.NotApplicable) continue;
            this.plugin.commandTags.runCommand(panel, position, p, command);
        }
    }

    public void runCommand(Panel panel, PanelPosition position, Player p, String commandRAW) {
        CommandTagEvent tags = new CommandTagEvent(this.plugin, panel, position, p, commandRAW);
        Bukkit.getPluginManager().callEvent((Event)tags);
        if (!tags.commandTagUsed) {
            Bukkit.dispatchCommand((CommandSender)p, (String)this.plugin.tex.placeholders(panel, position, p, commandRAW.trim()));
        }
    }

    public void registerBuiltInTags() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BuyCommandTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BuyItemTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new SellItemTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new DataTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new PlaceholderTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new SpecialTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BasicTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BungeeTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new ItemTags(this.plugin), (Plugin)this.plugin);
    }

    public String hasCorrectClick(String command, ClickType click) {
        try {
            switch (command.split("\\s")[0]) {
                case "right=": {
                    command = command.replace("right= ", "");
                    if (click == ClickType.RIGHT) break;
                    return "";
                }
                case "rightshift=": {
                    command = command.replace("rightshift= ", "");
                    if (click == ClickType.SHIFT_RIGHT) break;
                    return "";
                }
                case "left=": {
                    command = command.replace("left= ", "");
                    if (click == ClickType.LEFT) break;
                    return "";
                }
                case "leftshift=": {
                    command = command.replace("leftshift= ", "");
                    if (click == ClickType.SHIFT_LEFT) break;
                    return "";
                }
                case "middle=": {
                    command = command.replace("middle= ", "");
                    if (click == ClickType.MIDDLE) break;
                    return "";
                }
            }
            return command;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public PaywallOutput commandPayWall(Panel panel, Player p, String rawCommand) {
        String command = this.plugin.tex.placeholders(panel, PanelPosition.Top, p, rawCommand);
        switch (command.split("\\s")[0]) {
            case "paywall=": {
                try {
                    if (this.plugin.econ != null) {
                        if (this.plugin.econ.getBalance((OfflinePlayer)p) >= Double.parseDouble(command.split("\\s")[1])) {
                            this.plugin.econ.withdrawPlayer((OfflinePlayer)p, Double.parseDouble(command.split("\\s")[1]));
                            if (this.plugin.config.getBoolean("purchase.currency.enable")) {
                                this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.currency.success")).replaceAll("%cp-args%", command.split("\\s")[1]));
                            }
                            return PaywallOutput.Passed;
                        }
                        if (this.plugin.config.getBoolean("purchase.currency.enable")) {
                            this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.currency.failure"));
                        }
                        return PaywallOutput.Blocked;
                    }
                    this.plugin.tex.sendString(p, this.plugin.tag + ChatColor.RED + "Paying Requires Vault and an Economy to work!");
                    return PaywallOutput.Blocked;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
            case "tokenpaywall=": {
                try {
                    if (this.plugin.getServer().getPluginManager().isPluginEnabled("TokenManager")) {
                        TokenManager api = (TokenManager)Bukkit.getServer().getPluginManager().getPlugin("TokenManager");
                        assert (api != null);
                        int balance = Integer.parseInt(Long.toString(api.getTokens(p).orElse(0L)));
                        if ((double)balance >= Double.parseDouble(command.split("\\s")[1])) {
                            api.removeTokens(p, Long.parseLong(command.split("\\s")[1]));
                            if (this.plugin.config.getBoolean("purchase.tokens.enable")) {
                                this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.tokens.failure"));
                            }
                            this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.tokens.success")).replaceAll("%cp-args%", command.split("\\s")[1]));
                            return PaywallOutput.Passed;
                        }
                        if (this.plugin.config.getBoolean("purchase.tokens.enable")) {
                            this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.tokens.failure"));
                        }
                        return PaywallOutput.Blocked;
                    }
                    this.plugin.tex.sendString(p, this.plugin.tag + ChatColor.RED + "Needs TokenManager to work!");
                    return PaywallOutput.Blocked;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
            case "coinpaywall=": {
                try {
                    if (this.plugin.getServer().getPluginManager().isPluginEnabled("CoinsAPINB")) {
                        int balance = CoinsAPI.getCoins((String)p.getUniqueId().toString());
                        if ((double)balance >= Double.parseDouble(command.split("\\s")[1])) {
                            CoinsAPI.removeCoins((String)p.getUniqueId().toString(), (Integer)((int)Long.parseLong(command.split("\\s")[1])));
                            if (this.plugin.config.getBoolean("purchase.coins.enable")) {
                                this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.coins.success")).replaceAll("%cp-args%", command.split("\\s")[1]));
                            }
                            return PaywallOutput.Passed;
                        }
                        if (this.plugin.config.getBoolean("purchase.coins.enable")) {
                            this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.coins.failure"));
                        }
                        return PaywallOutput.Blocked;
                    }
                    this.plugin.tex.sendString(p, this.plugin.tag + ChatColor.RED + "Needs CoinAPI to work!");
                    return PaywallOutput.Blocked;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
            case "item-paywall=": {
                ArrayList<ItemStack> cont = new ArrayList<ItemStack>(Arrays.asList(this.plugin.inventorySaver.getNormalInventory(p)));
                try {
                    short id = 0;
                    if (command.split("\\s").length == 4) {
                        id = Short.parseShort(command.split("\\s")[3]);
                    }
                    ItemStack sellItem = Material.matchMaterial((String)command.split("\\s")[1]) == null ? this.plugin.itemCreate.makeCustomItemFromConfig(panel, PanelPosition.Top, panel.getConfig().getConfigurationSection("custom-item." + command.split("\\s")[1]), p, true, true, false) : new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)command.split("\\s")[1])), Integer.parseInt(command.split("\\s")[2]), id);
                    PaywallOutput removedItem = PaywallOutput.Blocked;
                    for (int f = 0; f < 36; ++f) {
                        if (cont.get(f) == null) continue;
                        if (Material.matchMaterial((String)command.split("\\s")[1]) == null) {
                            if (this.plugin.itemCreate.isIdentical(sellItem, (ItemStack)cont.get(f))) {
                                int sellItemAmount = sellItem.getAmount();
                                if (command.split("\\s").length == 3) {
                                    sellItemAmount = Integer.parseInt(command.split("\\s")[2]);
                                }
                                if (sellItemAmount <= ((ItemStack)cont.get(f)).getAmount()) {
                                    if (this.plugin.inventorySaver.hasNormalInventory(p)) {
                                        p.getInventory().getItem(f).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItemAmount);
                                        p.updateInventory();
                                    } else {
                                        ((ItemStack)cont.get(f)).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItemAmount);
                                        this.plugin.inventorySaver.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
                                    }
                                    removedItem = PaywallOutput.Passed;
                                    break;
                                }
                            }
                            try {
                                if (!this.plugin.getServer().getPluginManager().isPluginEnabled("MMOItems") || !panel.getConfig().getString("custom-item." + command.split("\\s")[1] + ".material").startsWith("mmo=")) continue;
                                String customItemMaterial = panel.getConfig().getString("custom-item." + command.split("\\s")[1] + ".material");
                                String mmoType = customItemMaterial.split("\\s")[1];
                                String mmoID = customItemMaterial.split("\\s")[2];
                                if (!this.plugin.isMMOItem((ItemStack)cont.get(f), mmoType, mmoID) || sellItem.getAmount() > ((ItemStack)cont.get(f)).getAmount()) continue;
                                if (this.plugin.inventorySaver.hasNormalInventory(p)) {
                                    p.getInventory().getItem(f).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItem.getAmount());
                                    p.updateInventory();
                                } else {
                                    ((ItemStack)cont.get(f)).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItem.getAmount());
                                    this.plugin.inventorySaver.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
                                }
                                removedItem = PaywallOutput.Passed;
                                break;
                            }
                            catch (Exception ex) {
                                this.plugin.debug(ex, p);
                                continue;
                            }
                        }
                        if (((ItemStack)cont.get(f)).getType() != sellItem.getType() || sellItem.getAmount() > ((ItemStack)cont.get(f)).getAmount()) continue;
                        if (this.plugin.inventorySaver.hasNormalInventory(p)) {
                            p.getInventory().getItem(f).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItem.getAmount());
                            p.updateInventory();
                        } else {
                            ((ItemStack)cont.get(f)).setAmount(((ItemStack)cont.get(f)).getAmount() - sellItem.getAmount());
                            this.plugin.inventorySaver.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
                        }
                        removedItem = PaywallOutput.Passed;
                        break;
                    }
                    if (removedItem == PaywallOutput.Blocked) {
                        if (this.plugin.config.getBoolean("purchase.item.enable")) {
                            this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("purchase.item.failure"));
                        }
                    } else if (this.plugin.config.getBoolean("purchase.item.enable")) {
                        this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.item.success")).replaceAll("%cp-args%", sellItem.getType().toString()));
                    }
                    return removedItem;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
            case "xp-paywall=": {
                try {
                    int balance = command.split("\\s")[2].startsWith("level") ? p.getLevel() : this.getPlayerExp(p);
                    if (balance >= Integer.parseInt(command.split("\\s")[1])) {
                        if (command.split("\\s")[2].startsWith("level")) {
                            p.setLevel(p.getLevel() - Integer.parseInt(command.split("\\s")[1]));
                        } else {
                            this.removePlayerExp(p, Integer.parseInt(command.split("\\s")[1]));
                        }
                        if (this.plugin.config.getBoolean("purchase.xp.enable")) {
                            this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.xp.success")).replaceAll("%cp-args%", command.split("\\s")[1]));
                        }
                        return PaywallOutput.Passed;
                    }
                    if (this.plugin.config.getBoolean("purchase.xp.enable")) {
                        this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.xp.failure"));
                    }
                    return PaywallOutput.Blocked;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
            case "data-paywall=": {
                try {
                    if (Double.parseDouble(this.plugin.panelData.getUserData(p.getUniqueId(), command.split("\\s")[1])) >= Double.parseDouble(command.split("\\s")[2])) {
                        this.plugin.panelData.doDataMath(p.getUniqueId(), command.split("\\s")[1], "-" + this.plugin.tex.placeholdersNoColour(panel, PanelPosition.Top, p, command.split("\\s")[2]));
                        if (this.plugin.config.getBoolean("purchase.data.enable")) {
                            this.plugin.tex.sendString(p, Objects.requireNonNull(this.plugin.config.getString("purchase.data.success")).replaceAll("%cp-args%", command.split("\\s")[2]));
                        }
                        return PaywallOutput.Passed;
                    }
                    if (this.plugin.config.getBoolean("purchase.data.enable")) {
                        this.plugin.tex.sendString(p, this.plugin.config.getString("purchase.data.failure"));
                    }
                    return PaywallOutput.Blocked;
                }
                catch (Exception buyc) {
                    this.plugin.debug(buyc, p);
                    this.plugin.tex.sendString(p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + command);
                    return PaywallOutput.Blocked;
                }
            }
        }
        return PaywallOutput.NotApplicable;
    }

    private int getExpAtLevel(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    private int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private int getPlayerExp(Player player) {
        int exp = 0;
        int level = player.getLevel();
        exp += this.getExpAtLevel(level);
        return exp += Math.round((float)this.getExpToLevelUp(level) * player.getExp());
    }

    private int removePlayerExp(Player player, int exp) {
        int currentExp = this.getPlayerExp(player);
        player.setExp(0.0f);
        player.setLevel(0);
        int newExp = currentExp - exp;
        player.giveExp(newExp);
        return newExp;
    }
}

