/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import me.rockyhawk.commandpanels.CommandPanels;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.scheduler.BukkitRunnable;

public class CommandPanelImport
implements CommandExecutor {
    CommandPanels plugin;

    public CommandPanelImport(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public boolean onCommand(final CommandSender sender, Command cmd, String label, final String[] args) {
        if (sender.hasPermission("commandpanel.import")) {
            if (args.length == 2) {
                new BukkitRunnable(){

                    public void run() {
                        CommandPanelImport.this.downloadPanel(sender, args[1], args[0]);
                        CommandPanelImport.this.plugin.reloadPanelFiles();
                    }
                }.run();
                return true;
            }
        } else {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
        }
        sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Usage: /cpi <file name> <url>"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadPanel(CommandSender sender, String url, String fileName) {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL fileUrl = new URL(url);
            in = new BufferedInputStream(fileUrl.openStream());
            fout = new FileOutputStream(new File(this.plugin.panelsf, fileName + ".yml"));
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
            sender.sendMessage(this.plugin.tag + ChatColor.GREEN + "Finished downloading.");
        }
        catch (Exception var22) {
            sender.sendMessage(this.plugin.tag + ChatColor.RED + "Could not download panel.");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException var21) {
                this.plugin.getLogger().log(Level.SEVERE, null, var21);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException var20) {
                this.plugin.getLogger().log(Level.SEVERE, null, var20);
            }
        }
    }
}

