/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources;

import java.io.File;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelOpenedEvent;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelOpenType;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class ExecuteOpenVoids {
    CommandPanels plugin;

    public ExecuteOpenVoids(CommandPanels pl) {
        this.plugin = pl;
    }

    public void openCommandPanel(CommandSender sender, Player p, Panel panel, PanelPosition position, boolean openForOtherUser) {
        if (p == null) {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Player not found."));
            return;
        }
        if (p.isSleeping()) {
            return;
        }
        if ((this.plugin.debug.isEnabled(sender) || this.plugin.config.getBoolean("config.auto-update-panels")) && panel.getFile() != null) {
            panel.setConfig((ConfigurationSection)YamlConfiguration.loadConfiguration((File)panel.getFile()));
        }
        if (!sender.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm"))) {
            if (panel.getConfig().getString("custom-messages.perms") != null) {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + panel.getConfig().getString("custom-messages.perms")));
            } else {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
            }
            return;
        }
        if (sender.hasPermission("commandpanel.other") || !openForOtherUser) {
            if (!this.plugin.panelPerms.isPanelWorldEnabled(p, panel.getConfig())) {
                if (panel.getConfig().getString("custom-messages.perms") != null) {
                    sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + panel.getConfig().getString("custom-messages.perms")));
                } else {
                    sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
                }
                return;
            }
            if (position != PanelPosition.Top && !this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Cannot open a panel without a panel at the top already."));
                return;
            }
            if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top) && p.getOpenInventory().getType() != InventoryType.CRAFTING) {
                p.closeInventory();
            }
            PanelOpenedEvent openedEvent = new PanelOpenedEvent(p, panel, position);
            Bukkit.getPluginManager().callEvent((Event)openedEvent);
            if (openedEvent.isCancelled()) {
                return;
            }
            this.beforeLoadCommands(panel, position, p);
            try {
                this.plugin.createGUI.openGui(panel, p, position, PanelOpenType.Normal, 0);
                if (panel.getConfig().contains("commands-on-open")) {
                    try {
                        this.plugin.commandTags.runCommands(panel, position, p, panel.getConfig().getStringList("commands-on-open"));
                    }
                    catch (Exception s) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands-on-open: " + panel.getConfig().getString("commands-on-open")));
                    }
                }
                if (panel.getConfig().contains("sound-on-open") && !Objects.requireNonNull(panel.getConfig().getString("sound-on-open")).equalsIgnoreCase("off")) {
                    try {
                        p.playSound(p.getLocation(), Sound.valueOf((String)Objects.requireNonNull(panel.getConfig().getString("sound-on-open")).toUpperCase()), 1.0f, 1.0f);
                    }
                    catch (Exception s) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " sound-on-open: " + panel.getConfig().getString("sound-on-open")));
                    }
                }
                if (openForOtherUser) {
                    sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Panel Opened for " + p.getDisplayName()));
                }
            }
            catch (Exception r) {
                this.plugin.debug(r, null);
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error")));
                this.plugin.openPanels.closePanelForLoader(p.getName(), position);
                p.closeInventory();
            }
        } else if (panel.getConfig().getString("custom-messages.perms") != null) {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + panel.getConfig().getString("custom-messages.perms")));
        } else {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
        }
    }

    public void giveHotbarItem(CommandSender sender, Player p, Panel panel, boolean sendGiveMessage) {
        if (sender.hasPermission("commandpanel.item." + panel.getConfig().getString("perm")) && panel.getConfig().contains("open-with-item")) {
            if (!this.plugin.panelPerms.isPanelWorldEnabled(p, panel.getConfig())) {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
                return;
            }
            if (sender.hasPermission("commandpanel.other") || !sendGiveMessage) {
                try {
                    if (panel.getConfig().contains("open-with-item.stationary")) {
                        p.getInventory().setItem(Integer.parseInt(Objects.requireNonNull(panel.getConfig().getString("open-with-item.stationary"))), panel.getHotbarItem(p));
                    } else {
                        p.getInventory().addItem(new ItemStack[]{panel.getHotbarItem(p)});
                    }
                    if (sendGiveMessage) {
                        sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Item Given to " + p.getDisplayName()));
                    }
                }
                catch (Exception r) {
                    sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.notitem")));
                }
            } else {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
            }
            return;
        }
        if (!panel.getConfig().contains("open-with-item")) {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.noitem")));
            return;
        }
        sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
    }

    public void beforeLoadCommands(Panel panel, PanelPosition pos, Player p) {
        if (panel.getConfig().contains("pre-load-commands")) {
            try {
                this.plugin.commandTags.runCommands(panel, pos, p, panel.getConfig().getStringList("pre-load-commands"));
            }
            catch (Exception s) {
                this.plugin.debug(s, p);
            }
        }
    }
}

