/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.api;

import java.io.File;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.classresources.placeholders.PanelPlaceholders;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelOpenType;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class Panel {
    CommandPanels plugin = (CommandPanels)JavaPlugin.getPlugin(CommandPanels.class);
    private ConfigurationSection panelConfig;
    private String panelName;
    private File panelFile = null;
    public PanelPlaceholders placeholders = new PanelPlaceholders();
    public boolean isOpen = false;

    public Panel(File file, String name) {
        this.panelName = name;
        this.panelFile = file;
        this.panelConfig = YamlConfiguration.loadConfiguration((File)file).getConfigurationSection("panels." + name);
    }

    public Panel(ConfigurationSection config, String name) {
        if (config.contains("panels")) {
            config = config.getConfigurationSection("panels." + name);
        }
        this.panelName = name;
        this.panelConfig = config;
    }

    public Panel(String name) {
        this.panelName = name;
    }

    public void setName(String name) {
        this.panelName = name;
    }

    public void setConfig(ConfigurationSection config) {
        if (config.contains("panels")) {
            config = config.getConfigurationSection("panels." + this.panelName);
        }
        this.panelConfig = config;
    }

    public void setFile(File file) {
        this.panelFile = file;
        this.panelConfig = YamlConfiguration.loadConfiguration((File)file).getConfigurationSection("panels." + this.getName());
    }

    public String getName() {
        return this.panelName;
    }

    public ConfigurationSection getConfig() {
        return this.panelConfig;
    }

    public File getFile() {
        return this.panelFile;
    }

    public ItemStack getItem(Player p, int slot) {
        String section = this.plugin.has.hasSection(this, PanelPosition.Top, this.panelConfig.getConfigurationSection("item." + slot), p);
        ConfigurationSection itemSection = this.panelConfig.getConfigurationSection("item." + slot + section);
        return this.plugin.itemCreate.makeItemFromConfig(this, PanelPosition.Top, itemSection, p, true, true, false);
    }

    public ItemStack getCustomItem(Player p, String itemName) {
        String section = this.plugin.has.hasSection(this, PanelPosition.Top, this.panelConfig.getConfigurationSection("custom-item." + itemName), p);
        ConfigurationSection itemSection = this.panelConfig.getConfigurationSection("custom-item." + itemName + section);
        return this.plugin.itemCreate.makeCustomItemFromConfig(this, PanelPosition.Top, itemSection, p, true, true, false);
    }

    public ItemStack getHotbarItem(Player p) {
        if (this.getConfig().contains("open-with-item.pre-load-commands")) {
            try {
                this.plugin.commandTags.runCommands(this, PanelPosition.Top, p, this.getConfig().getStringList("open-with-item.pre-load-commands"));
            }
            catch (Exception s) {
                this.plugin.debug(s, p);
            }
        }
        ItemStack s = this.plugin.itemCreate.makeItemFromConfig(this, PanelPosition.Top, this.getHotbarSection(p), p, true, true, false);
        int slot = -1;
        if (this.getHotbarSection(p).isSet("stationary")) {
            slot = this.getHotbarSection(p).getInt("stationary");
        }
        return this.plugin.nbt.setNBT(s, "CommandPanelsHotbar", this.panelName + ":" + slot);
    }

    public ConfigurationSection getHotbarSection(Player p) {
        String section = this.plugin.has.hasSection(this, PanelPosition.Top, this.panelConfig.getConfigurationSection("open-with-item"), p);
        return this.panelConfig.getConfigurationSection("open-with-item" + section);
    }

    public boolean hasHotbarItem() {
        return this.panelConfig.contains("open-with-item");
    }

    public Inventory getInventory(Player p) {
        return this.plugin.createGUI.openGui(this, p, PanelPosition.Top, PanelOpenType.Return, 0);
    }

    public void open(Player p, PanelPosition position) {
        this.isOpen = true;
        this.plugin.openVoids.openCommandPanel((CommandSender)p, p, this, position, false);
    }

    public Panel copy() {
        if (this.panelFile != null) {
            return new Panel(this.panelFile, this.panelName);
        }
        return new Panel(this.panelConfig, this.panelName);
    }
}

