/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.util.List;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interactives.input.PlayerInput;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;

public class Utils
implements Listener {
    CommandPanels plugin;

    public Utils(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onItemDrag(InventoryDragEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (e.getInventory().getType() != InventoryType.PLAYER) {
            e.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler
    public void onPanelClick(InventoryClickEvent e) {
        int i;
        Player p = (Player)e.getWhoClicked();
        int clickedSlot = e.getSlot();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) return;
        if (e.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        Panel panel = this.plugin.openPanels.getOpenPanel(p.getName(), PanelPosition.Top);
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            if (!panel.getConfig().contains("outside-commands")) return;
            try {
                this.plugin.commandTags.runCommands(panel, PanelPosition.Top, p, panel.getConfig().getStringList("outside-commands"), e.getClick());
                return;
            }
            catch (Exception s) {
                this.plugin.debug(s, p);
            }
            return;
        }
        PanelPosition position = PanelPosition.Top;
        if (e.getClickedInventory().getType() == InventoryType.PLAYER) {
            if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                e.setCancelled(true);
                return;
            }
            if (e.getSlotType() == InventoryType.SlotType.CONTAINER) {
                if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Middle)) {
                    e.setCancelled(this.itemsUnmovable(panel));
                    return;
                }
                position = PanelPosition.Middle;
                clickedSlot -= 9;
            } else {
                if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Bottom)) {
                    e.setCancelled(this.itemsUnmovable(panel));
                    return;
                }
                position = PanelPosition.Bottom;
                e.setCancelled(true);
            }
        }
        panel = this.plugin.openPanels.getOpenPanel(p.getName(), position);
        if (this.plugin.editorMain.settings.containsKey(p.getUniqueId()) && this.plugin.editorMain.settings.get((Object)p.getUniqueId()).hasEditorOpen && position == PanelPosition.Top) {
            this.plugin.editorMain.settings.get((Object)p.getUniqueId()).slotSelected = String.valueOf(e.getSlot());
            this.plugin.editorMain.openGuiPage(this.plugin.editorMain.settings.get((Object)p.getUniqueId()).menuOpen, p, PanelPosition.Middle);
            e.setCancelled(true);
            return;
        }
        boolean foundSlot = false;
        for (String slot : Objects.requireNonNull(panel.getConfig().getConfigurationSection("item")).getKeys(false)) {
            if (!slot.equals(Integer.toString(clickedSlot))) continue;
            foundSlot = true;
            break;
        }
        if (!foundSlot) {
            e.setCancelled(true);
            return;
        }
        String section = this.plugin.has.hasSection(panel, position, panel.getConfig().getConfigurationSection("item." + clickedSlot), p);
        if (panel.getConfig().contains("item." + clickedSlot + section + ".itemType") && panel.getConfig().getStringList("item." + clickedSlot + section + ".itemType").contains("placeable")) {
            e.setCancelled(false);
            return;
        }
        e.setCancelled(true);
        p.updateInventory();
        if (panel.getConfig().contains("item." + clickedSlot + section + ".player-input")) {
            this.plugin.inputUtils.playerInput.put(p, new PlayerInput(panel, panel.getConfig().getStringList("item." + clickedSlot + section + ".player-input"), e.getClick()));
            this.plugin.inputUtils.sendMessage(panel, position, p);
        }
        if (!panel.getConfig().contains("item." + clickedSlot + section + ".commands")) return;
        List commands = panel.getConfig().getStringList("item." + clickedSlot + section + ".commands");
        if (commands.size() == 0) return;
        List commandsAfterSequence = commands;
        for (i = 0; commands.size() - 1 >= i; ++i) {
            if (!((String)commands.get(i)).startsWith("sequence=")) continue;
            String locationOfSequence = ((String)commands.get(i)).split("\\s")[1];
            List commandsSequence = panel.getConfig().getStringList(locationOfSequence);
            commandsAfterSequence.remove(i);
            commandsAfterSequence.addAll(i, commandsSequence);
        }
        commands = commandsAfterSequence;
        i = 0;
        while (true) {
            if (commands.size() <= i) {
                this.plugin.commandTags.runCommands(panel, position, p, commands, e.getClick());
                return;
            }
            try {
                commands.set(i, ((String)commands.get(i)).replaceAll("%cp-clicked%", e.getCurrentItem().getType().toString()));
            }
            catch (Exception mate) {
                commands.set(i, ((String)commands.get(i)).replaceAll("%cp-clicked%", "AIR"));
            }
            ++i;
        }
    }

    private boolean itemsUnmovable(Panel panel) {
        if (panel.getConfig().isSet("panelType")) {
            return panel.getConfig().getStringList("panelType").contains("unmovable");
        }
        return false;
    }
}

