/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import io.lumine.mythic.lib.api.item.NBTItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import me.rockyhawk.commandpanels.Metrics;
import me.rockyhawk.commandpanels.Utils;
import me.rockyhawk.commandpanels.api.CommandPanelsAPI;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.classresources.ExecuteOpenVoids;
import me.rockyhawk.commandpanels.classresources.GetCustomHeads;
import me.rockyhawk.commandpanels.classresources.HasSections;
import me.rockyhawk.commandpanels.classresources.ItemCreation;
import me.rockyhawk.commandpanels.classresources.item_fall.ItemFallManager;
import me.rockyhawk.commandpanels.classresources.placeholders.CreateText;
import me.rockyhawk.commandpanels.classresources.placeholders.HexColours;
import me.rockyhawk.commandpanels.classresources.placeholders.Placeholders;
import me.rockyhawk.commandpanels.classresources.placeholders.expansion.CpPlaceholderExpansion;
import me.rockyhawk.commandpanels.commands.CommandPanelImport;
import me.rockyhawk.commandpanels.commands.Commandpanel;
import me.rockyhawk.commandpanels.commands.Commandpanelsdata;
import me.rockyhawk.commandpanels.commands.Commandpanelsdebug;
import me.rockyhawk.commandpanels.commands.Commandpanelslist;
import me.rockyhawk.commandpanels.commands.Commandpanelsreload;
import me.rockyhawk.commandpanels.commands.Commandpanelversion;
import me.rockyhawk.commandpanels.commandtags.CommandTags;
import me.rockyhawk.commandpanels.completetabs.CpTabComplete;
import me.rockyhawk.commandpanels.completetabs.DataTabComplete;
import me.rockyhawk.commandpanels.completetabs.ImportTabComplete;
import me.rockyhawk.commandpanels.customcommands.Commandpanelcustom;
import me.rockyhawk.commandpanels.datamanager.DebugManager;
import me.rockyhawk.commandpanels.datamanager.PanelDataLoader;
import me.rockyhawk.commandpanels.editor.CPEventHandler;
import me.rockyhawk.commandpanels.editor.CommandPanelsEditorCommand;
import me.rockyhawk.commandpanels.editor.CommandPanelsEditorMain;
import me.rockyhawk.commandpanels.editor.CommandPanelsEditorTabComplete;
import me.rockyhawk.commandpanels.generatepanels.Commandpanelsgenerate;
import me.rockyhawk.commandpanels.generatepanels.GenUtils;
import me.rockyhawk.commandpanels.generatepanels.TabCompleteGenerate;
import me.rockyhawk.commandpanels.interactives.Commandpanelrefresher;
import me.rockyhawk.commandpanels.interactives.OpenOnJoin;
import me.rockyhawk.commandpanels.interactives.input.UserInputUtils;
import me.rockyhawk.commandpanels.ioclasses.Sequence_1_13;
import me.rockyhawk.commandpanels.ioclasses.Sequence_1_14;
import me.rockyhawk.commandpanels.ioclasses.legacy.LegacyVersion;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import me.rockyhawk.commandpanels.ioclasses.legacy.PlayerHeads;
import me.rockyhawk.commandpanels.ioclasses.nbt.NBTManager;
import me.rockyhawk.commandpanels.openpanelsmanager.OpenGUI;
import me.rockyhawk.commandpanels.openpanelsmanager.OpenPanelsLoader;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPermissions;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import me.rockyhawk.commandpanels.openpanelsmanager.UtilsPanelsLoader;
import me.rockyhawk.commandpanels.openwithitem.HotbarItemLoader;
import me.rockyhawk.commandpanels.openwithitem.SwapItemEvent;
import me.rockyhawk.commandpanels.openwithitem.UtilsChestSortEvent;
import me.rockyhawk.commandpanels.openwithitem.UtilsOpenWithItem;
import me.rockyhawk.commandpanels.panelblocks.BlocksTabComplete;
import me.rockyhawk.commandpanels.panelblocks.Commandpanelblocks;
import me.rockyhawk.commandpanels.panelblocks.PanelBlockOnClick;
import me.rockyhawk.commandpanels.playerinventoryhandler.InventorySaver;
import me.rockyhawk.commandpanels.playerinventoryhandler.ItemStackSerializer;
import me.rockyhawk.commandpanels.updater.Updater;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandPanels
extends JavaPlugin {
    public YamlConfiguration config;
    public Economy econ = null;
    public boolean openWithItem = false;
    public String tag = "[CommandPanels]";
    public List<Player> generateMode = new ArrayList<Player>();
    public List<String[]> editorInputStrings = new ArrayList<String[]>();
    public List<Panel> panelList = new ArrayList<Panel>();
    public CommandPanelsEditorMain editorMain = new CommandPanelsEditorMain(this);
    public CommandTags commandTags = new CommandTags(this);
    public PanelDataLoader panelData = new PanelDataLoader(this);
    public Placeholders placeholders = new Placeholders(this);
    public DebugManager debug = new DebugManager(this);
    public CreateText tex = new CreateText(this);
    public HexColours hex = new HexColours(this);
    public ExecuteOpenVoids openVoids = new ExecuteOpenVoids(this);
    public ItemCreation itemCreate = new ItemCreation(this);
    public HasSections has = new HasSections(this);
    public GetCustomHeads customHeads = new GetCustomHeads(this);
    public Updater updater = new Updater(this);
    public PlayerHeads getHeads = new PlayerHeads(this);
    public LegacyVersion legacy = new LegacyVersion(this);
    public OpenPanelsLoader openPanels = new OpenPanelsLoader(this);
    public OpenGUI createGUI = new OpenGUI(this);
    public PanelPermissions panelPerms = new PanelPermissions(this);
    public HotbarItemLoader hotbar = new HotbarItemLoader(this);
    public NBTManager nbt = new NBTManager(this);
    public InventorySaver inventorySaver = new InventorySaver(this);
    public ItemStackSerializer itemSerializer = new ItemStackSerializer(this);
    public UserInputUtils inputUtils = new UserInputUtils(this);
    public File panelsf = new File(this.getDataFolder() + File.separator + "panels");
    public YamlConfiguration blockConfig;
    public final Map<String, Color> colourCodes = new HashMap<String, Color>(){
        {
            this.put("AQUA", Color.AQUA);
            this.put("BLUE", Color.BLUE);
            this.put("GRAY", Color.GRAY);
            this.put("GREEN", Color.GREEN);
            this.put("RED", Color.RED);
            this.put("WHITE", Color.WHITE);
            this.put("BLACK", Color.BLACK);
            this.put("FUCHSIA", Color.FUCHSIA);
            this.put("LIME", Color.LIME);
            this.put("MAROON", Color.MAROON);
            this.put("NAVY", Color.NAVY);
            this.put("OLIVE", Color.OLIVE);
            this.put("ORANGE", Color.ORANGE);
            this.put("PURPLE", Color.PURPLE);
            this.put("SILVER", Color.SILVER);
            this.put("TEAL", Color.TEAL);
            this.put("YELLOW", Color.YELLOW);
        }
    };

    public void onEnable() {
        YamlConfiguration configFileConfiguration;
        Bukkit.getLogger().info("[CommandPanels] RockyHawk's CommandPanels v" + this.getDescription().getVersion() + " Plugin Loading...");
        this.blockConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "blocks.yml"));
        this.panelData.dataConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "data.yml"));
        this.inventorySaver.inventoryConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "inventories.yml"));
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "config.yml"));
        File configFile = new File(this.getDataFolder() + File.separator + "config.yml");
        if (!configFile.exists()) {
            try {
                configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("config.yml")));
                configFileConfiguration.save(configFile);
                this.config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var11) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the config file!");
            }
        } else {
            try {
                configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("config.yml")));
                this.config.addDefaults((Configuration)configFileConfiguration);
                this.config.options().copyDefaults(true);
                this.config.save(new File(this.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var10) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the config file!");
            }
        }
        if (Objects.requireNonNull(this.config.getString("updater.update-checks")).equalsIgnoreCase("true")) {
            this.updater.githubNewUpdate(false);
        }
        this.setupEconomy();
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        new Metrics((Plugin)this);
        Objects.requireNonNull(this.getCommand("commandpanel")).setExecutor((CommandExecutor)new Commandpanel(this));
        Objects.requireNonNull(this.getCommand("commandpanel")).setTabCompleter((TabCompleter)new CpTabComplete(this));
        Objects.requireNonNull(this.getCommand("commandpanelgenerate")).setTabCompleter((TabCompleter)new TabCompleteGenerate(this));
        Objects.requireNonNull(this.getCommand("commandpanelgenerate")).setExecutor((CommandExecutor)new Commandpanelsgenerate(this));
        Objects.requireNonNull(this.getCommand("commandpaneldata")).setTabCompleter((TabCompleter)new DataTabComplete(this));
        Objects.requireNonNull(this.getCommand("commandpaneldata")).setExecutor((CommandExecutor)new Commandpanelsdata(this));
        Objects.requireNonNull(this.getCommand("commandpanelimport")).setExecutor((CommandExecutor)new CommandPanelImport(this));
        Objects.requireNonNull(this.getCommand("commandpanelimport")).setTabCompleter((TabCompleter)new ImportTabComplete(this));
        Objects.requireNonNull(this.getCommand("commandpanelreload")).setExecutor((CommandExecutor)new Commandpanelsreload(this));
        Objects.requireNonNull(this.getCommand("commandpaneldebug")).setExecutor((CommandExecutor)new Commandpanelsdebug(this));
        Objects.requireNonNull(this.getCommand("commandpanelversion")).setExecutor((CommandExecutor)new Commandpanelversion(this));
        Objects.requireNonNull(this.getCommand("commandpanellist")).setExecutor((CommandExecutor)new Commandpanelslist(this));
        this.getServer().getPluginManager().registerEvents((Listener)new Utils(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.inventorySaver, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.inputUtils, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UtilsPanelsLoader(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GenUtils(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemFallManager(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OpenOnJoin(this), (Plugin)this);
        if (Objects.requireNonNull(this.config.getString("updater.update-checks")).equalsIgnoreCase("true")) {
            this.getServer().getPluginManager().registerEvents((Listener)this.updater, (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new CpPlaceholderExpansion(this).register();
        }
        this.commandTags.registerBuiltInTags();
        if (Objects.requireNonNull(this.config.getString("config.refresh-panels")).equalsIgnoreCase("true")) {
            this.getServer().getPluginManager().registerEvents((Listener)new Commandpanelrefresher(this), (Plugin)this);
        }
        if (Objects.requireNonNull(this.config.getString("config.custom-commands")).equalsIgnoreCase("true")) {
            this.getServer().getPluginManager().registerEvents((Listener)new Commandpanelcustom(this), (Plugin)this);
        }
        if (Objects.requireNonNull(this.config.getString("config.hotbar-items")).equalsIgnoreCase("true")) {
            this.getServer().getPluginManager().registerEvents((Listener)new UtilsOpenWithItem(this), (Plugin)this);
        }
        if (Objects.requireNonNull(this.config.getString("config.ingame-editor")).equalsIgnoreCase("true")) {
            this.getServer().getPluginManager().registerEvents((Listener)new CPEventHandler(this), (Plugin)this);
            Objects.requireNonNull(this.getCommand("commandpaneledit")).setTabCompleter((TabCompleter)new CommandPanelsEditorTabComplete(this));
            Objects.requireNonNull(this.getCommand("commandpaneledit")).setExecutor((CommandExecutor)new CommandPanelsEditorCommand(this));
        }
        if (Objects.requireNonNull(this.config.getString("config.panel-blocks")).equalsIgnoreCase("true")) {
            Objects.requireNonNull(this.getCommand("commandpanelblock")).setExecutor((CommandExecutor)new Commandpanelblocks(this));
            Objects.requireNonNull(this.getCommand("commandpanelblock")).setTabCompleter((TabCompleter)new BlocksTabComplete(this));
            this.getServer().getPluginManager().registerEvents((Listener)new PanelBlockOnClick(this), (Plugin)this);
        }
        if (!Bukkit.getVersion().contains("1.8")) {
            this.getServer().getPluginManager().registerEvents((Listener)new SwapItemEvent(this), (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ChestSort")) {
            this.getServer().getPluginManager().registerEvents((Listener)new UtilsChestSortEvent(this), (Plugin)this);
        }
        if (!this.panelsf.exists()) {
            try {
                YamlConfiguration exampleFileConfiguration;
                if (this.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("exampleLegacy.yml")));
                    exampleFileConfiguration.save(new File(this.panelsf + File.separator + "example.yml"));
                } else {
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("example_top.yml")));
                    exampleFileConfiguration.save(new File(this.panelsf + File.separator + "example_top.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("example_middle_one.yml")));
                    exampleFileConfiguration.save(new File(this.panelsf + File.separator + "example_middle_one.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("example_middle_two.yml")));
                    exampleFileConfiguration.save(new File(this.panelsf + File.separator + "example_middle_two.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("example_bottom.yml")));
                    exampleFileConfiguration.save(new File(this.panelsf + File.separator + "example_bottom.yml"));
                }
                YamlConfiguration templateFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.getResource("template.yml")));
                templateFileConfiguration.save(new File(this.panelsf + File.separator + "template.yml"));
            }
            catch (IOException var11) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the example file!");
            }
        }
        if (Objects.requireNonNull(this.config.getString("config.update-notifications")).equalsIgnoreCase("true")) {
            this.updater.githubNewUpdate(true);
        }
        this.reloadPanelFiles();
        this.hotbar.reloadHotbarSlots();
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new Metrics.SingleLineChart("panels_amount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return CommandPanels.this.panelList.size();
            }
        }));
        this.tag = this.tex.colour(this.config.getString("config.format.tag"));
        Bukkit.getLogger().info("[CommandPanels] RockyHawk's CommandPanels v" + this.getDescription().getVersion() + " Plugin Loaded!");
    }

    public void onDisable() {
        for (String name : this.openPanels.openPanels.keySet()) {
            this.openPanels.closePanelForLoader(name, PanelPosition.Top);
            try {
                Bukkit.getPlayer((String)name).closeInventory();
            }
            catch (Exception exception) {}
        }
        this.panelData.saveDataFile();
        this.inventorySaver.saveInventoryFile();
        this.updater.autoUpdatePlugin(this.getFile().getName());
        Bukkit.getLogger().info("RockyHawk's CommandPanels Plugin Disabled, aww man.");
    }

    public static CommandPanelsAPI getAPI() {
        return new CommandPanelsAPI((CommandPanels)JavaPlugin.getPlugin(CommandPanels.class));
    }

    public ItemStack setName(Panel panel, ItemStack renamed, String customName, List<String> lore, Player p, Boolean usePlaceholders, Boolean useColours, Boolean hideAttributes) {
        try {
            ItemMeta renamedMeta = renamed.getItemMeta();
            if (usePlaceholders.booleanValue()) {
                customName = this.tex.placeholdersNoColour(panel, PanelPosition.Top, p, customName);
            }
            if (useColours.booleanValue()) {
                customName = this.tex.colour(customName);
            }
            assert (renamedMeta != null);
            if (hideAttributes.booleanValue()) {
                renamedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                renamedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                renamedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                if (this.legacy.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_17)) {
                    renamedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                }
            }
            if (customName != null) {
                renamedMeta.setDisplayName(customName);
            }
            if (lore != null) {
                List<String> re_lore = usePlaceholders != false && useColours != false ? this.tex.placeholdersList(panel, PanelPosition.Top, p, lore, true) : (usePlaceholders != false ? this.tex.placeholdersNoColour(panel, PanelPosition.Top, p, lore) : (useColours != false ? this.tex.placeholdersList(panel, PanelPosition.Top, p, lore, false) : lore));
                renamedMeta.setLore(this.splitListWithEscape(re_lore));
            }
            renamed.setItemMeta(renamedMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return renamed;
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp;
        if (this.getServer().getPluginManager().getPlugin("Vault") != null && (rsp = this.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.econ = (Economy)rsp.getProvider();
        }
    }

    public boolean checkPanels(YamlConfiguration temp) {
        try {
            return temp.contains("panels");
        }
        catch (Exception var3) {
            return false;
        }
    }

    public boolean checkDuplicatePanel(CommandSender sender) {
        ArrayList<String> apanels = new ArrayList<String>();
        for (Panel panel : this.panelList) {
            apanels.add(panel.getName());
        }
        HashSet oset = new HashSet(apanels);
        if (oset.size() < apanels.size()) {
            ArrayList<String> opanelsTemp = new ArrayList<String>();
            for (String tempName : apanels) {
                if (opanelsTemp.contains(tempName)) {
                    sender.sendMessage(this.tex.colour(this.tag) + ChatColor.RED + " Error duplicate panel name: " + tempName);
                    return false;
                }
                opanelsTemp.add(tempName);
            }
            return false;
        }
        return true;
    }

    public void fileNamesFromDirectory(File directory) {
        for (String fileName : Objects.requireNonNull(directory.list())) {
            if (new File(directory + File.separator + fileName).isDirectory()) {
                this.fileNamesFromDirectory(new File(directory + File.separator + fileName));
                continue;
            }
            try {
                int ind = fileName.lastIndexOf(".");
                if (!fileName.substring(ind).equalsIgnoreCase(".yml") && !fileName.substring(ind).equalsIgnoreCase(".yaml")) {
                }
            }
            catch (Exception ex) {}
            continue;
            if (!this.checkPanels(YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)))) {
                this.getServer().getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " Error in: " + fileName);
                continue;
            }
            for (String tempName : Objects.requireNonNull(YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)).getConfigurationSection("panels")).getKeys(false)) {
                this.panelList.add(new Panel(new File(directory + File.separator + fileName), tempName));
                if (!YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)).contains("panels." + tempName + ".open-with-item")) continue;
                this.openWithItem = true;
            }
        }
    }

    public void reloadPanelFiles() {
        this.panelList.clear();
        this.openWithItem = false;
        this.fileNamesFromDirectory(this.panelsf);
    }

    public void debug(Exception e, Player p) {
        if (p == null) {
            if (this.debug.consoleDebug) {
                this.getServer().getConsoleSender().sendMessage(ChatColor.DARK_RED + "[CommandPanels] The plugin has generated a debug error, find the error below");
                e.printStackTrace();
            }
        } else if (this.debug.isEnabled(p)) {
            p.sendMessage(this.tag + ChatColor.DARK_RED + "Check the console for a detailed error.");
            this.getServer().getConsoleSender().sendMessage(ChatColor.DARK_RED + "[CommandPanels] The plugin has generated a debug error, find the error below");
            e.printStackTrace();
        }
    }

    public void helpMessage(CommandSender p) {
        p.sendMessage(this.tex.colour(this.tag + ChatColor.GREEN + "Commands:"));
        p.sendMessage(ChatColor.GOLD + "/cp <panel> [player:item] [player] " + ChatColor.WHITE + "Open a command panel.");
        if (p.hasPermission("commandpanel.reload")) {
            p.sendMessage(ChatColor.GOLD + "/cpr " + ChatColor.WHITE + "Reloads plugin config.");
        }
        if (p.hasPermission("commandpanel.generate")) {
            p.sendMessage(ChatColor.GOLD + "/cpg <rows> " + ChatColor.WHITE + "Generate GUI from popup menu.");
        }
        if (p.hasPermission("commandpanel.version")) {
            p.sendMessage(ChatColor.GOLD + "/cpv " + ChatColor.WHITE + "Display the current version.");
        }
        if (p.hasPermission("commandpanel.update")) {
            p.sendMessage(ChatColor.GOLD + "/cpv latest " + ChatColor.WHITE + "Download the latest update upon server reload/restart.");
            p.sendMessage(ChatColor.GOLD + "/cpv [version:cancel] " + ChatColor.WHITE + "Download an update upon server reload/restart.");
        }
        if (p.hasPermission("commandpanel.import")) {
            p.sendMessage(ChatColor.GOLD + "/cpi [file name] [URL] " + ChatColor.WHITE + "Downloads a panel from a raw link online.");
        }
        if (p.hasPermission("commandpanel.list")) {
            p.sendMessage(ChatColor.GOLD + "/cpl " + ChatColor.WHITE + "Lists the currently loaded panels.");
        }
        if (p.hasPermission("commandpanel.data")) {
            p.sendMessage(ChatColor.GOLD + "/cpdata " + ChatColor.WHITE + "Change panel data for a user.");
        }
        if (p.hasPermission("commandpanel.debug")) {
            p.sendMessage(ChatColor.GOLD + "/cpd " + ChatColor.WHITE + "Enable and Disable debug mode globally.");
        }
        if (p.hasPermission("commandpanel.block.add")) {
            p.sendMessage(ChatColor.GOLD + "/cpb add <panel> " + ChatColor.WHITE + "Add panel to a block being looked at.");
        }
        if (p.hasPermission("commandpanel.block.remove")) {
            p.sendMessage(ChatColor.GOLD + "/cpb remove " + ChatColor.WHITE + "Removes any panel assigned to a block looked at.");
        }
        if (p.hasPermission("commandpanel.block.list")) {
            p.sendMessage(ChatColor.GOLD + "/cpb list " + ChatColor.WHITE + "List blocks that will open panels.");
        }
        if (p.hasPermission("commandpanel.edit")) {
            p.sendMessage(ChatColor.GOLD + "/cpe <panel> " + ChatColor.WHITE + "Edit a panel with the Panel Editor.");
        }
    }

    public Reader getReaderFromStream(InputStream initialStream) throws IOException {
        if (this.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_13) || this.legacy.LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_18)) {
            return new Sequence_1_13(this).getReaderFromStream(initialStream);
        }
        return new Sequence_1_14(this).getReaderFromStream(initialStream);
    }

    public List<String> splitListWithEscape(List<String> list) {
        ArrayList<String> output = new ArrayList<String>();
        for (String str : list) {
            output.addAll(Arrays.asList(str.split("\\\\n")));
        }
        return output;
    }

    public int getRandomNumberInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public boolean isMMOItem(ItemStack itm, String type, String id) {
        try {
            if (this.getServer().getPluginManager().isPluginEnabled("MMOItems")) {
                NBTItem nbt = NBTItem.get((ItemStack)itm);
                if (nbt.getType().equalsIgnoreCase(type) && nbt.getString("MMOITEMS_ITEM_ID").equalsIgnoreCase(id)) {
                    return true;
                }
                itm.getType();
            }
        }
        catch (Exception ex) {
            this.debug(ex, null);
        }
        return false;
    }
}

