/*
 * Decompiled with CFR 0.152.
 */
package robin.main;

import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import robin.main.Cooldown;
import robin.main.FileManager;

public class CommandCooldown
extends JavaPlugin
implements Listener {
    public static CommandCooldown main;
    public static ArrayList<Cooldown> cooldowns;

    static {
        cooldowns = new ArrayList();
    }

    public void onEnable() {
        main = this;
        System.out.println("[CommandCooldown] Plugin successfully enabled!");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        FileManager.register();
        this.startCooldownTask();
    }

    @EventHandler
    public void onCmd(PlayerCommandPreprocessEvent e) {
        for (String cmd : FileManager.getCmds()) {
            if (!e.getMessage().toLowerCase().startsWith("/" + cmd)) continue;
            if (e.getPlayer().hasPermission("commandcooldown.bypass")) {
                return;
            }
            int cooldownPerm = 0;
            Iterator iterator = e.getPlayer().getEffectivePermissions().iterator();
            while (iterator.hasNext()) {
                String perm = ((PermissionAttachmentInfo)iterator.next()).getPermission();
                if (!perm.startsWith("commandcooldown." + cmd.replaceAll(" ", "_")) || this.getCooldownFromPerm(perm, cmd) >= cooldownPerm && cooldownPerm != 0) continue;
                cooldownPerm = this.getCooldownFromPerm(perm, cmd);
            }
            if (!this.isCooldowned(e.getPlayer().getName(), cmd)) {
                cooldowns.add(new Cooldown(e.getPlayer().getName(), System.currentTimeMillis() + (long)(cooldownPerm * 1000), cmd));
                e.getPlayer().sendMessage(FileManager.cfg.getString("commandEnter").replaceAll("&", "\u00a7").replaceAll("%cmd%", cmd).replaceAll("%time%", String.valueOf(cooldownPerm)));
                continue;
            }
            int time = (int)((this.getCooldown(e.getPlayer().getName(), cmd).getExpiry() - System.currentTimeMillis()) / 1000L);
            e.getPlayer().sendMessage(FileManager.cfg.getString("commandEnterAgain").replaceAll("&", "\u00a7").replaceAll("%cmd%", cmd).replaceAll("%time%", String.valueOf(time)));
            e.setCancelled(true);
        }
    }

    public void startCooldownTask() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (!cooldowns.isEmpty()) {
                    Iterator<Cooldown> it = cooldowns.iterator();
                    while (it.hasNext()) {
                        Cooldown cool = it.next();
                        if (cool.getExpiry() >= System.currentTimeMillis()) continue;
                        if (Bukkit.getPlayer((String)cool.getPlayerName()) != null) {
                            Bukkit.getPlayer((String)cool.getPlayerName()).sendMessage(FileManager.cfg.getString("commandExpired").replaceAll("&", "\u00a7").replaceAll("%cmd%", cool.getCommand()));
                        }
                        it.remove();
                    }
                }
                CommandCooldown.this.startCooldownTask();
            }
        }, 20L);
    }

    public boolean isCooldowned(String name, String cmd) {
        for (Cooldown cooldown : cooldowns) {
            if (!name.equalsIgnoreCase(cooldown.getPlayerName()) || !cooldown.getCommand().equalsIgnoreCase(cmd)) continue;
            return true;
        }
        return false;
    }

    public Cooldown getCooldown(String name, String cmd) {
        for (Cooldown cooldown : cooldowns) {
            if (!cooldown.getPlayerName().equals(name) || !cooldown.getCommand().equalsIgnoreCase(cmd)) continue;
            return cooldown;
        }
        return null;
    }

    public int getCooldownFromPerm(String perm, String cmd) {
        System.out.println("Cooldown: " + Integer.parseInt(perm.replace("commandcooldown." + cmd.replaceAll(" ", "_"), "")));
        return Integer.parseInt(perm.replace("commandcooldown." + cmd.replaceAll(" ", "_"), ""));
    }
}

