/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.falistos.CommandCooldown;

import java.util.HashMap;
import java.util.Map;

public class ReadableTimeConverter {
    private long time;
    private Map<Unit, String> units = new HashMap<Unit, String>();

    public ReadableTimeConverter(long time) {
        this.time = time;
        this.units.put(Unit.DAY, "day");
        this.units.put(Unit.HOUR, "hour");
        this.units.put(Unit.MINUTE, "minute");
        this.units.put(Unit.SECOND, "second");
    }

    public ReadableTimeConverter(long time, Map<Unit, String> units) {
        this.time = time;
        this.units = units;
    }

    public void setUnitsLocale(Map<Unit, String> units) {
        this.units = units;
    }

    public String get() {
        StringBuffer text = new StringBuffer("");
        long tmp = this.time;
        if (tmp >= (long)Unit.DAY.get()) {
            text.append(" ").append(tmp / (long)Unit.DAY.get()).append(" ").append(String.valueOf(this.units.get((Object)Unit.DAY)) + ReadableTimeConverter.getPlural(tmp / (long)Unit.DAY.get()));
            tmp %= (long)Unit.DAY.get();
        }
        if (tmp >= (long)Unit.HOUR.get()) {
            text.append(" ").append(tmp / (long)Unit.HOUR.get()).append(" ").append(String.valueOf(this.units.get((Object)Unit.HOUR)) + ReadableTimeConverter.getPlural(tmp / (long)Unit.HOUR.get()));
            tmp %= (long)Unit.HOUR.get();
        }
        if (tmp >= (long)Unit.MINUTE.get()) {
            text.append(" ").append(tmp / (long)Unit.MINUTE.get()).append(" ").append(String.valueOf(this.units.get((Object)Unit.MINUTE)) + ReadableTimeConverter.getPlural(tmp / (long)Unit.MINUTE.get()));
            tmp %= (long)Unit.MINUTE.get();
        }
        if (tmp >= (long)Unit.SECOND.get()) {
            String milliseconds = "";
            if (this.time < (long)Unit.SECOND.get()) {
                milliseconds = "." + tmp / 100L;
            }
            text.append(" ").append(tmp / (long)Unit.SECOND.get()).append(milliseconds).append(" ").append(String.valueOf(this.units.get((Object)Unit.SECOND)) + ReadableTimeConverter.getPlural(tmp / (long)Unit.SECOND.get()));
        } else {
            text.append(" ").append(tmp / (long)Unit.SECOND.get()).append("." + tmp / 100L).append(" ").append(String.valueOf(this.units.get((Object)Unit.SECOND)) + ReadableTimeConverter.getPlural(tmp / (long)Unit.SECOND.get()));
        }
        return text.toString().substring(1);
    }

    private static String getPlural(long unit) {
        if (unit > 1L) {
            return "s";
        }
        return "";
    }

    public static enum Unit {
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000),
        DAY(86400000);

        private int ms;

        private Unit(int ms) {
            this.ms = ms;
        }

        public int get() {
            return this.ms;
        }
    }
}

