/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.falistos.CommandCooldown;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerCommand {
    private String command;
    private List<String> linkedCommands;
    private Map<String, Long> cooldowns;
    private Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();

    public PlayerCommand(String command, List<String> linkedCommands, Map<String, Long> cooldowns) {
        this.command = command;
        this.linkedCommands = linkedCommands;
        this.cooldowns = cooldowns;
    }

    public String getMainCommand() {
        return this.command;
    }

    public List<String> getLinkedCommands() {
        return this.linkedCommands;
    }

    public List<String> getCommands() {
        List<String> list = this.getLinkedCommands();
        list.add(this.getMainCommand());
        return list;
    }

    public boolean contains(String command) {
        List<String> commands = this.getCommands();
        int i = 0;
        while (i < commands.size()) {
            if (commands.get(i).contains(command)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Map<String, Long> getPermissionCooldowns() {
        return this.cooldowns;
    }

    public Long getDefaultCooldown() {
        return this.getPermissionCooldowns().get("default");
    }

    public Long getCooldown(Player player) {
        Iterator<Map.Entry<String, Long>> iterator = this.getPermissionCooldowns().entrySet().iterator();
        Long cooldown = this.getDefaultCooldown();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() >= cooldown || !player.hasPermission("commandcooldown.permission." + entry.getKey())) continue;
            cooldown = entry.getValue();
        }
        return cooldown;
    }

    public Map<UUID, Long> getCooldowns() {
        return this.playerCooldowns;
    }

    public Long getTime(Player player) {
        if (this.getCooldowns().containsKey(player.getUniqueId())) {
            return this.getCooldowns().get(player.getUniqueId());
        }
        return null;
    }

    public Long getTimeLeft(Player player) {
        if (!this.isOnCooldown(player)) {
            return null;
        }
        return this.getTime(player) - System.currentTimeMillis();
    }

    public boolean isOnCooldown(Player player) {
        if (this.getTime(player) == null || System.currentTimeMillis() > this.getTime(player)) {
            this.removeCooldown(player);
            return false;
        }
        return true;
    }

    public void resetCooldown(Player player) {
        this.getCooldowns().put(player.getUniqueId(), System.currentTimeMillis() + this.getCooldown(player));
    }

    public void removeCooldown(Player player) {
        if (this.getCooldowns().containsKey(player.getUniqueId())) {
            this.getCooldowns().remove(player.getUniqueId());
        }
    }

    public void cleanCooldowns() {
        for (UUID uuid : this.getCooldowns().keySet()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null && player.isOnline()) {
                return;
            }
            if (this.isOnCooldown(player)) {
                return;
            }
            this.removeCooldown(player);
        }
    }
}

