/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.falistos.CommandCooldown;

import com.gmail.falistos.CommandCooldown.PlayerCommand;
import com.gmail.falistos.CommandCooldown.ReadableTimeConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandCooldown
extends JavaPlugin
implements Listener {
    private List<PlayerCommand> registeredCommands = new ArrayList<PlayerCommand>();
    private int taskId;
    private HashMap<ReadableTimeConverter.Unit, String> units = new HashMap();

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.reloadCommands();
        this.startCleanTask();
        this.units.put(ReadableTimeConverter.Unit.DAY, this.getConfig().getString("messages.day"));
        this.units.put(ReadableTimeConverter.Unit.HOUR, this.getConfig().getString("messages.hour"));
        this.units.put(ReadableTimeConverter.Unit.MINUTE, this.getConfig().getString("messages.minute"));
        this.units.put(ReadableTimeConverter.Unit.SECOND, this.getConfig().getString("messages.second"));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void reloadCommands() {
        this.getRegisteredCommands().clear();
        ConfigurationSection section = this.getConfig().getConfigurationSection("commands");
        for (String command : section.getKeys(false)) {
            HashMap<String, Long> cooldown = new HashMap<String, Long>();
            if (section.isInt(command)) {
                cooldown.put("default", section.getLong(command) * 1000L);
            } else if (section.isInt(String.valueOf(command) + ".cooldown")) {
                cooldown.put("default", section.getLong(String.valueOf(command) + ".cooldown") * 1000L);
            } else if (section.isConfigurationSection(String.valueOf(command) + ".cooldown")) {
                ConfigurationSection cooldownSection = section.getConfigurationSection(String.valueOf(command) + ".cooldown");
                for (String permission : cooldownSection.getKeys(false)) {
                    if (!cooldownSection.isInt(permission)) {
                        this.getLogger().warning("Couldn't load command " + command + ": Permission cooldown " + permission + " is not an integer");
                        continue;
                    }
                    cooldown.put(permission, cooldownSection.getLong(permission) * 1000L);
                }
            } else {
                this.getLogger().warning("Couldn't load command " + command + ": No cooldowns defined");
                return;
            }
            this.registerCommand(command, section.getStringList(String.valueOf(command) + ".linked"), cooldown);
        }
    }

    public void registerCommand(String command, List<String> linkedCommands, Map<String, Long> cooldown) {
        if (!cooldown.containsKey("default")) {
            this.getLogger().warning("Couldn't load command " + command + ": No default cooldown defined");
            return;
        }
        this.getRegisteredCommands().add(new PlayerCommand(command, linkedCommands, cooldown));
    }

    public List<PlayerCommand> getRegisteredCommands() {
        return this.registeredCommands;
    }

    public PlayerCommand getCommandObject(String command) {
        int i = 0;
        while (i < this.getRegisteredCommands().size()) {
            List<String> commands = this.getRegisteredCommands().get(i).getCommands();
            int a = 0;
            while (a < commands.size()) {
                String registered = commands.get(a);
                if (registered.contains(command)) {
                    return this.getRegisteredCommands().get(i);
                }
                ++a;
            }
            ++i;
        }
        return null;
    }

    private void startCleanTask() {
        if (Bukkit.getServer().getScheduler().isCurrentlyRunning(this.taskId)) {
            Bukkit.getServer().getScheduler().cancelTask(this.taskId);
        }
        this.taskId = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CommandCooldown.this.getRegisteredCommands().size()) {
                    CommandCooldown.this.getRegisteredCommands().get(i).cleanCooldowns();
                    ++i;
                }
            }
        }, 20L, 1200L);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("commandcooldown")) {
            if (args.length == 0) {
                sender.sendMessage(ChatColor.RED + "/commandcooldown [reload|info]");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("commandcooldown.reload")) {
                    this.reloadConfig();
                    this.reloadCommands();
                    sender.sendMessage(ChatColor.GREEN + this.getName() + " version " + this.getDescription().getVersion() + " reloaded.");
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.noPermission")));
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                sender.sendMessage(ChatColor.GOLD + this.getName() + "\n" + ChatColor.GREEN + "Version " + this.getDescription().getVersion() + "\n" + ChatColor.LIGHT_PURPLE + "Created by Falistos (falistos@gmail.fr)");
                return true;
            }
            sender.sendMessage(ChatColor.RED + "/commandcooldown [reload|info]");
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase().substring(1);
        if (player.hasPermission("commandcooldown.bypass")) {
            return;
        }
        PlayerCommand commandObject = this.getCommandObject(command);
        PlayerCommand globalObject = this.getCommandObject("global");
        if (commandObject == null && globalObject == null) {
            return;
        }
        PlayerCommand appliedObject = null;
        if (commandObject != null && commandObject.isOnCooldown(player)) {
            appliedObject = commandObject;
        } else if (globalObject != null && globalObject.isOnCooldown(player)) {
            appliedObject = globalObject;
        }
        if (appliedObject != null) {
            String timeleft = new ReadableTimeConverter(appliedObject.getTimeLeft(player), this.units).get();
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.onCooldown").replace("<timeleft>", timeleft).replace("<command>", command)));
            event.setCancelled(true);
        } else {
            if (commandObject != null) {
                commandObject.resetCooldown(player);
            }
            if (globalObject != null) {
                globalObject.resetCooldown(player);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        int i = 0;
        while (i < this.getRegisteredCommands().size()) {
            this.getRegisteredCommands().get(i).removeCooldown(event.getPlayer());
            ++i;
        }
    }
}

