/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Message;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Chunks plugin;
    private final int resourceId;

    public UpdateChecker(Chunks plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                Scanner scanner = new Scanner(inputStream);
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                    scanner.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Message.sendLog(e.getMessage());
            }
        });
    }

    public void getUpdate() {
        if (this.plugin.getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(this.plugin, this.resourceId).getVersion(latest -> {
                if (this.plugin.getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    Message.sendLog("You are using the latest version");
                } else {
                    Message.sendLog("New update: " + latest);
                    Message.sendLog("Current version: " + this.plugin.getDescription().getVersion());
                }
            });
        }
    }

    public void sendMessage(Player player) {
        if (this.plugin.getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(this.plugin, this.resourceId).getVersion(latest -> {
                if (!this.plugin.getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    Message.sendMessage((CommandSender)player, "&6" + this.plugin.getName() + " Update:");
                    Message.sendMessage((CommandSender)player, "&6new release: &f" + latest);
                    Message.sendMessage((CommandSender)player, "&6current: &f" + this.plugin.getDescription().getVersion());
                }
            });
        }
    }
}

