/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.player;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.ChunkConfig;
import net.achymake.chunks.files.Message;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChunkVisitor
implements Listener {
    public ChunkVisitor(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChunkVisitor(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getPlayer().getLocation().getChunk();
        ChunkConfig chunkConfig = Chunks.getChunkConfig();
        if (chunkConfig.isClaimed(chunk)) {
            if (player.getPersistentDataContainer().has(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING)) {
                if (!((String)player.getPersistentDataContainer().get(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING)).equals(chunkConfig.getOwner(chunk).getName())) {
                    player.getPersistentDataContainer().remove(NamespacedKey.minecraft((String)"chunk-visitor"));
                }
            } else {
                Message.sendActionBar(player, "event.visit", chunkConfig.getOwner(chunk).getName());
                player.getPersistentDataContainer().set(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING, (Object)chunkConfig.getOwner(chunk).getName());
            }
        } else if (chunkConfig.isProtected(chunk)) {
            if (player.getPersistentDataContainer().has(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING)) {
                if (!((String)player.getPersistentDataContainer().get(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING)).equals("Server")) {
                    player.getPersistentDataContainer().remove(NamespacedKey.minecraft((String)"chunk-visitor"));
                }
            } else {
                player.getPersistentDataContainer().set(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING, (Object)"Server");
                String chunkOwner = (String)player.getPersistentDataContainer().get(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING);
                Message.sendActionBar(player, "event.visit", chunkOwner);
            }
        } else if (player.getPersistentDataContainer().has(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING)) {
            String chunkOwner = (String)player.getPersistentDataContainer().get(NamespacedKey.minecraft((String)"chunk-visitor"), PersistentDataType.STRING);
            Message.sendActionBar(player, "event.exit", chunkOwner);
            player.getPersistentDataContainer().remove(NamespacedKey.minecraft((String)"chunk-visitor"));
        }
    }
}

