/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.pets.skeletonhorse;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedTamedSkeletonHorse
implements Listener {
    public PlayerDamagedTamedSkeletonHorse(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteractEntity(EntityDamageByEntityEvent event) {
        if (!Config.get().getBoolean("claimed.protect-tamed-outside")) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.SKELETON_HORSE)) {
            return;
        }
        Player player = (Player)event.getDamager();
        SkeletonHorse pet = (SkeletonHorse)event.getEntity();
        if (!pet.isTamed()) {
            return;
        }
        if (pet.getOwner() == player) {
            return;
        }
        if (Chunks.getChunkConfig().hasChunkEdit(player)) {
            return;
        }
        event.setCancelled(true);
        Message.sendActionBar(player, "event.damaged.tamed", pet.getOwner().getName());
    }
}

