/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.pets.mule;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedTamedMuleWithThrownPotion
implements Listener {
    public PlayerDamagedTamedMuleWithThrownPotion(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamagedByArrow(EntityDamageByEntityEvent event) {
        if (!Config.get().getBoolean("claimed.protect-tamed-outside")) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.SPLASH_POTION)) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.MULE)) {
            return;
        }
        Mule pet = (Mule)event.getEntity();
        if (!pet.isTamed()) {
            return;
        }
        ThrownPotion damager = (ThrownPotion)event.getDamager();
        if (damager.getShooter() instanceof Player) {
            if (damager.getShooter() == null) {
                return;
            }
            Player player = (Player)damager.getShooter();
            if (pet.getOwner() == player) {
                return;
            }
            if (Chunks.getChunkConfig().hasChunkEdit(player)) {
                return;
            }
            event.setCancelled(true);
            Message.sendActionBar(player, "event.damaged.tamed", pet.getOwner().getName());
        }
    }
}

