/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.pets.llama;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedTamedLlamaWithSnowball
implements Listener {
    public PlayerDamagedTamedLlamaWithSnowball(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamagedByArrow(EntityDamageByEntityEvent event) {
        if (!Config.get().getBoolean("claimed.protect-tamed-outside")) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.SNOWBALL)) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.LLAMA)) {
            return;
        }
        Llama pet = (Llama)event.getEntity();
        if (!pet.isTamed()) {
            return;
        }
        Snowball damager = (Snowball)event.getDamager();
        if (damager.getShooter() instanceof Player) {
            if (damager.getShooter() == null) {
                return;
            }
            if (pet.getOwner() == damager.getShooter()) {
                return;
            }
            if (Chunks.getChunkConfig().hasChunkEdit((Player)damager.getShooter())) {
                return;
            }
            event.setCancelled(true);
            Message.sendActionBar((Player)damager.getShooter(), "event.damaged.tamed", pet.getOwner().getName());
        }
    }
}

