/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.pets.horse;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedTamedHorse
implements Listener {
    public PlayerDamagedTamedHorse(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteractEntity(EntityDamageByEntityEvent event) {
        if (!Config.get().getBoolean("claimed.protect-tamed-outside")) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.HORSE)) {
            return;
        }
        Player player = (Player)event.getDamager();
        Horse pet = (Horse)event.getEntity();
        if (!pet.isTamed()) {
            return;
        }
        if (pet.getOwner() == player) {
            return;
        }
        if (Chunks.getChunkConfig().hasChunkEdit(player)) {
            return;
        }
        event.setCancelled(true);
        Message.sendActionBar(player, "event.damaged.tamed", pet.getOwner().getName());
    }
}

