/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.interact;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class InteractProtected
implements Listener {
    public InteractProtected(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!Chunks.getChunkConfig().isProtected(event.getClickedBlock().getChunk())) {
            return;
        }
        if (Chunks.getChunkConfig().hasAccess(event.getPlayer(), event.getClickedBlock().getChunk())) {
            return;
        }
        if (Config.get().getStringList("protected.ignore.materials").contains(event.getClickedBlock().getType().toString())) {
            return;
        }
        if (Tag.STAIRS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        if (Tag.SLABS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        if (Tag.CARPETS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        if (Tag.SIGNS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        event.setCancelled(true);
        Message.sendActionBar(event.getPlayer(), "event.interact.protected");
    }
}

