/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.entity;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedEntityWithSpectralArrowClaimed
implements Listener {
    public PlayerDamagedEntityWithSpectralArrowClaimed(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamagedBySpectralArrow(EntityDamageByEntityEvent event) {
        if (!Chunks.getChunkConfig().isClaimed(event.getEntity().getLocation().getChunk())) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.SPECTRAL_ARROW)) {
            return;
        }
        if (event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        SpectralArrow damager = (SpectralArrow)event.getDamager();
        if (damager.getShooter() instanceof Player) {
            if (damager.getShooter() == null) {
                return;
            }
            if (Chunks.getChunkConfig().hasAccess((Player)damager.getShooter(), event.getEntity().getLocation().getChunk())) {
                return;
            }
            if (Config.get().getStringList("hostiles").contains(event.getEntity().getType().toString())) {
                return;
            }
            event.setCancelled(true);
            Message.sendActionBar((Player)damager.getShooter(), "event.damaged-by.spectral-arrow.claimed", Chunks.getChunkConfig().getOwner(event.getEntity().getLocation().getChunk()).getName());
        }
    }
}

