/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.entity;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedEntityWithSnowballClaimed
implements Listener {
    public PlayerDamagedEntityWithSnowballClaimed(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamagedBySnowball(EntityDamageByEntityEvent event) {
        if (!Chunks.getChunkConfig().isClaimed(event.getEntity().getLocation().getChunk())) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.SNOWBALL)) {
            return;
        }
        if (event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Snowball damager = (Snowball)event.getDamager();
        if (damager.getShooter() instanceof Player) {
            if (damager.getShooter() == null) {
                return;
            }
            if (Chunks.getChunkConfig().hasAccess((Player)damager.getShooter(), event.getEntity().getLocation().getChunk())) {
                return;
            }
            if (Config.get().getStringList("hostiles").contains(event.getEntity().getType().toString())) {
                return;
            }
            event.setCancelled(true);
            Message.sendActionBar((Player)damager.getShooter(), "event.damaged-by.snowball.claimed", Chunks.getChunkConfig().getOwner(event.getEntity().getLocation().getChunk()).getName());
        }
    }
}

