/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.listeners.entity;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDamagedEntityWithArrowClaimed
implements Listener {
    public PlayerDamagedEntityWithArrowClaimed(Chunks plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamagedByArrow(EntityDamageByEntityEvent event) {
        if (!Chunks.getChunkConfig().isClaimed(event.getEntity().getLocation().getChunk())) {
            return;
        }
        if (!event.getDamager().getType().equals((Object)EntityType.ARROW)) {
            return;
        }
        if (event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        if (Config.get().getStringList("hostiles").contains(event.getEntity().getType().toString())) {
            return;
        }
        Arrow damager = (Arrow)event.getDamager();
        if (damager.getShooter() instanceof Player) {
            if (damager.getShooter() == null) {
                return;
            }
            if (Chunks.getChunkConfig().hasAccess((Player)damager.getShooter(), event.getEntity().getLocation().getChunk())) {
                return;
            }
            event.setCancelled(true);
            Message.sendActionBar((Player)damager.getShooter(), "event.damaged-by.arrow.claimed", Chunks.getChunkConfig().getOwner(event.getEntity().getLocation().getChunk()).getName());
        }
    }
}

