/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.files;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Message;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerConfig {
    public static boolean exist(OfflinePlayer offlinePlayer) {
        return new File(Chunks.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml").exists();
    }

    public static void create(OfflinePlayer offlinePlayer) {
        File folder = new File(Chunks.getInstance().getDataFolder(), "userdata");
        File file = new File(Chunks.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (file.exists()) {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            if (!configuration.getString("name").equals(offlinePlayer.getName())) {
                configuration.set("name", (Object)offlinePlayer.getName());
                try {
                    configuration.save(file);
                }
                catch (IOException e) {
                    Message.sendLog(e.getMessage());
                }
            }
        } else {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            configuration.set("name", (Object)offlinePlayer.getName());
            configuration.set("chunks.claimed", (Object)0);
            configuration.createSection("members");
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                Message.sendLog(e.getMessage());
            }
        }
    }

    public static FileConfiguration get(OfflinePlayer offlinePlayer) {
        File file = new File(Chunks.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static void setStringList(OfflinePlayer offlinePlayer, String type, List<String> value) {
        File file = new File(Chunks.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setInt(OfflinePlayer offlinePlayer, String type, int value) {
        File file = new File(Chunks.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, (Object)value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }
}

