/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.files;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.achymake.chunks.Chunks;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Message {
    private static File file = new File(Chunks.getInstance().getDataFolder(), "message.yml");
    private static FileConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static FileConfiguration get() {
        return config;
    }

    public static void setup() {
        config.addDefault("command.chunk.claim.error.protected", (Object)"&cChunk is claimed by Server");
        config.addDefault("command.chunk.claim.error.owned", (Object)"&cYou already own this Chunk");
        config.addDefault("command.chunk.claim.error.claimed", (Object)"&cChunk is already owned by&f {0}");
        config.addDefault("command.chunk.claim.error.insufficient-funds", (Object)"&cYou do not have&a {0}&c to claim this Chunk");
        config.addDefault("command.chunk.claim.error.reached-limit", (Object)"&cYou reached your limit of&f {0}&c claims");
        config.addDefault("command.chunk.claim.success", (Object)"&6You claimed a Chunk for&a {0}");
        config.addDefault("command.chunk.help.title", (Object)"&6Chunk Help:");
        config.addDefault("command.chunk.help.claim", (Object)"/chunk claim &7- claims current chunk");
        config.addDefault("command.chunk.help.help", (Object)"/chunk help &7- show this list");
        ArrayList<String> members = new ArrayList<String>();
        members.add("/chunk members &7- check members");
        members.add("/chunk members add player &7- Add player to members");
        members.add("/chunk members remove player &7- Remove player from members");
        config.addDefault("command.chunk.help.members", members);
        config.addDefault("command.chunk.help.tnt", (Object)"/chunk tnt &7- toggle tnt");
        config.addDefault("command.chunk.help.unclaim", (Object)"/chunk unclaim &7- unclaims current chunk");
        config.addDefault("command.chunk.members.empty", (Object)"&6You do not have any members");
        config.addDefault("command.chunk.members.title", (Object)"&6Members:");
        config.addDefault("command.chunk.members.listed", (Object)"- {0}");
        config.addDefault("command.chunk.members.add.error.member", (Object)"{0}&c is already a member");
        config.addDefault("command.chunk.members.add.success", (Object)"{0}&6 is added to members");
        config.addDefault("command.chunk.members.remove.error.non-member", (Object)"{0}&c is not a member");
        config.addDefault("command.chunk.members.remove.success", (Object)"{0}&6 is removed from members");
        config.addDefault("command.chunk.tnt.error.protected", (Object)"&cChunk is protected by Server");
        config.addDefault("command.chunk.tnt.error.claimed", (Object)"&cChunk is owned by&f {0}");
        config.addDefault("command.chunk.tnt.error.unclaimed", (Object)"&cChunk is unclaimed");
        config.addDefault("command.chunk.tnt.enabled", (Object)"&6Chunk enabled TNT");
        config.addDefault("command.chunk.tnt.disabled", (Object)"&6Chunk disabled TNT");
        config.addDefault("command.chunk.unclaim.error.protected", (Object)"&cChunk is protected by&f Server");
        config.addDefault("command.chunk.unclaim.error.claimed", (Object)"&cChunk is owned by&f {0}");
        config.addDefault("command.chunk.unclaim.error.unclaimed", (Object)"&cChunk is already unclaimed");
        config.addDefault("command.chunk.unclaim.success", (Object)"&6You unclaimed a chunk and got refunded&a {0}");
        config.addDefault("command.chunks.delete.success", (Object)"&6You safely unclaimed&f {0}&6's Chunk");
        config.addDefault("command.chunks.delete.error", (Object)"&6Chunk is already unclaimed");
        config.addDefault("command.chunks.edit.enabled", (Object)"&6You entered Chunk Edit");
        config.addDefault("command.chunks.edit.disabled", (Object)"&6You Exited Chunk Edit");
        config.addDefault("command.chunks.effect.claim", (Object)"&6Started the effects of Claiming Chunks");
        config.addDefault("command.chunks.effect.unclaim", (Object)"&6Started the effects of Unclaiming Chunks");
        config.addDefault("command.chunks.help.title", (Object)"&6Chunks Help:");
        config.addDefault("command.chunks.help.delete", (Object)"/chunks delete &7- Safely unclaims a chunk");
        config.addDefault("command.chunks.help.edit", (Object)"/chunks edit &7- toggle chunk edit");
        config.addDefault("command.chunks.help.effect", (Object)"/chunks effect claim &7- start effect of claiming");
        config.addDefault("command.chunks.help.help", (Object)"/chunks help &7- check this list");
        config.addDefault("command.chunks.help.info", (Object)"/chunks info &7- check chunk info");
        config.addDefault("command.chunks.help.protect", (Object)"/chunks protect &7- protect chunk");
        config.addDefault("command.chunks.help.reload", (Object)"/chunks reload &7- reload files");
        config.addDefault("command.chunks.help.unprotect", (Object)"/chunks unprotect &7- unprotect a chunk");
        config.addDefault("command.chunks.info.owner", (Object)"&6Chunk Owner: {0}");
        config.addDefault("command.chunks.info.date-claimed", (Object)"&6Date Claimed: {0}");
        config.addDefault("command.chunks.info.members.none", (Object)"{0}&6 has no members");
        config.addDefault("command.chunks.info.members.title", (Object)"&6Members:");
        config.addDefault("command.chunks.info.members.listed", (Object)"- {0}");
        config.addDefault("command.chunks.protect.error.protected", (Object)"&cChunk is already protected by Server");
        config.addDefault("command.chunks.protect.error.claimed", (Object)"&cChunk is owned by&f {0}");
        config.addDefault("command.chunks.protect.success", (Object)"&6Chunk is now protected by Server");
        config.addDefault("command.chunks.reload", (Object)"&6Chunks reloaded");
        config.addDefault("command.chunks.unprotect.error.unprotected", (Object)"&cChunk is already unprotected");
        config.addDefault("command.chunks.unprotect.error.claimed", (Object)"&cChunk is owned by&f {0}");
        config.addDefault("command.chunks.unprotect.success", (Object)"&6Chunk is now unprotected");
        config.addDefault("event.visit", (Object)"&6Visiting&f {0}&6's Chunk");
        config.addDefault("event.exit", (Object)"&6Exiting&f {0}&6's Chunk");
        config.addDefault("event.block-break.claimed", (Object)"&cYou are not allowed to break blocks on&f {0}&c's Chunk");
        config.addDefault("event.block-place.claimed", (Object)"&cYou are not allowed to place blocks on {0}&c's Chunk");
        config.addDefault("event.bucket-empty.claimed", (Object)"&cYou are not allowed to empty buckets on&f {0}&c's Chunk");
        config.addDefault("event.bucket-fill.claimed", (Object)"&cYou are not allowed to fill buckets on&f {0}&c's Chunk");
        config.addDefault("event.damaged-by.arrow.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.damaged-by.player.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.damaged-by.potions.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.damaged-by.snowball.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.damaged-by.spectral-arrow.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.damaged-by.trident.claimed", (Object)"&cYou are not allowed to damage&f {0}&c's Mobs");
        config.addDefault("event.interact.claimed", (Object)"&cYou are not allowed to interact on&f {0}&c's Chunk");
        config.addDefault("event.interact-entity.claimed", (Object)"&cYou are not allowed to interact&f {0}&c's Mobs");
        config.addDefault("event.block-break.protected", (Object)"&cYou are not allowed to break blocks on&f Server&c's Chunk");
        config.addDefault("event.block-place.protected", (Object)"&cYou are not allowed to place blocks on&f Server&c's Chunk");
        config.addDefault("event.bucket-empty.protected", (Object)"&cYou are not allowed to empty buckets on&f Server&c's Chunk");
        config.addDefault("event.bucket-fill.protected", (Object)"&cYou are not allowed to fill buckets on&f Server&c's Chunk");
        config.addDefault("event.damaged-by.arrow.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs}");
        config.addDefault("event.damaged-by.player.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs");
        config.addDefault("event.damaged-by.potions.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs");
        config.addDefault("event.damaged-by.snowball.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs");
        config.addDefault("event.damaged-by.spectral-arrow.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs");
        config.addDefault("event.damaged-by.trident.protected", (Object)"&cYou are not allowed to damage&f Server&c's Mobs");
        config.addDefault("event.interact.protected", (Object)"&cYou are not allowed to interact&f Server&c's Chunk");
        config.addDefault("event.interact-entity.protected", (Object)"&cYou are not allowed to interact&f Server&c's Mobs");
        config.addDefault("event.damaged.tamed", (Object)"&cYou are not allowed to damage&f {0}&c's pets");
        config.options().copyDefaults(true);
        Message.save();
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void sendMessage(CommandSender sender, String type) {
        if (config.isString(type)) {
            if (!config.getString(type).equals("")) {
                sender.sendMessage(Message.color(Message.get().getString(type)));
            }
        } else if (config.isList(type)) {
            for (String messages : Message.get().getStringList(type)) {
                sender.sendMessage(Message.color(messages));
            }
        }
    }

    public static void sendMessage(CommandSender sender, String type, String placeholders) {
        if (config.isString(type)) {
            if (!config.getString(type).equals("")) {
                sender.sendMessage(Message.color(MessageFormat.format(config.getString(type), placeholders)));
            }
        } else if (config.isList(type)) {
            for (String messages : config.getStringList(type)) {
                sender.sendMessage(Message.color(MessageFormat.format(messages, placeholders)));
            }
        }
    }

    public static void sendActionBar(Player player, String type) {
        if (config.isString(type) && !config.getString(type).equals("")) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Message.color(config.getString(type))));
        }
    }

    public static void sendActionBar(Player player, String type, String placeholder) {
        if (config.isString(type) && !config.getString(type).equals("")) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Message.color(MessageFormat.format(config.getString(type), placeholder))));
        }
    }

    public static void sendLog(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage("[" + Chunks.getInstance().getName() + "] " + message);
    }

    public static String color(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

