/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.files;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.chunks.Chunks;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ChunkConfig {
    private final List<Player> chunkEditors = new ArrayList<Player>();
    private final Chunks plugin;

    public ChunkConfig(Chunks plugin) {
        this.plugin = plugin;
    }

    public PersistentDataContainer getData(Chunk chunk) {
        return chunk.getPersistentDataContainer();
    }

    public boolean hasAccess(Player player, Chunk chunk) {
        if (this.isClaimed(chunk)) {
            if (this.isOwner(player, chunk)) {
                return true;
            }
            if (this.isMember(player, chunk)) {
                return true;
            }
            return this.hasChunkEdit(player);
        }
        if (this.isProtected(chunk)) {
            return this.hasChunkEdit(player);
        }
        return true;
    }

    public boolean hasChunkEdit(Player player) {
        return this.chunkEditors.contains(player);
    }

    public boolean isClaimed(Chunk chunk) {
        return this.getData(chunk).has(NamespacedKey.minecraft((String)"owner"), PersistentDataType.STRING);
    }

    public boolean isProtected(Chunk chunk) {
        return this.getData(chunk).has(NamespacedKey.minecraft((String)"protected"), PersistentDataType.STRING);
    }

    public boolean isOwner(Player player, Chunk chunk) {
        return this.getOwner(chunk) == player;
    }

    public boolean TNTAllowed(Chunk chunk) {
        return this.getData(chunk).has(NamespacedKey.minecraft((String)"tnt"), PersistentDataType.STRING);
    }

    public OfflinePlayer getOwner(Chunk chunk) {
        String uuidString = (String)this.getData(chunk).get(NamespacedKey.minecraft((String)"owner"), PersistentDataType.STRING);
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuidString));
    }

    public String getDateClaimed(Chunk chunk) {
        return (String)this.getData(chunk).get(NamespacedKey.minecraft((String)"date-claimed"), PersistentDataType.STRING);
    }

    public boolean isMember(Player player, Chunk chunk) {
        return PlayerConfig.get(this.getOwner(chunk)).getStringList("members").contains(player.getUniqueId().toString());
    }

    public List<String> getMembers(Chunk chunk) {
        ArrayList<String> names = new ArrayList<String>();
        for (String uuidString : PlayerConfig.get(this.getOwner(chunk)).getStringList("members")) {
            names.add(Chunks.getInstance().getServer().getOfflinePlayer(UUID.fromString(uuidString)).getName());
        }
        return names;
    }

    public List<UUID> getMembersUUID(Chunk chunk) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String uuidString : PlayerConfig.get(this.getOwner(chunk)).getStringList("members")) {
            uuids.add(UUID.fromString(uuidString));
        }
        return uuids;
    }

    public void startClaimEffect(Player player) {
        Location locationSouth = new Location(player.getWorld(), (double)player.getLocation().getChunk().getBlock(15, 0, 8).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(15, 0, 8).getZ());
        Location locationEast = new Location(player.getWorld(), (double)player.getLocation().getChunk().getBlock(8, 0, 15).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(8, 0, 15).getZ());
        player.playSound(player.getLocation(), Sound.valueOf((String)Config.get().getString("claim.sound.type")), Float.parseFloat(Config.get().getString("claim.sound.volume")), Float.parseFloat(Config.get().getString("claim.sound.pitch")));
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("claim.particle.type")), (double)player.getLocation().getChunk().getBlock(8, 0, 0).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(8, 0, 0).getZ(), 250, 4.0, 12.0, 0.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("claim.particle.type")), (double)player.getLocation().getChunk().getBlock(0, 0, 8).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(0, 0, 8).getZ(), 250, 0.0, 12.0, 4.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("claim.particle.type")), locationSouth.add(1.0, 0.0, 0.0), 250, 0.0, 12.0, 4.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("claim.particle.type")), locationEast.add(0.0, 0.0, 1.0), 250, 4.0, 12.0, 0.0, 0.0);
    }

    public void startUnclaimEffect(Player player) {
        Location locationSouth = new Location(player.getWorld(), (double)player.getLocation().getChunk().getBlock(15, 0, 8).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(15, 0, 8).getZ());
        Location locationEast = new Location(player.getWorld(), (double)player.getLocation().getChunk().getBlock(8, 0, 15).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(8, 0, 15).getZ());
        player.playSound(player.getLocation(), Sound.valueOf((String)Config.get().getString("unclaim.sound.type")), Float.parseFloat(Config.get().getString("unclaim.sound.volume")), Float.parseFloat(Config.get().getString("unclaim.sound.pitch")));
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("unclaim.particle.type")), (double)player.getLocation().getChunk().getBlock(8, 0, 0).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(8, 0, 0).getZ(), 250, 4.0, 12.0, 0.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("unclaim.particle.type")), (double)player.getLocation().getChunk().getBlock(0, 0, 8).getX(), (double)(player.getLocation().getBlockY() - 3), (double)player.getLocation().getChunk().getBlock(0, 0, 8).getZ(), 250, 0.0, 12.0, 4.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("unclaim.particle.type")), locationSouth.add(1.0, 0.0, 0.0), 250, 0.0, 12.0, 4.0, 0.0);
        player.spawnParticle(Particle.valueOf((String)Config.get().getString("unclaim.particle.type")), locationEast.add(0.0, 0.0, 1.0), 250, 4.0, 12.0, 0.0, 0.0);
    }

    public void claim(Player player, Chunk chunk) {
        Chunks.getEconomy().withdrawPlayer((OfflinePlayer)player, Config.get().getDouble("claim.cost"));
        this.getData(chunk).set(NamespacedKey.minecraft((String)"owner"), PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        this.getData(chunk).set(NamespacedKey.minecraft((String)"date-claimed"), PersistentDataType.STRING, (Object)SimpleDateFormat.getDateInstance().format(player.getLastPlayed()));
        PlayerConfig.setInt(this.getOwner(chunk), "chunks.claimed", PlayerConfig.get(this.getOwner(chunk)).getInt("chunks.claimed") + 1);
    }

    public void unclaim(Chunk chunk) {
        PlayerConfig.setInt(this.getOwner(chunk), "chunks.claimed", PlayerConfig.get(this.getOwner(chunk)).getInt("chunks.claimed") - 1);
        Chunks.getEconomy().depositPlayer(this.getOwner(chunk), Config.get().getDouble("unclaim.refund"));
        this.getData(chunk).remove(NamespacedKey.minecraft((String)"date-claimed"));
        this.getData(chunk).remove(NamespacedKey.minecraft((String)"owner"));
    }

    public void protect(Chunk chunk) {
        this.getData(chunk).set(NamespacedKey.minecraft((String)"protected"), PersistentDataType.STRING, (Object)"true");
    }

    public void unprotect(Chunk chunk) {
        this.getData(chunk).remove(NamespacedKey.minecraft((String)"protected"));
    }

    public List<Player> getChunkEditors() {
        return this.chunkEditors;
    }

    public Chunks getPlugin() {
        return this.plugin;
    }
}

