/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.commands.main.sub;

import java.text.MessageFormat;
import java.util.UUID;
import net.achymake.chunks.Chunks;
import net.achymake.chunks.commands.main.ChunksSubCommand;
import net.achymake.chunks.files.Message;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Info
extends ChunksSubCommand {
    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String getDescription() {
        return "checks chunk info";
    }

    @Override
    public String getSyntax() {
        return "/chunks info";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender.hasPermission("chunks.command.chunks.info") && sender instanceof Player) {
            Player player = (Player)sender;
            Chunk chunk = player.getLocation().getChunk();
            if (Chunks.getChunkConfig().isClaimed(chunk)) {
                Message.sendMessage((CommandSender)player, MessageFormat.format("command.chunks.info.owner", Chunks.getChunkConfig().getOwner(chunk).getName()));
                Message.sendMessage((CommandSender)player, MessageFormat.format("command.chunks.info.date-claimed", Chunks.getChunkConfig().getDateClaimed(chunk)));
                if (Chunks.getChunkConfig().getMembers(player.getLocation().getChunk()).isEmpty()) {
                    Message.sendMessage((CommandSender)player, MessageFormat.format("command.chunks.info.members.none", Chunks.getChunkConfig().getOwner(chunk).getName()));
                } else {
                    Message.sendMessage((CommandSender)player, "command.chunks.info.members.title");
                    for (UUID uuid : Chunks.getChunkConfig().getMembersUUID(player.getLocation().getChunk())) {
                        Message.sendMessage((CommandSender)player, MessageFormat.format("command.chunks.info.members.listed", player.getServer().getOfflinePlayer(uuid).getName()));
                    }
                }
            }
        }
    }
}

