/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.chunks.commands.chunk.sub;

import net.achymake.chunks.Chunks;
import net.achymake.chunks.commands.chunk.ChunkSubCommand;
import net.achymake.chunks.files.Config;
import net.achymake.chunks.files.Message;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Unclaim
extends ChunkSubCommand {
    @Override
    public String getName() {
        return "unclaim";
    }

    @Override
    public String getDescription() {
        return "un-claims current chunk";
    }

    @Override
    public String getSyntax() {
        return "/chunk unclaim";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (player.hasPermission("chunks.command.chunk.unclaim")) {
            Chunk chunk = player.getLocation().getChunk();
            if (Chunks.getChunkConfig().isClaimed(chunk)) {
                if (Chunks.getChunkConfig().isOwner(player, chunk)) {
                    Message.sendMessage((CommandSender)player, "command.chunk.unclaim.success", Chunks.getEconomy().format(Config.get().getDouble("unclaim.refund")));
                    Chunks.getChunkConfig().unclaim(chunk);
                    Chunks.getChunkConfig().startUnclaimEffect(player);
                } else if (Chunks.getChunkConfig().isProtected(chunk)) {
                    Message.sendMessage((CommandSender)player, "command.chunk.unclaim.error.protected");
                } else {
                    Message.sendMessage((CommandSender)player, "command.chunk.unclaim.error.claimed", Chunks.getChunkConfig().getOwner(chunk).getName());
                }
            } else {
                Message.sendMessage((CommandSender)player, "command.chunk.unclaim.error.unclaimed");
            }
        }
    }
}

